---
generated_at: 2026-01-23 13:00:00
metrics:
  claims_total: 50
  claims_with_evidence: 48
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：業務要件一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：48 / 50、根拠なし：2
- 優先レビュー（高）
  1. **BR-045 VR/ARサポート**：OpenXR/WebXR実装の詳細確認が必要
  2. **BR-047 リソース暗号化**：PCK暗号化の具体的な実装詳細の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` - プロジェクト概要、2D/3Dゲームエンジン説明
- E-02: `scene/2d/` - 2Dシーンコンポーネント群（sprite_2d.cpp, camera_2d.cpp等）
- E-03: `scene/3d/` - 3Dシーンコンポーネント群（mesh_instance_3d.cpp, camera_3d.cpp等）
- E-04: `editor/` - エディタ実装（editor_node.cpp, editor_node.h等）
- E-05: `platform/` - プラットフォーム固有実装（android/, ios/, macos/, windows/, web/等）
- E-06: `scene/main/scene_tree.cpp` - シーンツリー管理
- E-07: `modules/gdscript/` - GDScript言語実装
- E-08: `modules/mono/` - C#サポート実装
- E-09: `core/extension/` - GDExtension実装
- E-10: `servers/rendering/` - レンダリングサーバー
- E-11: `modules/godot_physics_2d/` - 2D物理エンジン
- E-12: `modules/godot_physics_3d/` - 3D物理エンジン
- E-13: `modules/jolt_physics/` - Jolt物理エンジン統合
- E-14: `scene/audio/` - オーディオシステム
- E-15: `servers/audio/` - オーディオサーバー
- E-16: `core/input/` - 入力システム
- E-17: `scene/animation/` - アニメーションシステム
- E-18: `scene/gui/` - GUIコンポーネント群
- E-19: `core/io/` - ネットワーク/IO実装
- E-20: `modules/multiplayer/` - マルチプレイヤー実装
- E-21: `modules/websocket/` - WebSocket実装
- E-22: `modules/webrtc/` - WebRTC実装
- E-23: `modules/navigation_2d/` - 2Dナビゲーション
- E-24: `modules/navigation_3d/` - 3Dナビゲーション
- E-25: `editor/export/` - エクスポート機能
- E-26: `editor/import/` - インポート機能
- E-27: `core/string/translation.h` - 翻訳システム
- E-28: `modules/text_server_adv/` - 高度なテキストレンダリング
- E-29: `scene/3d/xr/` - XRノード
- E-30: `modules/openxr/` - OpenXR統合
- E-31: `modules/webxr/` - WebXR統合
- E-32: `core/crypto/` - 暗号化機能
- E-33: `main/performance.cpp` - パフォーマンスモニタリング
- E-34: `core/object/worker_thread_pool.h` - ワーカースレッドプール
- E-35: `core/register_core_types.cpp` - コア型登録
- E-36: `scene/register_scene_types.cpp` - シーン型登録
- E-37: `editor/editor_node.h` - エディタノードヘッダ
- E-38: `doc/classes/SceneTree.xml` - SceneTree APIドキュメント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BR-001: 2D/3Dゲーム開発統合環境の提供 | E-01, E-02, E-03, E-04 | ○ |
| C-02 | BR-002: クロスプラットフォーム対応 | E-01, E-05, E-25 | ○ |
| C-03 | BR-003: ノードベースシーン管理 | E-06, E-35, E-36, E-38 | ○ |
| C-04 | BR-004: GDScript言語サポート | E-07 | ○ |
| C-05 | BR-005: C#言語サポート | E-08 | ○ |
| C-06 | BR-006: スクリプト拡張機能（GDExtension） | E-09, E-35 | ○ |
| C-07 | BR-007: 2Dレンダリング機能 | E-02, E-10 | ○ |
| C-08 | BR-008: 3Dレンダリング機能 | E-03, E-10 | ○ |
| C-09 | BR-009: シェーダープログラミング | E-04, E-36 | ○ |
| C-10 | BR-010: グローバルイルミネーション | E-03 | ○ |
| C-11 | BR-011: 2D物理エンジン | E-11 | ○ |
| C-12 | BR-012: 3D物理エンジン | E-12, E-13 | ○ |
| C-13 | BR-013: オーディオシステム | E-14, E-15 | ○ |
| C-14 | BR-014: インタラクティブミュージック | E-14 | ○ |
| C-15 | BR-015: マルチデバイス入力対応 | E-16, E-35 | ○ |
| C-16 | BR-016: カスタム入力マッピング | E-16 | ○ |
| C-17 | BR-017: アニメーションプレイヤー | E-17 | ○ |
| C-18 | BR-018: アニメーションツリー | E-17 | ○ |
| C-19 | BR-019: スケルタルアニメーション | E-03 | ○ |
| C-20 | BR-020: Tweenアニメーション | E-17 | ○ |
| C-21 | BR-021: UI構築システム | E-18 | ○ |
| C-22 | BR-022: テーマシステム | E-18, E-36 | ○ |
| C-23 | BR-023: リッチテキスト表示 | E-18 | ○ |
| C-24 | BR-024: コードエディタ機能 | E-18 | ○ |
| C-25 | BR-025: TCP/UDP通信 | E-19, E-35 | ○ |
| C-26 | BR-026: HTTP通信 | E-19 | ○ |
| C-27 | BR-027: マルチプレイヤーシステム | E-20 | ○ |
| C-28 | BR-028: WebSocket/WebRTC | E-21, E-22 | ○ |
| C-29 | BR-029: 2Dパスファインディング | E-23 | ○ |
| C-30 | BR-030: 3Dパスファインディング | E-24 | ○ |
| C-31 | BR-031: 統合開発環境 | E-04, E-37 | ○ |
| C-32 | BR-032: シーン編集機能 | E-04 | ○ |
| C-33 | BR-033: インスペクタパネル | E-04 | ○ |
| C-34 | BR-034: ファイルシステムドック | E-04 | ○ |
| C-35 | BR-035: デバッガ統合 | E-04 | ○ |
| C-36 | BR-036: バージョン管理連携 | E-04 | ○ |
| C-37 | BR-037: アセットインポート | E-26 | ○ |
| C-38 | BR-038: リソースローダー | E-19, E-35 | ○ |
| C-39 | BR-039: シーンパッキング | E-36 | ○ |
| C-40 | BR-040: プロジェクトエクスポート | E-25 | ○ |
| C-41 | BR-041: エクスポートテンプレート管理 | E-25 | ○ |
| C-42 | BR-042: コード署名 | E-25 | ○ |
| C-43 | BR-043: 多言語サポート | E-27, E-35 | ○ |
| C-44 | BR-044: フォントレンダリング | E-28 | ○ |
| C-45 | BR-045: VR/ARサポート | E-29, E-30, E-31 | △ |
| C-46 | BR-046: 暗号化機能 | E-32, E-35 | ○ |
| C-47 | BR-047: リソース暗号化 | E-19 | △ |
| C-48 | BR-048: パフォーマンスモニタリング | E-33 | ○ |
| C-49 | BR-049: プロファイラ | E-04 | ○ |
| C-50 | BR-050: マルチスレッド処理 | E-34, E-35 | ○ |

## 4) 不足情報（Unknown / Missing）
- **BR-045 VR/ARサポート**：XR関連ディレクトリは存在するが、実際のXRデバイス対応状況の詳細確認が必要
  - 候補：OpenXRドキュメント / WebXR実装詳細 / デバイス互換性リスト
- **BR-047 リソース暗号化**：`file_access_encrypted.h` ヘッダは確認したが、PCKファイル暗号化の完全な実装フローの確認が必要
  - 候補：pck_packer.h / エクスポート設定での暗号化オプション

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - ゲームエンジン基盤（BR-001〜BR-003）：ソースコード構造から明確に確認可能
- **0: 低リスク** - スクリプティング（BR-004〜BR-006）：modules/配下に明確な実装あり
- **0: 低リスク** - グラフィックス（BR-007〜BR-010）：scene/2d/, scene/3d/, servers/rendering/に実装確認
- **0: 低リスク** - 物理演算（BR-011〜BR-012）：modules/配下に物理エンジン実装あり
- **0: 低リスク** - エディタ（BR-031〜BR-036）：editor/配下に包括的な実装あり
- **1: 中リスク** - XR対応（BR-045）：ディレクトリ存在確認のみ、実際の機能範囲は要確認
- **1: 中リスク** - リソース暗号化（BR-047）：ヘッダファイル確認のみ、実装詳細は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] BR-001〜BR-003: README.mdの記載とソースコード構造が一致しているか確認
- [ ] BR-004〜BR-006: 各スクリプト言語モジュールが正しく機能するか確認
- [ ] BR-007〜BR-012: レンダリングと物理エンジンの主要クラスが存在するか確認
- [ ] BR-031〜BR-036: エディタの主要機能がeditor/配下に実装されているか確認
- [ ] BR-040〜BR-042: エクスポート機能がplatform/の各プラットフォームと連携しているか確認
- [ ] BR-045: XR関連ディレクトリの実装完成度を確認（要重点レビュー）
- [ ] BR-047: PCK暗号化の実装がエクスポートワークフローに統合されているか確認（要重点レビュー）
