---
generated_at: 2026-01-23 12:30:00
metrics:
  claims_total: 80
  claims_with_evidence: 80
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：80 / 80、根拠なし：0
- 優先レビュー（高）
  1. 特になし：全機能に対してソースコードによる根拠が確認できます

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` - プロジェクト概要（2D/3Dクロスプラットフォームゲームエンジン）
- E-02: `scene/register_scene_types.cpp` - シーンタイプ登録（GUI、2D、3Dノードクラス）
- E-03: `servers/register_server_types.cpp` - サーバータイプ登録（Audio、Physics、Rendering等）
- E-04: `editor/register_editor_types.cpp` - エディタタイプ登録
- E-05: `core/` ディレクトリ - コアシステム実装
- E-06: `scene/2d/` ディレクトリ - 2Dシーンコンポーネント
- E-07: `scene/3d/` ディレクトリ - 3Dシーンコンポーネント
- E-08: `scene/gui/` ディレクトリ - GUIコンポーネント
- E-09: `scene/animation/` ディレクトリ - アニメーションシステム
- E-10: `servers/audio/` ディレクトリ - オーディオサーバー
- E-11: `servers/physics_2d/` ディレクトリ - 2D物理サーバー
- E-12: `servers/physics_3d/` ディレクトリ - 3D物理サーバー
- E-13: `servers/rendering/` ディレクトリ - レンダリングサーバー
- E-14: `modules/gdscript/` ディレクトリ - GDScriptモジュール
- E-15: `modules/mono/` ディレクトリ - C#モジュール
- E-16: `modules/gltf/` ディレクトリ - glTFインポーター
- E-17: `modules/websocket/` ディレクトリ - WebSocketモジュール
- E-18: `modules/multiplayer/` ディレクトリ - マルチプレイヤーモジュール
- E-19: `modules/openxr/` ディレクトリ - OpenXRモジュール
- E-20: `platform/windows/` ディレクトリ - Windowsプラットフォーム
- E-21: `platform/macos/` ディレクトリ - macOSプラットフォーム
- E-22: `platform/linuxbsd/` ディレクトリ - Linux/BSDプラットフォーム
- E-23: `platform/android/` ディレクトリ - Androidプラットフォーム
- E-24: `platform/ios/` ディレクトリ - iOSプラットフォーム
- E-25: `platform/web/` ディレクトリ - Webプラットフォーム
- E-26: `drivers/vulkan/` ディレクトリ - Vulkanドライバー
- E-27: `drivers/gles3/` ディレクトリ - OpenGL ES 3.0ドライバー
- E-28: `drivers/metal/` ディレクトリ - Metalドライバー
- E-29: `editor/` ディレクトリ - エディタ実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | シーンツリー管理 | E-02, E-05 | ○ |
| C-02 | ノードシステム | E-02, E-05 | ○ |
| C-03 | リソース管理 | E-05 | ○ |
| C-04 | プロジェクト設定 | E-05 | ○ |
| C-05 | 信号システム | E-05 | ○ |
| C-06 | 2Dレンダリング | E-02, E-06 | ○ |
| C-07 | 3Dレンダリング | E-02, E-07 | ○ |
| C-08 | カメラシステム | E-06, E-07 | ○ |
| C-09 | ライティング | E-07, E-13 | ○ |
| C-10 | パーティクルシステム | E-06, E-07 | ○ |
| C-11 | シェーダー | E-02, E-13 | ○ |
| C-12 | 環境設定 | E-07 | ○ |
| C-13 | Vulkan/OpenGL/Metal対応 | E-26, E-27, E-28 | ○ |
| C-14 | 2D物理シミュレーション | E-03, E-06, E-11 | ○ |
| C-15 | 3D物理シミュレーション | E-03, E-07, E-12 | ○ |
| C-16 | 衝突検出 | E-06, E-07 | ○ |
| C-17 | レイキャスト | E-06, E-07 | ○ |
| C-18 | ジョイント | E-07 | ○ |
| C-19 | オーディオ再生 | E-02, E-10 | ○ |
| C-20 | 空間オーディオ | E-06, E-07, E-10 | ○ |
| C-21 | オーディオエフェクト | E-03, E-10 | ○ |
| C-22 | オーディオバス | E-03, E-10 | ○ |
| C-23 | キーボード/マウス入力 | E-05 | ○ |
| C-24 | ゲームパッド対応 | E-05 | ○ |
| C-25 | タッチ入力 | E-05 | ○ |
| C-26 | 入力マッピング | E-05 | ○ |
| C-27 | UIコントロール | E-02, E-08 | ○ |
| C-28 | コンテナレイアウト | E-08 | ○ |
| C-29 | テーマシステム | E-02 | ○ |
| C-30 | リッチテキスト | E-08 | ○ |
| C-31 | AnimationPlayer | E-02, E-09 | ○ |
| C-32 | AnimationTree | E-02, E-09 | ○ |
| C-33 | Tween | E-02, E-09 | ○ |
| C-34 | スケルトン/ボーン | E-07 | ○ |
| C-35 | IK（逆運動学） | E-07 | ○ |
| C-36 | 2Dナビゲーション | E-03, E-06 | ○ |
| C-37 | 3Dナビゲーション | E-03, E-07 | ○ |
| C-38 | HTTPリクエスト | E-02 | ○ |
| C-39 | WebSocket | E-17 | ○ |
| C-40 | マルチプレイヤー | E-18 | ○ |
| C-41 | ENet | modules/enet/ | ○ |
| C-42 | GDScript | E-14 | ○ |
| C-43 | C#サポート | E-15 | ○ |
| C-44 | GDExtension | E-05 | ○ |
| C-45 | シーンエディタ | E-04, E-29 | ○ |
| C-46 | スクリプトエディタ | E-04, E-29 | ○ |
| C-47 | アニメーションエディタ | E-04, E-29 | ○ |
| C-48 | ファイルシステムドック | E-04 | ○ |
| C-49 | インスペクター | E-04, E-29 | ○ |
| C-50 | デバッガー | E-04, E-29 | ○ |
| C-51 | Windows対応 | E-20 | ○ |
| C-52 | macOS対応 | E-21 | ○ |
| C-53 | Linux対応 | E-22 | ○ |
| C-54 | Android対応 | E-23 | ○ |
| C-55 | iOS対応 | E-24 | ○ |
| C-56 | Web対応 | E-25 | ○ |
| C-57 | タイルマップシステム | E-02, E-06 | ○ |
| C-58 | タイルセット | E-02 | ○ |
| C-59 | GridMap | modules/gridmap/ | ○ |
| C-60 | CSG | modules/csg/ | ○ |
| C-61 | メッシュライブラリ | E-07 | ○ |
| C-62 | glTFインポート | E-16 | ○ |
| C-63 | FBXインポート | modules/fbx/ | ○ |
| C-64 | OBJインポート | E-04 | ○ |
| C-65 | 画像インポート | E-04 | ○ |
| C-66 | オーディオインポート | E-04 | ○ |
| C-67 | OpenXR対応 | E-19 | ○ |
| C-68 | XRノード | E-03, E-07 | ○ |
| C-69 | WebXR | modules/webxr/ | ○ |
| C-70 | TextServer | E-03 | ○ |
| C-71 | フォント管理 | E-02 | ○ |
| C-72 | 国際化 | E-05 | ○ |
| C-73 | タイマー | E-02 | ○ |
| C-74 | 正規表現 | modules/regex/ | ○ |
| C-75 | JSON処理 | E-05 | ○ |
| C-76 | 暗号化 | E-05 | ○ |
| C-77 | ZIP圧縮 | modules/zip/ | ○ |
| C-78 | Noiseジェネレーター | modules/noise/ | ○ |
| C-79 | LightmapGI | modules/lightmapper_rd/ | ○ |
| C-80 | VoxelGI | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし：全ての機能項目に対してソースコードによる根拠が確認されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全機能がソースコードの直接解析に基づいており、根拠が明確です

## 6) レビュアーチェックリスト（最小）
- [ ] 機能カテゴリの分類は適切か
- [ ] 機能名は正確かつ理解しやすいか
- [ ] 説明文は機能の本質を正しく伝えているか
- [ ] 備考欄のソースファイルパスは正確か
- [ ] 重要な機能の漏れはないか（例：特定のモジュールや拡張機能）
- [ ] CSVフォーマットはExcelで正しく開けるか（BOM、ダブルクォート）
