# 機能設計書 12-環境設定

## 概要

本ドキュメントは、Godotエンジンにおける環境設定機能（WorldEnvironment）の設計仕様を記述する。環境設定機能は、3Dシーンの視覚的な雰囲気を制御するための機能であり、背景、環境光、トーンマッピング、フォグ、SSR（スクリーンスペースリフレクション）、SSAO（アンビエントオクルージョン）などのポストプロセスエフェクトを管理する。

### 本機能の処理概要

**業務上の目的・背景**：3Dゲーム開発において、シーンの視覚的な品質と雰囲気はゲームプレイ体験に直結する。環境設定機能は、空や背景の表示、ライティングの全体的な印象、ポストプロセスエフェクトなどを一元管理し、開発者が効率的にシーンの視覚表現を調整できるようにする。

**機能の利用シーン**：
- 屋外シーンでの空と大気表現（Sky、フォグ）
- 室内シーンでの環境光設定（アンビエントライト）
- シネマティック表現のためのトーンマッピング調整
- リアルタイム反射（SSR）やアンビエントオクルージョン（SSAO）の設定
- カメラ属性（露出、DOF）との連携

**主要な処理内容**：
1. Environmentリソースの管理とWorld3Dへの適用
2. 背景モード（Sky、Color、Canvas）の設定
3. 環境光（アンビエント）とリフレクションソースの管理
4. トーンマッピング設定（Linear、Reinhard、Filmic、ACES、AGX）
5. SSR、SSAO、SDFGI、フォグなどのエフェクト制御
6. CameraAttributesによるカメラ連動設定

**関連システム・外部連携**：
- RenderingServer：環境設定のGPU側適用
- World3D：シナリオへの環境適用
- CameraAttributes：カメラ露出・DOF連携
- Compositor：カスタムポストプロセス

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | 3Dエディタ | 主画面 | 環境エフェクトのプレビュー表示 |

## 機能種別

リソース管理 / レンダリング設定

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| environment | Ref<Environment> | No | 環境設定リソース | 有効なEnvironmentリソース |
| camera_attributes | Ref<CameraAttributes> | No | カメラ属性 | 有効なCameraAttributesリソース |
| compositor | Ref<Compositor> | No | コンポジター設定 | 有効なCompositorリソース |

### 入力データソース

- .tresファイル（Environmentリソース）
- スクリプトからの動的設定
- エディタUIからの設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| environment_rid | RID | RenderingServerの環境設定ID |
| camera_attributes_rid | RID | カメラ属性のRID |
| compositor_rid | RID | コンポジターのRID |

### 出力先

- RenderingServer（レンダリングパイプライン設定）
- World3D（シナリオ環境設定）

## 処理フロー

### 処理シーケンス

```
1. WorldEnvironmentノードがシーンツリーに入る
   └─ NOTIFICATION_ENTER_TREEで初期化
2. 環境グループへの登録
   └─ "_world_environment_" + シナリオIDでグループ化
3. 現在の環境設定を更新
   └─ _update_current_environment()で適用
4. World3Dに環境を設定
   └─ world_3d->set_environment(environment)
```

### フローチャート

```mermaid
flowchart TD
    A[NOTIFICATION_ENTER_TREE] --> B{environmentが有効?}
    B -->|Yes| C[環境グループに追加]
    B -->|No| D[スキップ]
    C --> E[_update_current_environment]
    E --> F[グループ内の最初のノードを取得]
    F --> G{最初のノードが存在?}
    G -->|Yes| H[World3Dにenvironmentを設定]
    G -->|No| I[空のEnvironmentを設定]
    H --> J[configuration_warnings更新]
    I --> J
    J --> K[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 単一環境制約 | 1シーンにつき1つのWorldEnvironmentのみ有効 | 複数WorldEnvironment存在時 |
| BR-02 | 優先順位 | グループ内で最初に登録されたノードが適用される | 複数WorldEnvironment存在時 |
| BR-03 | 警告表示 | 環境もカメラ属性も未設定の場合は警告 | インスペクタ表示時 |

### 計算ロジック

トーンマッピングの適用:
- ACES/AGXでは`tonemap_agx_white`を使用
- その他では`tonemap_white`を使用

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 設定警告 | environment/camera_attributesが未設定 | リソースを設定 |
| - | 重複警告 | 複数のWorldEnvironmentがアクティブ | 不要なノードを削除 |

### リトライ仕様

なし

## トランザクション仕様

なし

## パフォーマンス要件

- 環境設定の変更はフレーム単位で即時反映
- SSR/SSAOはGPU負荷が高いため、品質設定で調整可能

## セキュリティ考慮事項

特になし

## 備考

- BGMode: BG_CLEAR_COLOR(0), BG_COLOR(1), BG_SKY(2), BG_CANVAS(3), BG_KEEP(4), BG_CAMERA_FEED(5)
- ToneMapper: TONE_MAPPER_LINEAR(0), TONE_MAPPER_REINHARD(1), TONE_MAPPER_FILMIC(2), TONE_MAPPER_ACES(3), TONE_MAPPER_AGX(4)

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Environmentリソースとその設定項目を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | environment.h | `scene/resources/environment.h` | Environmentクラスのメンバ変数（bg_mode, ambient, ssr, ssao等） |
| 1-2 | world_environment.h | `scene/3d/world_environment.h` | WorldEnvironmentノードの構造 |

**読解のコツ**: Environmentはリソースクラスで、WorldEnvironmentはノードクラス。WorldEnvironmentがEnvironmentリソースをWorld3Dに適用する。

#### Step 2: エントリーポイントを理解する

WorldEnvironmentのライフサイクルを追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | world_environment.cpp | `scene/3d/world_environment.cpp` | _notification関数がライフサイクル管理 |

**主要処理フロー**:
1. **36-54行目**: NOTIFICATION_ENTER_TREE/NOTIFICATION_ENTER_WORLDでグループ追加
2. **56-72行目**: NOTIFICATION_EXIT_TREE/NOTIFICATION_EXIT_WORLDでグループ削除
3. **76-85行目**: _update_current_environment()で実際の適用

#### Step 3: Environmentリソースを理解する

各種環境エフェクトの設定処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | environment.cpp | `scene/resources/environment.cpp` | 各種setter/getterとRenderingServer連携 |

**主要処理フロー**:
- **43-54行目**: set_background()でBGMode設定
- **56-67行目**: set_sky()でSkyリソース設定
- **140-198行目**: アンビエントライト設定
- **248-254行目**: トーンマッピング設定

### プログラム呼び出し階層図

```
WorldEnvironment::_notification(NOTIFICATION_ENTER_TREE)
    │
    ├─ add_to_group("_world_environment_" + scenario_id)
    │
    └─ _update_current_environment()
           │
           ├─ get_first_node_in_group()
           │
           └─ World3D::set_environment()
                  │
                  └─ RenderingServer::scenario_set_environment()

Environment::set_* (各種setter)
    │
    └─ RenderingServer::environment_set_*()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Environmentリソース ────▶ WorldEnvironment
       │                      │
       ▼                      ▼
 bg_mode, ambient,     World3D::set_environment()
 ssr, ssao, fog等             │
                              ▼
                       RenderingServer ──────▶ レンダリングパイプライン
                              │
                              ▼
                       Viewport表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| world_environment.cpp | `scene/3d/world_environment.cpp` | ソース | WorldEnvironmentノードの実装 |
| world_environment.h | `scene/3d/world_environment.h` | ヘッダ | WorldEnvironmentノードの定義 |
| environment.cpp | `scene/resources/environment.cpp` | ソース | Environmentリソースの実装 |
| environment.h | `scene/resources/environment.h` | ヘッダ | Environmentリソースの定義 |
| camera_attributes.cpp | `scene/resources/camera_attributes.cpp` | ソース | カメラ属性リソース |
| world_3d.cpp | `scene/resources/3d/world_3d.cpp` | ソース | World3Dの環境管理 |
| sky.cpp | `scene/resources/sky.cpp` | ソース | Skyリソース |
| compositor.cpp | `scene/resources/compositor.cpp` | ソース | コンポジター設定 |
