# 機能設計書 13-Vulkan/OpenGL/Metal対応

## 概要

本ドキュメントは、Godotエンジンにおける複数グラフィックスAPI対応機能の設計仕様を記述する。Godot 4.xでは、Vulkan、OpenGL ES 3.0（互換性レンダラー）、Metal（macOS/iOS）の3つのグラフィックスバックエンドをサポートし、プラットフォームに応じた最適なレンダリングを提供する。

### 本機能の処理概要

**業務上の目的・背景**：ゲームエンジンはWindows、macOS、Linux、Android、iOS、Webなど多様なプラットフォームで動作する必要がある。各プラットフォームでサポートされるグラフィックスAPIは異なるため、Godotはプラットフォーム抽象化レイヤーを通じて複数のグラフィックスAPIに対応し、開発者が単一のコードベースで複数プラットフォームにデプロイできるようにする。

**機能の利用シーン**：
- ハイエンドPC/コンソール向けにVulkanレンダラーを使用（Forward+/Mobile）
- モバイルデバイスや古いハードウェア向けにOpenGL互換性レンダラーを使用
- macOS/iOSでMetalバックエンドを使用
- WebエクスポートでWebGLを使用
- プロジェクト設定でレンダリングメソッドを選択

**主要な処理内容**：
1. RenderingDeviceによるGPUリソース管理
2. シェーダーのクロスコンパイル（SPIR-Vベース）
3. コマンドバッファの構築と実行
4. スワップチェーン管理とプレゼンテーション
5. メモリアロケーションとバッファ管理
6. パイプラインステート管理

**関連システム・外部連携**：
- RenderingServer：高レベルレンダリングAPI
- DisplayServer：ウィンドウとサーフェス管理
- OS：プラットフォーム抽象化

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | プロジェクト設定 | 設定画面 | レンダリングメソッドの選択 |

## 機能種別

レンダリングバックエンド / プラットフォーム抽象化

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| rendering_method | String | No | レンダリングメソッド（forward_plus/mobile/gl_compatibility） | 有効な値であること |
| rendering_driver | String | No | レンダリングドライバー（vulkan/opengl3/metal） | プラットフォームでサポートされていること |

### 入力データソース

- project.godotのrendering/renderer設定
- コマンドライン引数（--rendering-driver）
- プラットフォームのデフォルト設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| rendering_device | RenderingDevice | GPUリソース管理インターフェース |
| device_name | String | GPUデバイス名 |
| device_vendor | String | GPUベンダー名 |
| driver_info | Dictionary | ドライバー情報 |

### 出力先

- フレームバッファ（ウィンドウ/画面出力）
- テクスチャ（オフスクリーンレンダリング）

## 処理フロー

### 処理シーケンス

```
1. エンジン初期化時にレンダリングドライバーを選択
   └─ project.godot設定またはコマンドライン引数から決定
2. RenderingDeviceインスタンスの作成
   └─ Vulkan/OpenGL/Metal固有の初期化
3. スワップチェーンの作成
   └─ ウィンドウサーフェスとの接続
4. シェーダーコンパイル
   └─ SPIR-Vからネイティブシェーダーへ変換
5. レンダリングループ
   └─ コマンドバッファ構築→実行→プレゼント
```

### フローチャート

```mermaid
flowchart TD
    A[エンジン起動] --> B[レンダリングドライバー選択]
    B --> C{ドライバータイプ}
    C -->|Vulkan| D[VulkanContext初期化]
    C -->|OpenGL| E[OpenGLContext初期化]
    C -->|Metal| F[MetalContext初期化]
    D --> G[RenderingDevice作成]
    E --> G
    F --> G
    G --> H[スワップチェーン作成]
    H --> I[レンダリングループ開始]
    I --> J[コマンドバッファ構築]
    J --> K[GPU実行]
    K --> L[画面プレゼント]
    L --> I
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | フォールバック | Vulkan非対応時はOpenGL互換性レンダラーにフォールバック | GPU/ドライバー非対応時 |
| BR-02 | プラットフォーム制約 | MetalはmacOS/iOSのみ対応 | Appleプラットフォーム |
| BR-03 | 機能制限 | 互換性レンダラーでは一部エフェクト非対応 | OpenGL使用時 |

### 計算ロジック

特になし

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 初期化失敗 | GPUドライバーが古い/未対応 | ドライバー更新または互換性レンダラーに切り替え |
| - | メモリ不足 | VRAMが不足 | テクスチャ品質を下げる/解像度を下げる |
| - | シェーダーコンパイルエラー | 未対応のシェーダー機能 | シェーダーを簡略化 |

### リトライ仕様

初期化失敗時は互換性レンダラーへのフォールバックを試行

## トランザクション仕様

なし

## パフォーマンス要件

- Vulkan: マルチスレッドコマンドバッファ構築対応
- Metal: macOS/iOSで最適なパフォーマンス
- OpenGL: 広い互換性を維持しつつ可能な限り高速化

## セキュリティ考慮事項

- GPUドライバーのセキュリティはOS/ベンダー責任
- シェーダーはサンドボックス化されたGPU上で実行

## 備考

- Vulkanドライバー: `drivers/vulkan/`
- OpenGLドライバー: `drivers/gles3/`
- Metalドライバー: `drivers/metal/`
- RenderingDevice: `servers/rendering/rendering_device.cpp`

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

RenderingDeviceの抽象化構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | rendering_device.h | `servers/rendering/rendering_device.h` | RenderingDeviceクラスの仮想関数群 |
| 1-2 | rendering_context_driver.h | `servers/rendering/rendering_context_driver.h` | コンテキストドライバーの抽象化 |

**読解のコツ**: RenderingDeviceはGPUリソース管理の抽象インターフェース。各ドライバー（Vulkan/OpenGL/Metal）はこのインターフェースを実装する。

#### Step 2: Vulkanドライバーを理解する

最も機能が充実しているVulkanドライバーの構造を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | rendering_device_driver_vulkan.cpp | `drivers/vulkan/rendering_device_driver_vulkan.cpp` | Vulkan固有の実装 |
| 2-2 | vulkan_context.cpp | `drivers/vulkan/vulkan_context.cpp` | Vulkanインスタンス/デバイス管理 |

#### Step 3: OpenGLドライバーを理解する

互換性レンダラーの構造を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | rasterizer_gles3.cpp | `drivers/gles3/rasterizer_gles3.cpp` | OpenGL 3.xラスタライザー |
| 3-2 | storage/texture_storage.cpp | `drivers/gles3/storage/texture_storage.cpp` | テクスチャ管理 |

#### Step 4: Metalドライバーを理解する

Apple向けMetalドライバーの構造を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | rendering_device_driver_metal.mm | `drivers/metal/rendering_device_driver_metal.mm` | Metal固有の実装 |
| 4-2 | metal_objects.mm | `drivers/metal/metal_objects.mm` | Metalオブジェクト管理 |

### プログラム呼び出し階層図

```
Main::setup()
    │
    ├─ OS::get_rendering_drivers()
    │
    └─ RenderingServer::create()
           │
           ├─ RenderingDevice::create()
           │      │
           │      ├─ RenderingDeviceDriverVulkan [Vulkan]
           │      ├─ RasterizerGLES3 [OpenGL]
           │      └─ RenderingDeviceDriverMetal [Metal]
           │
           └─ RendererCompositor::create()
```

### データフロー図

```
[入力]                    [処理]                         [出力]

シーンデータ ──────────▶ RenderingServer
                              │
                              ▼
                       RenderingDevice
                              │
          ┌───────────────────┼───────────────────┐
          ▼                   ▼                   ▼
      Vulkan              OpenGL              Metal
      Driver              Driver              Driver
          │                   │                   │
          ▼                   ▼                   ▼
       GPU実行             GPU実行             GPU実行
          │                   │                   │
          └───────────────────┼───────────────────┘
                              ▼
                       フレームバッファ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| rendering_device.cpp | `servers/rendering/rendering_device.cpp` | ソース | RenderingDevice基底クラス |
| rendering_device_driver_vulkan.cpp | `drivers/vulkan/rendering_device_driver_vulkan.cpp` | ソース | Vulkanドライバー実装 |
| vulkan_context.cpp | `drivers/vulkan/vulkan_context.cpp` | ソース | Vulkanコンテキスト管理 |
| rasterizer_gles3.cpp | `drivers/gles3/rasterizer_gles3.cpp` | ソース | OpenGLラスタライザー |
| rendering_device_driver_metal.mm | `drivers/metal/rendering_device_driver_metal.mm` | ソース | Metalドライバー実装 |
| rendering_context_driver.cpp | `servers/rendering/rendering_context_driver.cpp` | ソース | コンテキストドライバー抽象化 |
