# 機能設計書 23-キーボード・マウス入力

## 概要

本ドキュメントは、Godot Engineのキーボード・マウス入力機能について、その設計と実装の詳細を記述した機能設計書である。本機能は、PCプラットフォームにおけるキーボードとマウスからの入力を検出・処理し、ゲームロジックに伝達するための基盤システムを提供する。

### 本機能の処理概要

**業務上の目的・背景**：ゲーム開発において、ユーザーからの入力を正確かつ低レイテンシで取得することは、操作性の良いゲームを作成するための基本要件である。キーボード・マウス入力機能により、キー押下状態の検出、マウス座標の取得、マウスボタンの状態取得、そしてこれらを抽象化したアクションシステムとの連携が可能となる。

**機能の利用シーン**：
- WASDキーによるプレイヤーキャラクターの移動制御
- マウス座標による照準・カメラ操作
- マウスボタンによる攻撃・選択操作
- 修飾キー（Shift、Ctrl、Alt）との組み合わせによるショートカット

**主要な処理内容**：
1. InputEventKey/InputEventMouseの生成と伝播
2. キー押下状態の管理（keys_pressed、physical_keys_pressed）
3. マウス座標・ボタン状態の管理
4. アクションシステム（InputMap）との連携
5. 入力イベントのバッファリングと蓄積処理

**関連システム・外部連携**：DisplayServer（プラットフォーム固有の入力取得）、InputMap（アクションマッピング）、各種ノードの_input/_gui_inputコールバック

**権限による制御**：特に権限による制御はなく、すべてのゲームコードから入力状態を取得可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 36 | 入力イベント設定ダイアログ | 補助機能 | キーボード・マウス入力の検出・設定 |

## 機能種別

イベント駆動処理 / 状態管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| p_keycode | Key | Yes | キーコード（Key enum） | Key::NONE以外 |
| p_button | MouseButton | Yes | マウスボタン（1-5） | 有効なボタン番号 |
| p_position | Vector2 | No | マウス座標 | ウィンドウ座標系内 |
| p_action | StringName | Yes | アクション名 | InputMapに登録済み |

### 入力データソース

- DisplayServerからのプラットフォームネイティブ入力イベント
- InputMapからのアクション定義

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| is_key_pressed | bool | 指定キーが押されているか |
| is_mouse_button_pressed | bool | 指定マウスボタンが押されているか |
| get_mouse_position | Point2 | 現在のマウス座標 |
| get_last_mouse_velocity | Vector2 | マウスの移動速度 |
| is_action_pressed | bool | 指定アクションが有効か |

### 出力先

- ゲームスクリプトからのAPI呼び出し結果
- _input/_unhandled_inputコールバックへのイベント伝播

## 処理フロー

### 処理シーケンス

```
1. DisplayServerがOS固有の入力イベントを検出
   └─ キー押下、マウス移動、マウスボタン等
2. InputEventオブジェクトを生成
   └─ InputEventKey、InputEventMouseButton、InputEventMouseMotion
3. Input::parse_input_eventで入力を処理
   └─ 内部状態（keys_pressed等）を更新
4. アクション状態を更新（InputMapと照合）
   └─ action_statesキャッシュを更新
5. 入力イベントを伝播
   └─ Viewport → Control/_gui_input → _input → _unhandled_input
```

### フローチャート

```mermaid
flowchart TD
    A[DisplayServerからのイベント] --> B[InputEvent生成]
    B --> C{イベントタイプ}
    C -->|Key| D[InputEventKey]
    C -->|MouseButton| E[InputEventMouseButton]
    C -->|MouseMotion| F[InputEventMouseMotion]
    D --> G[Input::parse_input_event]
    E --> G
    F --> G
    G --> H[内部状態更新]
    H --> I[アクション状態更新]
    I --> J[イベント伝播]
    J --> K[Viewport._input]
    K --> L{ハンドル済み?}
    L -->|No| M[_unhandled_input]
    L -->|Yes| N[終了]
    M --> N
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-23-01 | キーコード種別 | keycode（論理）、physical_keycode（物理）、key_label（表示用）の3種類 | 常時 |
| BR-23-02 | 修飾キー | Shift、Ctrl、Alt、Metaは個別に検出可能 | 常時 |
| BR-23-03 | マウスモード | VISIBLE、HIDDEN、CAPTURED、CONFINED等のモードをサポート | 設定時 |
| BR-23-04 | イベント蓄積 | use_accumulated_inputがtrueの場合、フレーム内のイベントを蓄積 | 設定による |

### 計算ロジック

**マウス速度計算**：
- VelocityTrackクラスで速度を追跡
- accum（移動量蓄積）とaccum_t（時間蓄積）から速度を算出
- min_ref_frame（0.1秒）以上経過で速度を確定

**アクション強度計算**：
- デジタル入力（キー、ボタン）は0.0または1.0
- アナログ入力（ジョイスティック軸）はデッドゾーン適用後の値

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作はなし。すべての状態はメモリ上で管理。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 無効なアクション名 | InputMapに未登録のアクション指定 | ERR_FAIL_COND_V_MSG で警告＋デフォルト値返却 |
| - | 無効なキーコード | Key::NONE指定 | 処理をスキップ |

### リトライ仕様

リトライ機構はなし。無効な入力はスキップまたはデフォルト値を返却。

## トランザクション仕様

_THREAD_SAFE_METHODマクロによりスレッドセーフティを確保。

## パフォーマンス要件

- 入力レイテンシ：フレームレートに依存（60FPSで約16.6ms以内）
- イベント処理：フレームあたり最大32イベント（MAX_EVENT定数）

## セキュリティ考慮事項

- 入力は信頼されたDisplayServerからのみ受け付け
- parse_input_eventはスクリプトからも呼び出し可能（テスト用途）

## 備考

- マウスエミュレーション：タッチ入力からマウスイベントを生成可能
- タッチエミュレーション：マウス入力からタッチイベントを生成可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

入力イベントの型階層と内部状態を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | input_event.h | `core/input/input_event.h` | InputEvent基底クラス、InputEventKey、InputEventMouseButton、InputEventMouseMotion |
| 1-2 | input.h | `core/input/input.h` | Input シングルトン、keys_pressed、mouse_button_mask、ActionState構造体 |

**読解のコツ**: InputEventは継承階層を持ち、InputEvent → InputEventFromWindow → InputEventWithModifiers → InputEventKey/InputEventMouseの順で特殊化される。

#### Step 2: エントリーポイントを理解する

入力イベントの処理起点を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | input.cpp | `core/input/input.cpp` | parse_input_event、_parse_input_event_impl |
| 2-2 | input.h | `core/input/input.h` | 各種is_*_pressed、get_*メソッド定義 |

**主要処理フロー**:
1. **116-206行目**: _bind_methods - スクリプトAPI定義
2. **279-297行目**: is_anything_pressed - 何らかの入力があるか判定
3. **232-262行目**: VelocityTrack::update - マウス速度計算

#### Step 3: 状態管理を理解する

キー・マウス状態の内部管理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | input.h | `core/input/input.h` | keys_pressed、physical_keys_pressed、mouse_button_mask |

**主要処理フロー**:
- **97-99行目**: key_label_pressed、physical_keys_pressed、keys_pressed - キー状態セット
- **95行目**: mouse_button_mask - マウスボタン状態ビットフィールド
- **116-140行目**: ActionState構造体 - アクション状態管理

### プログラム呼び出し階層図

```
DisplayServer（プラットフォーム固有）
    │
    └─ Input::parse_input_event
           │
           ├─ Input::_parse_input_event_impl
           │      │
           │      ├─ keys_pressed/physical_keys_pressed更新
           │      │
           │      ├─ mouse_button_mask更新
           │      │
           │      └─ action_states更新
           │
           └─ event_dispatch_function（イベント伝播）
                  │
                  └─ Viewport::_input → Control::_gui_input → _input → _unhandled_input
```

### データフロー図

```
[入力]                     [処理]                        [出力]

キーボード ───────┐
                 │
                 ├──▶ DisplayServer ──▶ InputEvent生成 ──▶ Input::parse_input_event
                 │
マウス ──────────┘                                              │
                                                               ▼
                                                    ┌──────────┴──────────┐
                                                    │                      │
                                                    ▼                      ▼
                                              内部状態更新            イベント伝播
                                              (keys_pressed,          (Viewport,
                                              mouse_button_mask,       Control,
                                              action_states)           Node)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| input.h | `core/input/input.h` | ソース | Inputシングルトン定義 |
| input.cpp | `core/input/input.cpp` | ソース | 入力処理実装 |
| input_event.h | `core/input/input_event.h` | ソース | InputEventクラス階層定義 |
| input_event.cpp | `core/input/input_event.cpp` | ソース | InputEvent実装 |
| input_map.h | `core/input/input_map.h` | ソース | アクションマッピング定義 |
| input_map.cpp | `core/input/input_map.cpp` | ソース | アクションマッピング実装 |
| keyboard.h | `core/os/keyboard.h` | ソース | Keyコード定義 |
