# 機能設計書 25-タッチ入力

## 概要

本ドキュメントは、Godot Engineのタッチ入力機能について、その設計と実装の詳細を記述した機能設計書である。本機能は、モバイルデバイス（スマートフォン、タブレット）やタッチスクリーン搭載PCでのマルチタッチ入力を検出・処理するための機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：モバイルゲーム開発において、タッチ入力は主要な操作方法である。シングルタッチだけでなく、マルチタッチ（ピンチ、スワイプ等のジェスチャー）にも対応することで、直感的なユーザーインターフェースの構築が可能となる。また、タッチ入力からのマウスエミュレーションにより、既存のマウス対応コードとの互換性も維持できる。

**機能の利用シーン**：
- 画面タッチによるキャラクター移動・操作
- ピンチ操作によるズームイン・ズームアウト
- スワイプによるリスト・マップスクロール
- マルチタッチによる複雑なジェスチャー操作
- 仮想コントローラー（バーチャルジョイスティック）の実装

**主要な処理内容**：
1. タッチ開始・移動・終了イベントの検出
2. マルチタッチ対応（複数指の同時追跡）
3. タッチインデックスによる個別指の識別
4. タッチからマウスイベントへのエミュレーション
5. 速度追跡（VelocityTrack）によるフリック検出

**関連システム・外部連携**：DisplayServer（プラットフォーム固有のタッチAPI）、Inputシングルトン、Controlノード

**権限による制御**：特に権限による制御はなし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | タッチ入力は画面共通機能として動作 |

## 機能種別

イベント駆動処理 / ジェスチャー認識

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| p_index | int | Yes | タッチインデックス（指の識別子） | 0以上の整数 |
| p_position | Vector2 | Yes | タッチ座標 | スクリーン座標系内 |
| p_pressed | bool | Yes | タッチ状態（押下/解放） | true/false |
| p_double_tap | bool | No | ダブルタップ判定 | true/false |

### 入力データソース

- プラットフォーム固有のタッチAPI（Android、iOS、Windows Touch等）
- DisplayServerからのタッチイベント

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| InputEventScreenTouch | InputEvent | タッチ開始/終了イベント |
| InputEventScreenDrag | InputEvent | タッチ移動（ドラッグ）イベント |
| touch_velocity_track | HashMap<int, VelocityTrack> | 各指の速度追跡データ |

### 出力先

- _input、_gui_inputコールバックへのイベント伝播
- マウスエミュレーション有効時はInputEventMouse*も生成

## 処理フロー

### 処理シーケンス

```
1. DisplayServerがタッチイベントを検出
   └─ タッチ開始/移動/終了を識別
2. InputEventScreenTouch/ScreenDragを生成
   └─ タッチインデックス、座標、pressed状態を設定
3. マウスエミュレーション処理（有効時）
   └─ 最初のタッチ（index=0）をマウスイベントに変換
4. VelocityTrackで速度追跡
   └─ フリック操作の検出用
5. イベントをInput::parse_input_eventに送信
   └─ 通常の入力イベント処理フローへ
```

### フローチャート

```mermaid
flowchart TD
    A[タッチイベント検出] --> B{イベントタイプ}
    B -->|開始| C[InputEventScreenTouch生成<br>pressed=true]
    B -->|移動| D[InputEventScreenDrag生成]
    B -->|終了| E[InputEventScreenTouch生成<br>pressed=false]
    C --> F{マウスエミュ有効?}
    D --> F
    E --> F
    F -->|Yes & index=0| G[InputEventMouse*生成]
    F -->|No| H[VelocityTrack更新]
    G --> H
    H --> I[Input::parse_input_event]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-25-01 | マウスエミュレーション | emulate_mouse_from_touchがtrueの場合、タッチをマウスイベントに変換 | 設定による |
| BR-25-02 | エミュレーション対象 | 最初のタッチ（mouse_from_touch_index）のみがマウスとしてエミュレート | マウスエミュ有効時 |
| BR-25-03 | 速度計算 | touch_velocity_trackで各指の速度を個別追跡 | 常時 |
| BR-25-04 | ダブルタップ | double_tapフラグでダブルタップを判定 | InputEventScreenTouch |

### 計算ロジック

**速度追跡**：
- VelocityTrackクラスで実装
- 過去のタッチ移動量と経過時間から速度を算出
- min_ref_frame（0.1秒）以上の間隔で速度確定

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作はなし。すべての状態はメモリ上で管理。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 無効なタッチインデックス | 存在しないインデックス指定 | イベントをスキップ |

### リトライ仕様

リトライ機構はなし。

## トランザクション仕様

トランザクション管理は不要。

## パフォーマンス要件

- 入力レイテンシ：1フレーム以内
- マルチタッチ追跡：デバイス依存（通常5〜10点）

## セキュリティ考慮事項

- タッチ入力は信頼されたDisplayServerからのみ受け付け

## 備考

- タッチ未対応デバイスでは、マウスからタッチイベントへのエミュレーションも可能（emulate_touch_from_mouse）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

タッチイベントと速度追跡の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | input_event.h | `core/input/input_event.h` | InputEventScreenTouch、InputEventScreenDrag定義 |
| 1-2 | input.h | `core/input/input.h` | VelocityTrack構造体、touch_velocity_track |

**読解のコツ**: VelocityTrack構造体（160-173行目）はvelocity、screen_velocity、accum、accum_t等を持ち、速度計算の状態を保持する。

#### Step 2: エントリーポイントを理解する

タッチイベントの処理起点を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | input.cpp | `core/input/input.cpp` | _parse_input_event_impl |
| 2-2 | input.h | `core/input/input.h` | emulate_mouse_from_touch、mouse_from_touch_index |

**主要処理フロー**:
1. **144-145行目**: emulate_touch_from_mouse、emulate_mouse_from_touch - エミュレーション設定
2. **149行目**: mouse_from_touch_index - エミュレーション対象タッチインデックス
3. **191行目**: touch_velocity_track - タッチごとの速度追跡マップ

### プログラム呼び出し階層図

```
DisplayServer（プラットフォーム固有）
    │
    └─ Input::parse_input_event
           │
           ├─ InputEventScreenTouch/ScreenDrag処理
           │      │
           │      ├─ VelocityTrack更新
           │      │
           │      └─ マウスエミュレーション（条件付き）
           │             └─ InputEventMouseButton/Motion生成
           │
           └─ イベント伝播
                  └─ Viewport → Control → _input
```

### データフロー図

```
[入力]                      [処理]                         [出力]

タッチスクリーン ────▶ DisplayServer ────▶ Input シングルトン
                                                │
                                 ┌──────────────┼──────────────┐
                                 │              │              │
                                 ▼              ▼              ▼
                     InputEventScreen*     VelocityTrack    マウスエミュ
                           生成               更新          (条件付き)
                                 │              │              │
                                 └──────────────┴──────────────┘
                                                │
                                                ▼
                                        イベント伝播
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| input.h | `core/input/input.h` | ソース | VelocityTrack、エミュレーション設定 |
| input.cpp | `core/input/input.cpp` | ソース | タッチイベント処理 |
| input_event.h | `core/input/input_event.h` | ソース | InputEventScreenTouch、InputEventScreenDrag定義 |
| input_event.cpp | `core/input/input_event.cpp` | ソース | タッチイベント実装 |
