# 機能設計書 29-テーマシステム

## 概要

本ドキュメントは、Godot Engineのテーマシステム機能について、その設計と実装の詳細を記述した機能設計書である。本機能は、UIコントロールのスタイリング（色、フォント、アイコン、スタイルボックス、定数）を一元管理し、アプリケーション全体で一貫した外観を実現するための機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：ゲームやアプリケーションのUI設計において、各コントロールのスタイルを個別に設定するのは煩雑であり、一貫性を保つことが困難である。テーマシステムにより、開発者は色、フォント、スタイルボックス等を一箇所で定義し、全てのUIコントロールに適用できる。また、テーマの切り替えによりダークモード/ライトモードの実装や、ゲームジャンルに応じたスキン変更も容易に行える。

**機能の利用シーン**：
- アプリケーション全体のカラースキーム変更
- ダークモード/ライトモードの切り替え
- ゲームのUIスキン（ファンタジー風、SF風等）
- 特定のコントロールタイプへのスタイル適用

**主要な処理内容**：
1. テーマアイテム（Icon、StyleBox、Font、FontSize、Color、Constant）の登録・取得
2. テーマタイプバリエーションの管理
3. デフォルトフォント・フォントサイズ・ベーススケールの設定
4. テーマ変更時の通知発行
5. テーマのマージと継承

**関連システム・外部連携**：Control（テーマの適用先）、StyleBox（背景描画）、Font（テキスト描画）

**権限による制御**：特に権限による制御はなし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | インスペクタードック | 補助機能 | テーマプロパティの編集 |

## 機能種別

リソース管理 / スタイル定義 / 継承システム

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| p_name | StringName | Yes | アイテム名 | 空文字列不可、英数字とアンダースコア |
| p_theme_type | StringName | Yes | テーマタイプ名 | 空文字列不可、英数字とアンダースコア |
| p_data_type | DataType | Yes | データ型（COLOR/CONSTANT/FONT等） | enum範囲内 |

### 入力データソース

- テーマリソースファイル（.theme）
- スクリプトからのAPI呼び出し
- プロジェクト設定からのデフォルトテーマ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| get_icon | Ref<Texture2D> | アイコンテクスチャ |
| get_stylebox | Ref<StyleBox> | スタイルボックス |
| get_font | Ref<Font> | フォント |
| get_font_size | int | フォントサイズ |
| get_color | Color | 色 |
| get_constant | int | 定数値 |

### 出力先

- Controlノードへのスタイル適用
- theme_changedシグナル発行

## 処理フロー

### 処理シーケンス

```
1. テーマアイテムの設定
   └─ set_icon / set_stylebox / set_font / set_color / set_constant
2. リソース変更の監視
   └─ connect_changed → _emit_theme_changed
3. テーマ変更の通知
   └─ _emit_theme_changed
4. Controlへの適用
   └─ NOTIFICATION_THEME_CHANGED → _update_theme_item_cache
```

### フローチャート

```mermaid
flowchart TD
    A[テーマアイテム設定] --> B{リソース型?}
    B -->|Yes| C[connect_changed登録]
    B -->|No| D[直接保存]
    C --> E[icon_map/style_map等に保存]
    D --> E
    E --> F[_emit_theme_changed]
    F --> G{notify_list_changed?}
    G -->|Yes| H[emit_changed true]
    G -->|No| I[emit_changed false]
    H --> J[Control::NOTIFICATION_THEME_CHANGED]
    I --> J
    J --> K[_update_theme_item_cache]
    K --> L[queue_redraw]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-29-01 | データ型 | DataType: COLOR(0), CONSTANT(1), FONT(2), FONT_SIZE(3), ICON(4), STYLEBOX(5) | 全操作 |
| BR-29-02 | 名前検証 | is_valid_item_name: 英数字とアンダースコアのみ許可 | アイテム登録時 |
| BR-29-03 | タイプ検証 | is_valid_type_name: 英数字とアンダースコアのみ許可 | タイプ登録時 |
| BR-29-04 | デフォルト値 | default_base_scale > 0.0、default_font_size > 0でhas_defaultがtrue | デフォルト判定時 |

### 計算ロジック

**テーマアイテム検索**：
1. 指定されたtheme_typeで検索
2. 見つからない場合、type_variationを辿って基底タイプを検索
3. 最終的に見つからない場合はデフォルト値を返却

**テーマタイプバリエーション**：
- variation_map: theme_type → base_type のマッピング
- variation_base_map: base_type → List<theme_type> の逆引き

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作はなし。メモリ上のHashMapで管理：
- icon_map: HashMap<StringName, ThemeIconMap>
- style_map: HashMap<StringName, ThemeStyleMap>
- font_map: HashMap<StringName, ThemeFontMap>
- font_size_map: HashMap<StringName, ThemeFontSizeMap>
- color_map: HashMap<StringName, ThemeColorMap>
- constant_map: HashMap<StringName, ThemeConstantMap>

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 無効なアイテム名 | 空文字列または非ASCII文字 | ERR_FAIL_COND_MSG |
| - | 無効なタイプ名 | 空文字列または非ASCII文字 | ERR_FAIL_COND_MSG |

### リトライ仕様

リトライ機構はなし。

## トランザクション仕様

トランザクション管理は不要。

## パフォーマンス要件

- アイテム検索：O(1)（HashMapによる）
- _freeze_change_propagationで一括変更時の通知を抑制

## セキュリティ考慮事項

- 特になし

## 備考

- RES_BASE_EXTENSION("theme")でファイル拡張子定義
- merge_withで他のテーマとマージ可能
- clearで全アイテムをクリア

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Themeクラスの構造とデータ型を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | theme.h | `scene/resources/theme.h` | Theme クラス、DataType enum（56-64行目）、各種HashMap定義（100-108行目） |

**読解のコツ**: DataType enumの値（COLOR=0〜STYLEBOX=5）、icon_map/style_map等のHashMap構造、variation_map/variation_base_mapの継承関係を把握する。

#### Step 2: エントリーポイントを理解する

テーマアイテムの設定・取得APIを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | theme.cpp | `scene/resources/theme.cpp` | set_icon(279行目〜)、get_icon(298行目〜)、is_valid_item_name(189-201行目) |

**主要処理フロー**:
1. **279-296行目**: set_icon - アイコン登録、connect_changed設定
2. **298-301行目**: get_icon - アイコン取得
3. **189-201行目**: is_valid_item_name/is_valid_type_name - 名前検証
4. **36-66行目**: _set/_get - ダイナミックプロパティ

#### Step 3: テーマ変更通知を理解する

テーマ変更時の通知フローを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | theme.h | `scene/resources/theme.h` | _emit_theme_changed、_freeze_change_propagation |
| 3-2 | theme.cpp | `scene/resources/theme.cpp` | _emit_theme_changed実装 |

### プログラム呼び出し階層図

```
Theme（リソースクラス）
    │
    ├─ set_icon / set_stylebox / set_font / set_color / set_constant
    │      ├─ is_valid_item_name / is_valid_type_name
    │      ├─ 既存リソースのdisconnect_changed
    │      ├─ HashMap更新（icon_map等）
    │      ├─ 新リソースのconnect_changed
    │      └─ _emit_theme_changed
    │
    ├─ get_icon / get_stylebox / get_font / get_color / get_constant
    │      ├─ HashMap検索
    │      └─ variation_map経由で基底タイプ検索
    │
    ├─ set_type_variation / get_type_variation_base
    │      ├─ variation_map更新
    │      └─ variation_base_map更新
    │
    └─ _emit_theme_changed
           └─ emit_changed（Resourceシグナル）
                  │
                  └─ Control::NOTIFICATION_THEME_CHANGED
                         └─ _update_theme_item_cache
```

### データフロー図

```
[入力]                       [処理]                        [出力]

.themeファイル ────────┐
                      │
スクリプトAPI ────────┼──▶ Theme::set_* ──▶ HashMap更新
                      │                          │
EditorUI ─────────────┘                          ▼
                                         _emit_theme_changed
                                                 │
                                                 ▼
                                          emit_changed
                                                 │
                                 ┌───────────────┼───────────────┐
                                 │               │               │
                                 ▼               ▼               ▼
                            Control 1       Control 2       Control N
                         NOTIFICATION_    NOTIFICATION_    NOTIFICATION_
                         THEME_CHANGED    THEME_CHANGED    THEME_CHANGED
                                 │               │               │
                                 ▼               ▼               ▼
                         _update_theme_  _update_theme_  _update_theme_
                         item_cache      item_cache      item_cache
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| theme.h | `scene/resources/theme.h` | ソース | Themeクラス定義 |
| theme.cpp | `scene/resources/theme.cpp` | ソース | Theme実装 |
| theme_db.h | `scene/theme/theme_db.h` | ソース | ThemeDatabaseシングルトン定義 |
| theme_db.cpp | `scene/theme/theme_db.cpp` | ソース | ThemeDatabase実装 |
| style_box.h | `scene/resources/style_box.h` | ソース | StyleBox基底クラス |
| font.h | `scene/resources/font.h` | ソース | Fontリソース |
| control.h | `scene/gui/control.h` | ソース | テーマ適用先 |
