# 機能設計書 30-リッチテキスト

## 概要

本ドキュメントは、Godot EngineのRichTextLabel機能について、その設計と実装の詳細を記述した機能設計書である。本機能は、BBCode対応のリッチテキスト表示を提供し、フォント変更、色付け、画像挿入、テーブル、各種テキストエフェクト（シェイク、ウェーブ、レインボー等）を実現する。

### 本機能の処理概要

**業務上の目的・背景**：ゲームやアプリケーションにおいて、単純なテキスト表示だけでなく、装飾されたテキストが必要な場面は多い。RichTextLabel機能により、開発者はBBCodeタグを使用して、フォントスタイル、色、画像、テーブル、アニメーションエフェクトを含むリッチなテキストコンテンツを表示できる。

**機能の利用シーン**：
- ゲーム内ダイアログ（キャラクター名の色分け、強調表示）
- チュートリアル画面（画像付き説明文）
- クレジット画面（スクロールテキスト）
- チャットログ（絵文字、リンク対応）
- ドキュメント表示（見出し、リスト、テーブル）

**主要な処理内容**：
1. BBCodeのパース（parse_bbcode）
2. テキストアイテムの内部表現への変換
3. 行ごとのレイアウト計算（_shape_line）
4. テキストエフェクトの適用と更新
5. 描画処理（_draw_line）

**関連システム・外部連携**：TextServer（テキストシェーピング）、Font（フォント描画）、Theme（デフォルトスタイル）

**権限による制御**：特に権限による制御はなし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | インスペクタードック | 補助機能 | テキストプロパティの編集 |

## 機能種別

テキスト表示 / BBCodeパース / テキストエフェクト

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| p_bbcode | String | Yes | BBCodeテキスト | - |
| use_bbcode | bool | No | BBCodeモード有効化 | デフォルトfalse |
| visible_characters | int | No | 表示文字数（-1で全表示） | -1以上 |

### 入力データソース

- スクリプトからのテキスト設定
- シーンファイルからのプロパティ設定
- Themeからのデフォルトフォント・色

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| get_parsed_text | String | パース後のプレーンテキスト |
| get_paragraph_count | int | 段落数 |
| get_line_count | int | 行数 |
| get_content_height | int | コンテンツの高さ |
| get_selected_text | String | 選択中のテキスト |

### 出力先

- 画面への描画
- シグナル発行（meta_clicked、meta_hover_started等）

## 処理フロー

### 処理シーケンス

```
1. BBCodeテキストの設定
   └─ set_text / append_text / parse_bbcode
2. BBCodeのパース
   └─ タグをItemに変換（ItemText, ItemFont, ItemColor等）
3. 行レイアウト計算
   └─ _shape_line → TextParagraph生成
4. 描画
   └─ _notification(NOTIFICATION_DRAW) → _draw_line
5. エフェクト更新（毎フレーム）
   └─ _update_fx
```

### フローチャート

```mermaid
flowchart TD
    A[BBCodeテキスト設定] --> B[parse_bbcode]
    B --> C[タグをItemに変換]
    C --> D[ItemFrame/ItemText等を生成]
    D --> E[_validate_line_caches]
    E --> F[_shape_line]
    F --> G[TextParagraph生成]
    G --> H[_notification DRAW]
    H --> I[_draw_line]
    I --> J{FXアイテム?}
    J -->|Yes| K[_update_fx]
    J -->|No| L[通常描画]
    K --> M[エフェクト適用描画]
    L --> N[描画完了]
    M --> N
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-30-01 | リスト型 | ListType: NUMBERS(0), LETTERS(1), ROMAN(2), DOTS(3) | [ol]/[ul]タグ |
| BR-30-02 | メタアンダーライン | MetaUnderline: NEVER(0), ALWAYS(1), ON_HOVER(2) | [url]タグ |
| BR-30-03 | 可視文字動作 | VC_CHARS_BEFORE_SHAPING/AFTER_SHAPING/GLYPHS_AUTO等 | タイプライター演出 |
| BR-30-04 | スレッド処理 | threaded=trueで別スレッドでレイアウト計算 | 大量テキスト時 |

### 計算ロジック

**可視文字数制御**：
- visible_characters: 表示する文字数（-1で全表示）
- visible_ratio: 0.0〜1.0で表示割合を指定
- タイプライター効果の実現に使用

**エフェクト計算**：
- shake: ランダムオフセット（strength, rate）
- wave: sin波形（frequency, amplitude）
- tornado: 円形移動（radius, frequency）
- rainbow: HSV色相変化（saturation, value, frequency, speed）
- pulse: 色パルス（color, frequency, ease）

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作はなし。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 無効なタグ | 未知のBBCodeタグ | 無視して表示 |
| - | 不正なネスト | タグの閉じ忘れ | 可能な範囲で処理 |

### リトライ仕様

リトライ機構はなし。

## トランザクション仕様

トランザクション管理は不要。

## パフォーマンス要件

- スレッド処理対応（threaded = true）
- 行キャッシュによる増分更新（first_invalid_line）
- progress_delay（デフォルト1000ms）でプログレスバー表示

## セキュリティ考慮事項

- meta_clickedシグナルでURLクリックを検知（自動オープンはしない）
- ユーザー入力テキストのサニタイズは呼び出し側の責任

## 備考

- スレッド処理時はatomic変数で状態管理（stop_thread, updating, validating）
- カスタムエフェクト（RichTextEffect）の追加が可能
- アクセシビリティ対応（accessibility_line_element, accessibility_text_element）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

RichTextLabelの内部構造とItem型を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | rich_text_label.h | `scene/gui/rich_text_label.h` | RichTextLabel クラス、ItemType enum（74-105行目）、各種Item構造体 |

**読解のコツ**: ItemType enumで定義されるアイテム型（ITEM_FRAME〜ITEM_CONTEXT）、Item基底構造体と派生構造体（ItemText, ItemFont, ItemColor等）を把握する。

#### Step 2: エントリーポイントを理解する

BBCodeパースとテキスト追加APIを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | rich_text_label.h | `scene/gui/rich_text_label.h` | parse_bbcode、append_text、add_text、push_*系メソッド |

**主要処理フロー**:
1. **parse_bbcode**: BBCodeのパースエントリーポイント
2. **append_text**: BBCodeテキストの追加
3. **add_text**: プレーンテキストの追加
4. **push_*/pop**: スタイルのプッシュ/ポップ

#### Step 3: 描画とエフェクトを理解する

描画処理とテキストエフェクトの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | rich_text_label.h | `scene/gui/rich_text_label.h` | ThemeCache構造体（771-818行目）、ItemFX派生構造体（ItemShake, ItemWave等） |

### プログラム呼び出し階層図

```
RichTextLabel（Controlを継承）
    │
    ├─ set_text / parse_bbcode / append_text
    │      └─ BBCodeパース
    │             ├─ push_* (ItemFont, ItemColor等を生成)
    │             ├─ add_text (ItemTextを生成)
    │             ├─ add_image (ItemImageを生成)
    │             └─ pop
    │
    ├─ _validate_line_caches
    │      └─ _shape_line
    │             └─ TextParagraph生成
    │
    ├─ _notification(NOTIFICATION_DRAW)
    │      └─ _draw_line
    │             ├─ テキスト描画
    │             ├─ アンダーライン描画
    │             ├─ 画像描画
    │             └─ テーブル描画
    │
    └─ _update_fx（毎フレーム）
           ├─ ItemShake更新
           ├─ ItemWave更新
           ├─ ItemTornado更新
           ├─ ItemRainbow更新
           └─ ItemPulse更新
```

### データフロー図

```
[入力]                       [処理]                        [出力]

BBCodeテキスト ───────┐
                     │
set_text/append ─────┼──▶ parse_bbcode ──▶ Item構造体
                     │                          │
Themeスタイル ───────┘                          ▼
                                        _validate_line_caches
                                                │
                                                ▼
                                          _shape_line
                                                │
                                                ▼
                                        TextParagraph
                                                │
                                 ┌──────────────┼──────────────┐
                                 │              │              │
                                 ▼              ▼              ▼
                            _draw_line    _update_fx     シグナル
                                 │              │         (meta_clicked等)
                                 ▼              ▼
                              画面描画    エフェクト適用
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| rich_text_label.h | `scene/gui/rich_text_label.h` | ソース | RichTextLabelクラス定義 |
| rich_text_label.cpp | `scene/gui/rich_text_label.cpp` | ソース | RichTextLabel実装 |
| text_paragraph.h | `scene/resources/text_paragraph.h` | ソース | TextParagraph定義 |
| text_paragraph.cpp | `scene/resources/text_paragraph.cpp` | ソース | TextParagraph実装 |
| rich_text_effect.h | `scene/gui/rich_text_effect.h` | ソース | カスタムエフェクト基底クラス |
| char_fx_transform.h | `scene/gui/char_fx_transform.h` | ソース | 文字変換情報 |
