# 機能設計書 45-シーンエディタ

## 概要

本ドキュメントは、Godot Engineのメインエディタである「シーンエディタ（EditorNode）」について、設計仕様を記載する。

### 本機能の処理概要

シーンエディタは、Godot Engineの中核となる統合開発環境（IDE）であり、シーンの作成・編集・管理、プロジェクト設定、エクスポート、デバッグ等の全ての開発作業を統括する。EditorNodeクラスがメインウィンドウとして機能し、各種ドック、インスペクター、ファイルシステム、スクリプトエディタ等のサブシステムを統合する。

**業務上の目的・背景**：ゲーム開発には、ビジュアルなシーン構築、スクリプト編集、リソース管理、テスト実行など多岐にわたる作業が必要となる。シーンエディタはこれらを一元的に管理し、効率的な開発ワークフローを実現する。

**機能の利用シーン**：
- シーン（ゲームステージ、UI、メニュー等）の作成・編集
- ノードの追加・削除・配置・プロパティ設定
- リソース（テクスチャ、オーディオ、シェーダー等）の管理
- プロジェクトの実行・デバッグ
- エクスポート（各プラットフォーム向けビルド）

**主要な処理内容**：
1. プロジェクトのロードと初期化
2. シーンの読み込み・保存・管理
3. エディタプラグインの初期化と統合
4. ユーザーインターフェースの構築と管理
5. 実行・デバッグセッションの制御
6. プロジェクトのエクスポート

**関連システム・外部連携**：全てのエディタサブシステム（インスペクター、ファイルシステムドック、スクリプトエディタ、アニメーションエディタ、デバッガー等）と連携する。

**権限による制御**：エディタ設定とフィーチャープロファイルにより、表示・利用可能な機能を制御。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | メインエディタ | 主画面 | エディタ全体の統括 |
| 2 | シーンツリー | 従属画面 | ノード階層の表示・操作 |
| 3 | インスペクター | 従属画面 | プロパティ編集 |
| 4 | ファイルシステムドック | 従属画面 | リソース管理 |
| 5 | スクリプトエディタ | 従属画面 | コード編集 |

## 機能種別

GUI / 統合開発環境

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| project_path | String | Yes | プロジェクトルートパス | project.godot存在 |
| scene_path | String | No | 初期ロードシーンパス | .tscn/.scn拡張子 |
| renderer | String | No | レンダラー設定 | forward_plus/mobile/gl_compatibility |

### 入力データソース

- project.godot（プロジェクト設定）
- editor_settings-*.tres（エディタ設定）
- *.tscn/*.scn（シーンファイル）
- *.tres/*.res（リソースファイル）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 編集済みシーン | .tscn/.scn | 保存されたシーンファイル |
| エディタレイアウト | .tres | ドック配置等の状態 |
| エクスポートパッケージ | 各種 | プラットフォーム別ビルド |

### 出力先

- プロジェクトディレクトリ
- user://（エディタ設定）
- エクスポート先ディレクトリ

## 処理フロー

### 処理シーケンス

```
1. エディタ初期化
   └─ EditorNode::EditorNode()コンストラクタ
   └─ テーマ・アイコン構築
   └─ UI構築（ドック、メニュー、ツールバー）

2. プラグイン初期化
   └─ 組み込みプラグイン登録
   └─ エディタプラグイン有効化
   └─ アドオン読み込み

3. プロジェクトロード
   └─ project.godot解析
   └─ リソーススキャン
   └─ メインシーンロード（存在する場合）

4. ユーザー操作待機
   └─ メニュー操作
   └─ シーン編集
   └─ 実行/デバッグ

5. 終了処理
   └─ 未保存確認
   └─ レイアウト保存
   └─ リソース解放
```

### フローチャート

```mermaid
flowchart TD
    A[Godotエディタ起動] --> B[EditorNode初期化]
    B --> C[テーマ構築]
    C --> D[UI構築]
    D --> E[プラグイン初期化]
    E --> F[プロジェクトロード]
    F --> G[リソーススキャン]
    G --> H[メインループ]
    H --> I{ユーザー操作}
    I -->|シーン操作| J[シーン編集]
    I -->|ファイル操作| K[ファイル処理]
    I -->|実行| L[プロジェクト実行]
    I -->|エクスポート| M[エクスポート処理]
    I -->|終了| N{未保存確認}
    J --> H
    K --> H
    L --> H
    M --> H
    N -->|キャンセル| H
    N -->|確認| O[レイアウト保存]
    O --> P[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-45-01 | 自動保存 | 一定間隔でシーンを自動バックアップ | 設定で有効化時 |
| BR-45-02 | 未保存警告 | 終了時に未保存シーンがあれば警告 | 常時 |
| BR-45-03 | レイアウト保持 | ドック配置を終了時に保存、次回復元 | 常時 |
| BR-45-04 | 最近開いたシーン | 直近のシーン一覧をメニューに表示 | 常時 |
| BR-45-05 | メインシーン設定 | F5実行時にメインシーンを実行 | メインシーン設定時 |

### 計算ロジック

- Undo/Redo: UndoRedo classによる操作履歴管理
- シーンタブ管理: EditorSceneTabsによる複数シーン編集

## データベース操作仕様

本機能はデータベース操作を行わない（ファイルシステムベース）。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| SCENE_LOAD_ERROR | ロードエラー | シーンファイル破損/不在 | バックアップから復元 |
| DEPENDENCY_ERROR | 依存エラー | 参照リソース不在 | 依存関係解決ダイアログ |
| SAVE_ERROR | 保存エラー | 書き込み権限なし/ディスク満杯 | 別名保存を提案 |
| EXPORT_ERROR | エクスポートエラー | テンプレート不在/設定不備 | エラーメッセージ表示 |

### リトライ仕様

ファイル操作エラー時は確認ダイアログを表示し、ユーザー判断を求める。

## トランザクション仕様

該当なし（Undo/Redoで操作履歴管理）

## パフォーマンス要件

- UI応答: 60fps維持
- シーンロード: バックグラウンドスレッドで実行
- リソースプレビュー: 非同期生成

## セキュリティ考慮事項

- プロジェクト外へのファイルアクセス制限
- 不正なシーンファイルのサニタイズ
- エディタプラグインの信頼性確認

## 備考

- エディタはDebugビルドまたはeditor=trueでコンパイル
- TOOLS_ENABLEDマクロでエディタ専用コードを制御

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、EditorNodeの核となるデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | editor_node.h | `editor/editor_node.h` | EditorNodeクラス、MenuOptions enum |
| 1-2 | editor_data.h | `editor/editor_data.h` | EditorDataクラス（シーン/選択管理） |
| 1-3 | editor_plugin.h | `editor/plugins/editor_plugin.h` | EditorPluginベースクラス |

**読解のコツ**: EditorNodeはシングルトンパターンで、全エディタ機能の中心。MenuOptions enumが全メニュー項目を定義。

#### Step 2: メニュー構造を理解する

エディタのメニュー構成を把握。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | editor_node.h | `editor/editor_node.h` | MenuOptions enum（141-225行目） |
| 2-2 | editor_node.cpp | `editor/editor_node.cpp` | _menu_option()メソッド |

**主要処理フロー**:
- **142-161行目**: Scene menu（新規/開く/保存/閉じる）
- **165-179行目**: Project menu（設定/エクスポート）
- **184-198行目**: Editor menu（設定/レイアウト）
- **199-209行目**: Help menu

#### Step 3: UI構造を理解する

エディタのUI構成要素。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | editor_node.h | `editor/editor_node.h` | メンバー変数（UI要素） |
| 3-2 | editor_dock_manager.h | `editor/editor_dock_manager.h` | ドック管理 |

**主要UI要素**:
- **301-306行目**: DockSplitContainer群（レイアウト分割）
- **309行目**: EditorSceneTabs（シーンタブ）
- **411行目**: EditorMainScreen（メイン画面）
- **424行目**: EditorDockManager（ドック管理）
- **430行目**: EditorBottomPanel（下部パネル）

#### Step 4: シーン管理を理解する

シーンのライフサイクル管理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | editor_node.cpp | `editor/editor_node.cpp` | _save_scene(), _set_current_scene() |
| 4-2 | editor_data.h | `editor/editor_data.h` | edited_scene管理 |

**主要処理フロー**:
- **588-589行目**: _set_current_scene(), _set_current_scene_nocheck()
- **592-594行目**: _save_scene(), _save_all_scenes()
- **460行目**: scene_root（編集中シーンのルート）

#### Step 5: プラグインシステムを理解する

エディタプラグインの統合。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | editor_node.h | `editor/editor_node.h` | editor_plugins Vector |
| 5-2 | editor_plugin.h | `editor/plugins/editor_plugin.h` | EditorPluginベースクラス |

**主要処理フロー**:
- **280-285行目**: editor_plugins, addon_name_to_plugin, active_plugins
- **495-498行目**: コールバック配列

### プログラム呼び出し階層図

```
main() [platform/*/godot_*.cpp]
    │
    └─ Main::start()
           │
           └─ EditorNode::EditorNode()
                  │
                  ├─ _update_theme()
                  │      └─ EditorTheme構築
                  │
                  ├─ UI構築
                  │      ├─ MenuBar/PopupMenu作成
                  │      ├─ DockSplitContainer配置
                  │      ├─ EditorMainScreen作成
                  │      └─ EditorBottomPanel作成
                  │
                  ├─ プラグイン初期化
                  │      ├─ 組み込みプラグイン登録
                  │      └─ _enable_pending_addons()
                  │
                  └─ _load_editor_plugin_states_from_config()

EditorNode::_menu_option(option)
    │
    ├─ SCENE_NEW_SCENE → _new_scene()
    ├─ SCENE_OPEN_SCENE → _open_scene_dialog()
    ├─ SCENE_SAVE_SCENE → _save_scene()
    ├─ PROJECT_EXPORT → project_export->popup_export()
    └─ SCENE_QUIT → _quit_request()

EditorNode::_edit_current()
    │
    ├─ インスペクター更新
    │      └─ InspectorDock::edit()
    │
    └─ プラグイン通知
           └─ EditorPlugin::edit()
```

### データフロー図

```
[入力]                      [処理]                         [出力]

project.godot ────────▶ ProjectSettings ────────▶ 設定反映
                              │
                              ▼
*.tscn シーン ────────▶ EditorNode ────────────▶ シーンツリー表示
                              │
                              ▼
ユーザー操作 ────────▶ _menu_option() ───────▶ 各種処理
                              │
                              ▼
編集内容 ──────────▶ UndoRedo ──────────────▶ 履歴管理
                              │
                              ▼
保存操作 ──────────▶ _save_scene() ─────────▶ *.tscn出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| editor_node.h | `editor/editor_node.h` | ヘッダー | EditorNodeクラス定義 |
| editor_node.cpp | `editor/editor_node.cpp` | ソース | EditorNode実装 |
| editor_data.h | `editor/editor_data.h` | ヘッダー | エディタデータ管理 |
| editor_data.cpp | `editor/editor_data.cpp` | ソース | エディタデータ実装 |
| editor_plugin.h | `editor/plugins/editor_plugin.h` | ヘッダー | プラグインベースクラス |
| editor_plugin.cpp | `editor/plugins/editor_plugin.cpp` | ソース | プラグイン実装 |
| editor_main_screen.h | `editor/editor_main_screen.h` | ヘッダー | メイン画面 |
| editor_dock_manager.h | `editor/editor_dock_manager.h` | ヘッダー | ドック管理 |
| editor_scene_tabs.h | `editor/editor_scene_tabs.h` | ヘッダー | シーンタブ |
| editor_bottom_panel.h | `editor/editor_bottom_panel.h` | ヘッダー | 下部パネル |
| editor_settings.h | `editor/editor_settings.h` | ヘッダー | エディタ設定 |
| editor_themes.h | `editor/themes/editor_themes.h` | ヘッダー | テーマ管理 |
