# 機能設計書 46-スクリプトエディタ

## 概要

本ドキュメントは、Godot Engineにおける統合スクリプト編集機能「ScriptEditor」について、設計仕様を記載する。

### 本機能の処理概要

スクリプトエディタは、GDScript、C#、その他のスクリプト言語のソースコードを編集するための統合開発環境を提供する。構文ハイライト、コード補完、エラー表示、ブレークポイント設定、検索/置換、ヘルプドキュメント統合など、プログラミングに必要な機能を包括的に備える。

**業務上の目的・背景**：ゲーム開発におけるスクリプティングは主要な作業であり、効率的なコード編集環境が生産性を大きく左右する。スクリプトエディタは、Godot専用の構文サポートや即座のエラーフィードバックにより、開発効率を向上させる。

**機能の利用シーン**：
- GDScript/C#スクリプトの作成・編集
- コードのデバッグ（ブレークポイント設定）
- 関数/変数の検索・ジャンプ
- コードドキュメントの参照
- テキストファイル（JSON、設定ファイル等）の編集

**主要な処理内容**：
1. スクリプトファイルの読み込み・保存
2. 構文ハイライトの適用
3. コード補完・ヒント表示
4. エラー/警告のリアルタイム表示
5. 検索・置換（ファイル内/プロジェクト全体）
6. ブレークポイント管理
7. オンラインヘルプとの連携

**関連システム・外部連携**：GDScriptコンパイラ、Language Server、デバッガー、ヘルプシステムと連携する。

**権限による制御**：外部エディタ設定により、Visual Studio Code等の外部エディタへの切り替えが可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | スクリプトエディタ | 主画面 | スクリプト編集全般 |
| 15 | デバッガ | 連携画面 | ブレークポイント、実行制御 |
| 30 | スクリプト作成ダイアログ | 従属画面 | 新規スクリプト作成 |

## 機能種別

GUI / テキストエディタ / IDE

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| script_path | String | Yes | スクリプトファイルパス | .gd/.cs/.json等 |
| line | int | No | ジャンプ先行番号 | 1以上 |
| column | int | No | ジャンプ先列番号 | 0以上 |

### 入力データソース

- スクリプトファイル（.gd, .cs, .json等）
- テキストファイル（.txt, .md, .cfg等）
- 組み込みスクリプト（シーンファイル内）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 編集済みスクリプト | Resource | 保存されたスクリプトリソース |
| エラー一覧 | List<Error> | 構文エラー/警告 |
| ブレークポイント | PackedInt32Array | 設定されたブレークポイント行番号 |

### 出力先

- スクリプトファイル（外部/組み込み）
- デバッガー（ブレークポイント情報）

## 処理フロー

### 処理シーケンス

```
1. スクリプトオープン
   └─ edit()呼び出し
   └─ _open_script()でタブ作成
   └─ ScriptTextEditor生成

2. 構文ハイライト適用
   └─ EditorSyntaxHighlighter選択
   └─ _update_cache()でキーワード設定

3. コード編集
   └─ CodeTextEditorでテキスト編集
   └─ リアルタイム構文解析
   └─ エラー/警告表示

4. 保存処理
   └─ apply_code()
   └─ ResourceSaver::save()
   └─ tag_saved_version()

5. ブレークポイント設定
   └─ _set_breakpoint()
   └─ デバッガーへ通知
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプトを開く] --> B{スクリプト種別}
    B -->|GDScript| C[GDScriptハイライター]
    B -->|C#| D[C#ハイライター]
    B -->|テキスト| E[プレーンテキスト]
    C --> F[ScriptTextEditor作成]
    D --> F
    E --> F
    F --> G[タブに追加]
    G --> H[コード編集]
    H --> I{変更あり?}
    I -->|Yes| J[unsaved マーク]
    I -->|No| H
    J --> K{保存?}
    K -->|Yes| L[apply_code]
    K -->|No| H
    L --> M[ResourceSaver::save]
    M --> N[tag_saved_version]
    N --> H
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-46-01 | 自動保存 | 設定間隔でスクリプトを自動保存 | 設定で有効化時 |
| BR-46-02 | 末尾空白削除 | 保存時に行末の空白を削除 | 設定で有効化時 |
| BR-46-03 | 最終改行挿入 | 保存時にファイル末尾に改行を追加 | 設定で有効化時 |
| BR-46-04 | 最近開いたスクリプト | 直近のスクリプト一覧をメニューに表示 | 常時 |
| BR-46-05 | 外部変更検知 | ファイルの外部変更を検知してリロード確認 | 常時 |

### 計算ロジック

- ズーム係数: zoom_factor（1.0がデフォルト）
- 履歴管理: historyベクターで編集履歴を管理

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| PARSE_ERROR | 構文エラー | GDScript構文エラー | エディタ内にエラー表示 |
| SAVE_ERROR | 保存エラー | 書き込み権限なし | エラーダイアログ表示 |
| FILE_CHANGED | 外部変更 | ディスク上のファイルが変更された | リロード確認ダイアログ |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし（Undo/Redoで操作履歴管理）

## パフォーマンス要件

- 構文ハイライト: リアルタイム（入力追従）
- コード補完: <100ms応答
- 大規模ファイル: 遅延読み込み対応

## セキュリティ考慮事項

- 外部エディタ起動時のコマンドインジェクション対策
- 不正なスクリプトファイルのサニタイズ

## 備考

- C#スクリプトは外部エディタ（Visual Studio/Rider）推奨
- Language Server Protocol対応で補完精度向上

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、スクリプトエディタの核となるデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | script_editor_plugin.h | `editor/script/script_editor_plugin.h` | ScriptEditor、ScriptEditorBaseクラス |
| 1-2 | script_text_editor.h | `editor/script/script_text_editor.h` | ScriptTextEditorクラス |
| 1-3 | code_text_editor.h | `editor/code_editor/code_text_editor.h` | CodeTextEditorクラス |

**読解のコツ**: ScriptEditorBaseは抽象基底クラスで、ScriptTextEditorが具体的な実装。CodeTextEditorがテキスト編集の基盤。

#### Step 2: メニュー構造を理解する

スクリプトエディタのメニュー構成を把握。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | script_editor_plugin.h | `editor/script/script_editor_plugin.h` | MenuOptions enum（258-309行目） |
| 2-2 | script_editor_plugin.cpp | `editor/script/script_editor_plugin.cpp` | _menu_option()メソッド |

**主要処理フロー**:
- **259-265行目**: File menu（新規/開く/保存）
- **275-276行目**: History（前へ/次へ）
- **280-284行目**: Close操作群
- **294-300行目**: Search menu

#### Step 3: 構文ハイライトを理解する

各言語用のシンタックスハイライター。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | script_editor_plugin.h | `editor/script/script_editor_plugin.h` | EditorSyntaxHighlighterクラス階層 |

**構文ハイライタークラス**:
- **53-74行目**: EditorSyntaxHighlighter（基底クラス）
- **76-94行目**: EditorStandardSyntaxHighlighter
- **96-103行目**: EditorPlainTextSyntaxHighlighter
- **105-121行目**: EditorJSONSyntaxHighlighter
- **123-139行目**: EditorMarkdownSyntaxHighlighter
- **141-161行目**: EditorConfigFileSyntaxHighlighter

#### Step 4: スクリプト編集基盤を理解する

ScriptEditorBaseの抽象インターフェース。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | script_editor_plugin.h | `editor/script/script_editor_plugin.h` | ScriptEditorBaseクラス（191-247行目） |

**主要メソッド**:
- **206-209行目**: apply_code(), get_edited_resource(), get_functions()
- **218-220行目**: goto_line(), set_executing_line(), clear_executing_line()
- **228-230行目**: get_breakpoints(), set_breakpoint(), clear_breakpoints()

#### Step 5: UI構成を理解する

スクリプトエディタのUI要素。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | script_editor_plugin.h | `editor/script/script_editor_plugin.h` | メンバー変数（323-370行目） |

**主要UI要素**:
- **324-328行目**: メニューボタン（file_menu, edit_menu等）
- **340-341行目**: script_list, script_split
- **342行目**: members_overview（メンバー一覧）
- **353行目**: tab_container（タブコンテナ）
- **358行目**: find_replace_bar

### プログラム呼び出し階層図

```
ScriptEditor::edit(Resource)
    │
    ├─ _open_script()
    │      ├─ ScriptTextEditor作成
    │      ├─ EditorSyntaxHighlighter適用
    │      └─ tab_containerに追加
    │
    └─ _update_script_names()

ScriptEditor::_menu_option(option)
    │
    ├─ FILE_MENU_NEW → ScriptCreateDialog::popup()
    ├─ FILE_MENU_SAVE → _save_current_script()
    ├─ FILE_MENU_CLOSE → _close_current_tab()
    └─ SEARCH_IN_FILES → find_in_files_dialog->popup()

ScriptTextEditor::apply_code()
    │
    ├─ get_text_editor()->get_text()
    ├─ script->set_source_code()
    └─ script->reload()

ScriptEditorBase::set_breakpoint(line, enabled)
    │
    └─ EditorDebuggerNode通知
           └─ ブレークポイント登録
```

### データフロー図

```
[入力]                      [処理]                         [出力]

*.gd スクリプト ────▶ ScriptTextEditor ────────▶ 構文ハイライト表示
                              │
                              ▼
ユーザー編集 ─────────▶ CodeTextEditor ────────▶ テキスト更新
                              │
                              ▼
構文解析 ────────────▶ GDScriptParser ─────────▶ エラー/警告表示
                              │
                              ▼
保存操作 ────────────▶ apply_code() ──────────▶ *.gd ファイル
                              │
                              ▼
ブレークポイント ───▶ set_breakpoint() ────────▶ デバッガー
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| script_editor_plugin.h | `editor/script/script_editor_plugin.h` | ヘッダー | ScriptEditor/Base/Highlighter定義 |
| script_editor_plugin.cpp | `editor/script/script_editor_plugin.cpp` | ソース | ScriptEditor実装 |
| script_text_editor.h | `editor/script/script_text_editor.h` | ヘッダー | ScriptTextEditor定義 |
| script_text_editor.cpp | `editor/script/script_text_editor.cpp` | ソース | ScriptTextEditor実装 |
| text_editor.h | `editor/script/text_editor.h` | ヘッダー | TextEditor定義 |
| text_editor.cpp | `editor/script/text_editor.cpp` | ソース | TextEditor実装 |
| code_text_editor.h | `editor/code_editor/code_text_editor.h` | ヘッダー | CodeTextEditor定義 |
| code_text_editor.cpp | `editor/code_editor/code_text_editor.cpp` | ソース | CodeTextEditor実装 |
| find_in_files.h | `editor/code_editor/find_in_files.h` | ヘッダー | ファイル内検索 |
| find_in_files.cpp | `editor/code_editor/find_in_files.cpp` | ソース | ファイル内検索実装 |
| script_create_dialog.h | `editor/script/script_create_dialog.h` | ヘッダー | スクリプト作成ダイアログ |
| script_create_dialog.cpp | `editor/script/script_create_dialog.cpp` | ソース | スクリプト作成ダイアログ実装 |
