# 機能設計書 47-アニメーションエディタ

## 概要

本ドキュメントは、Godot Engineにおけるアニメーション編集機能「AnimationTrackEditor」について、設計仕様を記載する。

### 本機能の処理概要

アニメーションエディタは、AnimationPlayerやAnimationTreeで使用するアニメーションリソースを視覚的に編集するためのツールである。タイムラインベースのインターフェースでキーフレームを配置し、プロパティの時間変化を定義する。複数のトラックタイプ（値、変換、メソッド呼び出し、ベジエカーブ等）をサポートする。

**業務上の目的・背景**：ゲーム開発において、キャラクターの動き、UI遷移、エフェクト等あらゆる要素にアニメーションが必要となる。コードベースではなく視覚的にアニメーションを作成・調整できることで、アーティストやデザイナーも直接作業できる。

**機能の利用シーン**：
- キャラクターアニメーション（歩行、攻撃、アイドル等）の作成
- UIアニメーション（フェードイン/アウト、スライド等）
- カメラワーク（パン、ズーム等）
- プロパティの補間（色、サイズ、位置等）
- AnimationTree用のステートマシン定義

**主要な処理内容**：
1. アニメーショントラックの作成・削除
2. キーフレームの挿入・編集・削除
3. 補間曲線（イージング）の設定
4. ベジエカーブ編集
5. アニメーションブレンドスペースの設定
6. マーカーの配置・管理

**関連システム・外部連携**：AnimationPlayer、AnimationTree、インスペクターと連携する。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | アニメーションエディタ | 主画面 | アニメーション編集全般 |
| 3 | インスペクター | 連携画面 | キーフレームプロパティ編集 |

## 機能種別

GUI / タイムラインエディタ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| animation | Animation | Yes | 編集対象アニメーション | 有効なAnimation |
| root_node | Node | Yes | アニメーションルートノード | シーン内ノード |
| track | int | No | 編集対象トラック | 0以上 |

### 入力データソース

- Animationリソース
- AnimationPlayer/AnimationTreeノード

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 編集済みAnimation | Animation | キーフレーム等が更新されたアニメーション |

### 出力先

- Animationリソース（外部/組み込み）

## 処理フロー

### 処理シーケンス

```
1. アニメーション選択
   └─ AnimationPlayerでアニメーション選択
   └─ AnimationTrackEditorにセット

2. トラック作成
   └─ add_track()でトラック追加
   └─ トラックタイプ選択

3. キーフレーム編集
   └─ キー挿入位置をタイムラインでクリック
   └─ track_insert_key()でキー追加
   └─ インスペクターで値編集

4. 補間設定
   └─ イージングタイプ選択
   └─ ベジエハンドル調整（ベジエトラックの場合）

5. 再生プレビュー
   └─ AnimationPlayerで再生
   └─ リアルタイム確認
```

### フローチャート

```mermaid
flowchart TD
    A[AnimationPlayer選択] --> B[アニメーション選択]
    B --> C[AnimationTrackEditor表示]
    C --> D{操作種別}
    D -->|トラック追加| E[add_track]
    D -->|キー挿入| F[track_insert_key]
    D -->|キー編集| G[インスペクター編集]
    D -->|キー削除| H[track_remove_key]
    E --> I[トラックリスト更新]
    F --> J[タイムライン更新]
    G --> J
    H --> J
    I --> D
    J --> D
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-47-01 | FPS/秒切替 | タイムライン表示を秒またはフレームで切替可能 | 常時 |
| BR-47-02 | スナップ | キー挿入時に指定間隔にスナップ | スナップ有効時 |
| BR-47-03 | オニオンスキニング | 前後フレームを透過表示 | 設定で有効化時 |
| BR-47-04 | ループ設定 | アニメーションのループ種別を設定 | 常時 |

### 計算ロジック

- ズーム係数: SCROLL_ZOOM_FACTOR_IN (1.02f) / SCROLL_ZOOM_FACTOR_OUT (0.98f)
- 補間計算: Animation::interpolate_variant()

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| INVALID_TRACK | トラックエラー | 無効なノードパス | パスを修正 |
| KEY_ERROR | キーエラー | 無効なキー位置 | 位置を修正 |

### リトライ仕様

該当なし（Undo/Redoで操作履歴管理）

## パフォーマンス要件

- タイムライン描画: 60fps維持
- キー操作: リアルタイム応答

## 備考

- AnimationTrackEditorPluginsで各トラックタイプ用のプラグインを実装
- ベジエカーブ編集はAnimationBezierEditorで専用処理

---

## コードリーディングガイド

### 推奨読解順序

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1 | animation_track_editor.h | `editor/animation/animation_track_editor.h` | AnimationTrackEditor、AnimationTimelineEditクラス |
| 2 | animation_bezier_editor.h | `editor/animation/animation_bezier_editor.h` | ベジエカーブエディタ |
| 3 | animation_player_editor_plugin.h | `editor/animation/animation_player_editor_plugin.h` | AnimationPlayerプラグイン |
| 4 | animation_tree_editor_plugin.h | `editor/animation/animation_tree_editor_plugin.h` | AnimationTreeプラグイン |

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| animation_track_editor.h | `editor/animation/animation_track_editor.h` | ヘッダー | トラックエディタ定義 |
| animation_track_editor.cpp | `editor/animation/animation_track_editor.cpp` | ソース | トラックエディタ実装 |
| animation_bezier_editor.h | `editor/animation/animation_bezier_editor.h` | ヘッダー | ベジエエディタ |
| animation_player_editor_plugin.h | `editor/animation/animation_player_editor_plugin.h` | ヘッダー | プレイヤープラグイン |
| animation_tree_editor_plugin.h | `editor/animation/animation_tree_editor_plugin.h` | ヘッダー | ツリープラグイン |
| animation_blend_space_1d_editor.h | `editor/animation/animation_blend_space_1d_editor.h` | ヘッダー | 1Dブレンドスペース |
| animation_blend_space_2d_editor.h | `editor/animation/animation_blend_space_2d_editor.h` | ヘッダー | 2Dブレンドスペース |
| animation_state_machine_editor.h | `editor/animation/animation_state_machine_editor.h` | ヘッダー | ステートマシン |
| animation_library_editor.h | `editor/animation/animation_library_editor.h` | ヘッダー | ライブラリエディタ |
