# 機能設計書 48-ファイルシステムドック

## 概要

本ドキュメントは、Godot Engineにおけるプロジェクトファイル管理機能「FileSystemDock」について、設計仕様を記載する。

### 本機能の処理概要

ファイルシステムドックは、プロジェクト内のファイル・フォルダを階層的に表示・管理するためのドックパネルである。リソースの閲覧、作成、移動、削除、インポート設定など、ファイル操作全般を担当する。ツリービューとリストビューの2つの表示モードを提供する。

**業務上の目的・背景**：ゲームプロジェクトには多数のリソース（テクスチャ、オーディオ、シーン、スクリプト等）が含まれる。これらを効率的に整理・管理し、必要なリソースを素早く見つけて操作できることが開発効率に直結する。

**機能の利用シーン**：
- プロジェクトリソースの閲覧・検索
- ファイル/フォルダの作成・削除・移動・名前変更
- シーン/スクリプト/リソースの新規作成
- お気に入りフォルダの管理
- リソースの依存関係確認
- エクスプローラー/Finderでの表示

**主要な処理内容**：
1. プロジェクトディレクトリのスキャン・表示
2. ファイル/フォルダ操作（CRUD）
3. ドラッグ＆ドロップによる移動/コピー
4. 検索・フィルタリング
5. お気に入り管理
6. 依存関係の解析・表示

**関連システム・外部連携**：EditorFileSystem、リソースローダー、インスペクターと連携する。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | ファイルシステムドック | 主画面 | ファイル管理全般 |
| 3 | インスペクター | 連携画面 | 選択リソースのプロパティ表示 |

## 機能種別

GUI / ファイルマネージャー

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| path | String | No | 現在のパス | res://形式 |
| filter | String | No | フィルタ文字列 | 任意 |

### 入力データソース

- EditorFileSystem（ファイルシステム情報）
- プロジェクトディレクトリ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 選択パス | String | 現在選択中のパス |
| 選択リソース | Resource | 選択中のリソース |

### 出力先

- エディタ各部（シーン、インスペクター等）へのリソース参照

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ EditorFileSystemからファイル情報取得
   └─ ツリー/リスト構築

2. ユーザー操作
   └─ ファイル選択 → インスペクター更新
   └─ ダブルクリック → リソース編集
   └─ 右クリック → コンテキストメニュー

3. ファイル操作
   └─ 作成/削除/移動/名前変更
   └─ UndoRedo登録
   └─ ファイルシステム更新

4. 検索
   └─ フィルタ文字列適用
   └─ 表示項目絞り込み
```

### フローチャート

```mermaid
flowchart TD
    A[ファイルシステムドック表示] --> B{表示モード}
    B -->|ツリー| C[FileSystemTree]
    B -->|リスト| D[FileSystemList]
    C --> E[フォルダ展開/折りたたみ]
    D --> F[サムネイル/リスト表示]
    E --> G{ユーザー操作}
    F --> G
    G -->|選択| H[選択シグナル発行]
    G -->|ダブルクリック| I[リソースオープン]
    G -->|右クリック| J[コンテキストメニュー]
    H --> K[インスペクター更新]
    I --> L[該当エディタで編集]
    J --> M[ファイル操作メニュー]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-48-01 | 表示モード | ツリーのみ/縦分割/横分割の3モード | 常時 |
| BR-48-02 | ファイルリスト表示 | サムネイル/リスト表示切替 | リスト表示時 |
| BR-48-03 | お気に入り | よく使うフォルダを上部に固定表示 | 常時 |
| BR-48-04 | フォルダ色 | フォルダにカスタムカラーを設定可能 | 常時 |
| BR-48-05 | ソート | 名前/パス順でソート可能 | 常時 |

### 計算ロジック

- FileSortOption enumでソート順を定義

## データベース操作仕様

本機能はデータベース操作を行わない（ファイルシステムベース）。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| FILE_EXISTS | 上書き確認 | 同名ファイルが存在 | 上書き/名前変更選択 |
| DEPENDENCY_ERROR | 依存エラー | 参照されているファイルの削除 | 依存関係確認ダイアログ |
| PERMISSION_ERROR | 権限エラー | 書き込み権限なし | エラーダイアログ |

## 備考

- res://プレフィックスがプロジェクトルート
- .gdignoreファイルでスキャン除外可能

---

## コードリーディングガイド

### 推奨読解順序

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1 | filesystem_dock.h | `editor/docks/filesystem_dock.h` | FileSystemDockクラス、FileMenu enum |
| 2 | editor_file_system.h | `editor/file_system/editor_file_system.h` | EditorFileSystemクラス |

**主要な構造**:
- **61-63行目**: FileSystemTree（ツリー表示用）
- **65-85行目**: FileSystemList（リスト表示用）
- **87-88行目**: FileSystemDockはEditorDockを継承
- **91-94行目**: FileListDisplayMode enum（THUMBNAILS/LIST）
- **96-100行目**: DisplayMode enum（TREE_ONLY/VSPLIT/HSPLIT）
- **109-145行目**: FileMenu enum（各種ファイル操作）

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| filesystem_dock.h | `editor/docks/filesystem_dock.h` | ヘッダー | FileSystemDock定義 |
| filesystem_dock.cpp | `editor/docks/filesystem_dock.cpp` | ソース | FileSystemDock実装 |
| editor_file_system.h | `editor/file_system/editor_file_system.h` | ヘッダー | ファイルシステム管理 |
| editor_file_system.cpp | `editor/file_system/editor_file_system.cpp` | ソース | ファイルシステム実装 |
| dependency_editor.h | `editor/file_system/dependency_editor.h` | ヘッダー | 依存関係エディタ |
| file_info.h | `editor/file_system/file_info.h` | ヘッダー | ファイル情報 |
