# 機能設計書 49-インスペクター

## 概要

本ドキュメントは、Godot Engineにおけるオブジェクトプロパティ編集機能「EditorInspector」について、設計仕様を記載する。

### 本機能の処理概要

インスペクターは、選択されたノード・リソースのプロパティを一覧表示し、編集するためのドックパネルである。オブジェクトのメタデータを解析し、適切なプロパティエディタ（スライダー、カラーピッカー、テキストフィールド等）を動的に生成する。

**業務上の目的・背景**：Godotのノードベースのアーキテクチャでは、各ノードの振る舞いはプロパティ値で制御される。インスペクターはこれらのプロパティを視覚的に編集する唯一のインターフェースであり、コードを書かずに設定を変更できる。

**機能の利用シーン**：
- ノードのTransform（位置、回転、スケール）設定
- マテリアル/テクスチャの設定
- スクリプトの@export変数編集
- リソースのプロパティ設定
- シグナル接続設定

**主要な処理内容**：
1. 選択オブジェクトのプロパティ情報取得
2. プロパティエディタの動的生成
3. 値の編集とオブジェクトへの反映
4. Undo/Redo登録
5. プロパティのコピー/ペースト
6. デフォルト値へのリバート

**関連システム・外部連携**：全てのエディタコンポーネント（シーンツリー、ファイルシステムドック等）と連携する。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 3 | インスペクター | 主画面 | プロパティ編集全般 |

## 機能種別

GUI / プロパティエディタ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| object | Object | Yes | 編集対象オブジェクト | 有効なObject |
| property | StringName | No | フォーカスするプロパティ | 存在するプロパティ |

### 入力データソース

- EditorSelection（選択状態）
- Object::get_property_list()

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| property_changed | Signal | プロパティ変更通知 |
| object_id_selected | Signal | サブリソース選択通知 |

### 出力先

- 編集対象オブジェクト
- UndoRedoシステム

## 処理フロー

### 処理シーケンス

```
1. オブジェクト選択
   └─ EditorSelectionから選択取得
   └─ edit(object)呼び出し

2. プロパティ情報取得
   └─ Object::get_property_list()
   └─ PROPERTY_USAGE_*フラグで表示判定

3. エディタ生成
   └─ プロパティタイプに応じたEditorProperty生成
   └─ セクション/グループ構築

4. 値編集
   └─ ユーザー入力
   └─ Object::set()で値反映
   └─ UndoRedo::create_action()

5. 更新
   └─ property_edited通知
   └─ 関連プロパティ再描画
```

### フローチャート

```mermaid
flowchart TD
    A[オブジェクト選択] --> B[edit呼び出し]
    B --> C[get_property_list]
    C --> D[PROPERTY_USAGE判定]
    D --> E{表示対象?}
    E -->|Yes| F[EditorProperty生成]
    E -->|No| D
    F --> G[セクション配置]
    G --> H[値表示]
    H --> I{ユーザー編集}
    I -->|変更| J[Object::set]
    I -->|リバート| K[デフォルト値復元]
    J --> L[UndoRedo登録]
    K --> L
    L --> M[property_edited発行]
    M --> H
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-49-01 | グループ化 | PROPERTY_USAGE_GROUPでセクション分け | 常時 |
| BR-49-02 | 読み取り専用 | PROPERTY_USAGE_READ_ONLYで編集不可 | 該当プロパティ |
| BR-49-03 | リバート | デフォルト値と異なる場合リバートアイコン表示 | 常時 |
| BR-49-04 | キーイング | アニメーション記録中はキーフレーム挿入ボタン表示 | 記録中 |
| BR-49-05 | お気に入り | よく使うプロパティをお気に入り登録可能 | 常時 |

### 計算ロジック

- プロパティ表示順: PROPERTY_USAGE_CATEGORYでカテゴリ分け
- 色分け: sub_inspector_color_levelでネスト表現

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| INVALID_VALUE | 値エラー | 無効な値入力 | バリデーションでブロック |
| READONLY | 読み取り専用 | 編集不可プロパティへの書き込み | エディタを無効化 |

## 備考

- EditorPropertyクラスは各プロパティタイプ用のエディタ基底クラス
- EditorInspectorPluginでカスタムプロパティエディタを追加可能

---

## コードリーディングガイド

### 推奨読解順序

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1 | editor_inspector.h | `editor/inspector/editor_inspector.h` | EditorInspector、EditorPropertyクラス |
| 2 | editor_properties.h | `editor/inspector/editor_properties.h` | 各種プロパティエディタ |
| 3 | editor_properties_array_dict.h | `editor/inspector/editor_properties_array_dict.h` | 配列/辞書エディタ |

**主要な構造**:
- **52-56行目**: EditorPropertyRevertクラス（リバート機能）
- **70-71行目**: EditorPropertyはContainerを継承
- **119-129行目**: MenuItems enum（コンテキストメニュー項目）
- **131-135行目**: ColorationMode enum
- **137-140行目**: InlineControlSide enum

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| editor_inspector.h | `editor/inspector/editor_inspector.h` | ヘッダー | EditorInspector定義 |
| editor_inspector.cpp | `editor/inspector/editor_inspector.cpp` | ソース | EditorInspector実装 |
| editor_properties.h | `editor/inspector/editor_properties.h` | ヘッダー | 基本プロパティエディタ |
| editor_properties.cpp | `editor/inspector/editor_properties.cpp` | ソース | 基本プロパティエディタ実装 |
| editor_properties_array_dict.h | `editor/inspector/editor_properties_array_dict.h` | ヘッダー | 配列/辞書エディタ |
| editor_properties_vector.h | `editor/inspector/editor_properties_vector.h` | ヘッダー | ベクトルエディタ |
| editor_resource_picker.h | `editor/inspector/editor_resource_picker.h` | ヘッダー | リソースピッカー |
| property_selector.h | `editor/inspector/property_selector.h` | ヘッダー | プロパティセレクター |
| multi_node_edit.h | `editor/inspector/multi_node_edit.h` | ヘッダー | マルチノード編集 |
