# 機能設計書 50-デバッガー

## 概要

本ドキュメントは、Godot Engineにおけるデバッグ機能「EditorDebuggerNode」について、設計仕様を記載する。

### 本機能の処理概要

デバッガーは、実行中のゲームプロジェクトをリモートでデバッグするためのツールである。ブレークポイントでの停止、ステップ実行、変数監視、スタックトレース表示、リモートシーンツリー操作など、包括的なデバッグ機能を提供する。EditorDebuggerServerを通じてゲームプロセスと通信する。

**業務上の目的・背景**：ゲーム開発において、バグの原因特定は重要な作業である。デバッガーにより、コードの実行を一時停止し、変数の状態を確認し、処理の流れを追跡することで、効率的にバグを発見・修正できる。

**機能の利用シーン**：
- ブレークポイントでの実行停止と状態確認
- ステップ実行（ステップイン/ステップオーバー/ステップアウト）
- 変数値の監視・変更
- スタックトレースの確認
- リモートシーンツリーの閲覧・編集
- エラー/警告ログの確認

**主要な処理内容**：
1. デバッグサーバーの起動・接続管理
2. ブレークポイントの設定・管理
3. 実行制御（停止/続行/ステップ）
4. 変数・オブジェクトの監視
5. リモートシーンツリーの取得・操作
6. エラー/警告の収集・表示

**関連システム・外部連携**：スクリプトエディタ、リモートシーンツリー、GDScript/C#ランタイムと連携する。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 15 | デバッガ | 主画面 | デバッグ操作全般 |
| 5 | スクリプトエディタ | 連携画面 | ブレークポイント設定、実行位置表示 |

## 機能種別

開発ツール / デバッガー

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| script_path | String | Yes | ブレークポイント設定先スクリプト | 有効なパス |
| line | int | Yes | ブレークポイント行番号 | 1以上 |
| enabled | bool | No | ブレークポイント有効/無効 | デフォルトtrue |

### 入力データソース

- スクリプトエディタ（ブレークポイント情報）
- 実行中ゲームプロセス（デバッグデータ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| stack_trace | Array | スタックトレース情報 |
| variables | Dictionary | ローカル/メンバー変数 |
| remote_tree | RemoteTree | リモートシーンツリー |
| errors/warnings | Array | エラー/警告リスト |

### 出力先

- デバッガーパネル
- スクリプトエディタ（実行位置ハイライト）

## 処理フロー

### 処理シーケンス

```
1. デバッグセッション開始
   └─ EditorDebuggerServer起動
   └─ ゲームプロセス起動
   └─ 接続確立

2. ブレークポイント設定
   └─ set_breakpoint()
   └─ ゲームプロセスへ通知

3. 実行制御
   └─ ブレークポイントで停止
   └─ スタック情報取得
   └─ 変数情報取得

4. ステップ実行
   └─ debug_next()/debug_step()
   └─ 次の停止位置まで実行

5. セッション終了
   └─ debug_continue()
   └─ 接続切断
```

### フローチャート

```mermaid
flowchart TD
    A[プロジェクト実行] --> B[デバッグサーバー起動]
    B --> C[ゲームプロセス接続]
    C --> D[実行開始]
    D --> E{ブレークポイント?}
    E -->|Yes| F[実行停止]
    E -->|No| G{エラー発生?}
    F --> H[スタック取得]
    H --> I[変数取得]
    I --> J[リモートツリー取得]
    J --> K{ユーザー操作}
    K -->|Continue| D
    K -->|Step| L[1行実行]
    K -->|Stop| M[セッション終了]
    L --> E
    G -->|Yes| N[エラー表示]
    G -->|No| D
    N --> D
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-50-01 | 複数セッション | 複数のデバッグセッションを同時管理可能 | マルチプレイテスト時 |
| BR-50-02 | カメラオーバーライド | エディタカメラでゲーム内を操作可能 | 有効化時 |
| BR-50-03 | ブレークポイント持続 | エディタ再起動後もブレークポイント維持 | 常時 |
| BR-50-04 | エラーブレーク | 例外発生時に自動停止 | 設定で有効化時 |

### 計算ロジック

- CameraOverride enum: NONE/INGAME/EDITORS

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| CONNECTION_ERROR | 接続エラー | ゲームプロセス接続失敗 | ゲーム再起動 |
| TIMEOUT | タイムアウト | 応答待ち超過 | 再接続 |

## 備考

- Debug Adapter Protocol (DAP)対応でVSCode等からデバッグ可能
- リモートデバッグ（異なるデバイス）もサポート

---

## コードリーディングガイド

### 推奨読解順序

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1 | editor_debugger_node.h | `editor/debugger/editor_debugger_node.h` | EditorDebuggerNode、Breakpoint構造体 |
| 2 | script_editor_debugger.h | `editor/debugger/script_editor_debugger.h` | ScriptEditorDebuggerクラス |
| 3 | editor_debugger_server.h | `editor/debugger/editor_debugger_server.h` | デバッグサーバー |

**主要な構造**:
- **47-48行目**: EditorDebuggerNodeはEditorDockを継承
- **51-55行目**: CameraOverride enum（NONE/INGAME/EDITORS）
- **58-64行目**: Options enum（DEBUG_NEXT/STEP/BREAK/CONTINUE）
- **66-92行目**: Breakpoint構造体（source, line）
- **94行目**: EditorDebuggerServerへの参照
- **118行目**: breakpointsハッシュマップ
- **176-179行目**: debug_next(), debug_step(), debug_break(), debug_continue()

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| editor_debugger_node.h | `editor/debugger/editor_debugger_node.h` | ヘッダー | デバッガーノード定義 |
| editor_debugger_node.cpp | `editor/debugger/editor_debugger_node.cpp` | ソース | デバッガーノード実装 |
| script_editor_debugger.h | `editor/debugger/script_editor_debugger.h` | ヘッダー | スクリプトデバッガー |
| script_editor_debugger.cpp | `editor/debugger/script_editor_debugger.cpp` | ソース | スクリプトデバッガー実装 |
| editor_debugger_server.h | `editor/debugger/editor_debugger_server.h` | ヘッダー | デバッグサーバー |
| editor_debugger_server.cpp | `editor/debugger/editor_debugger_server.cpp` | ソース | デバッグサーバー実装 |
| editor_debugger_tree.h | `editor/debugger/editor_debugger_tree.h` | ヘッダー | リモートツリー |
| debug_adapter/ | `editor/debugger/debug_adapter/` | ディレクトリ | DAP実装 |
