# 機能設計書 51-Windows対応

## 概要

本ドキュメントは、Godot EngineにおけるWindowsプラットフォーム向けビルド・エクスポート機能の設計を記載するものである。

### 本機能の処理概要

**業務上の目的・背景**：ゲーム開発において、Windowsは最大のPCゲーム市場を持つプラットフォームである。開発者がGodot Engineで作成したゲームを、Windows向けの実行可能ファイル（.exe）としてエクスポートし、配布可能な形式で出力する機能は、プロジェクトの商用化において不可欠である。本機能により、開発者はエディタ上で完結するビルドプロセスを実現できる。

**機能の利用シーン**：
- ゲーム開発完了後のリリースビルド作成時
- デバッグ目的でのWindows実行ファイル生成時
- Steam等のプラットフォームへの配信準備時
- リモートWindowsマシンでのテスト実行時

**主要な処理内容**：
1. エクスポートテンプレートの選択とアーキテクチャ（x86_64/x86_32/arm64）の指定
2. アプリケーションアイコン（.ico）の生成と埋め込み
3. 実行ファイルへのリソース情報（バージョン、著作権等）の書き込み
4. PCKファイルの生成と実行ファイルへの埋め込み（オプション）
5. コード署名（signtool/osslsigncode使用）
6. D3D12/ANGLE ライブラリの同梱
7. SSH経由でのリモートデプロイ・実行

**関連システム・外部連携**：
- Windowsコード署名ツール（signtool.exe/osslsigncode）
- SSHクライアント（リモートデプロイ用）
- Visual Studioビルドツール（テンプレートビルド時）

**権限による制御**：特になし。ただし、コード署名には有効な証明書が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 23 | エクスポートダイアログ | 主画面 | Windows向けビルド設定・エクスポート実行 |

## 機能種別

ファイル生成処理 / プラットフォームエクスポート

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| binary_format/architecture | String | Yes | 出力アーキテクチャ | x86_64/x86_32/arm64のいずれか |
| custom_template/debug | String | No | カスタムデバッグテンプレートパス | ファイル存在チェック |
| custom_template/release | String | No | カスタムリリーステンプレートパス | ファイル存在チェック |
| binary_format/embed_pck | Bool | No | PCKを実行ファイルに埋め込むか | - |
| application/modify_resources | Bool | No | リソース情報を変更するか | - |
| application/icon | String | No | アプリケーションアイコンパス | .ico/.png/.webp/.svg |
| application/file_version | String | No | ファイルバージョン | X.X.X.X形式 |
| application/product_version | String | No | 製品バージョン | X.X.X.X形式 |
| codesign/enable | Bool | No | コード署名を有効にするか | - |
| codesign/identity | String | No | 署名証明書パスまたはSHA-1ハッシュ | - |
| codesign/password | String | No | 証明書パスワード | - |
| ssh_remote_deploy/enabled | Bool | No | SSHリモートデプロイを有効にするか | - |

### 入力データソース

- エクスポートプリセット設定（project.godot）
- エクスポートテンプレートファイル（.exe）
- プロジェクトリソース（アイコン画像等）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 実行ファイル | .exe | Windowsネイティブ実行ファイル |
| コンソールラッパー | .console.exe | コンソール出力付き実行ファイル |
| PCKファイル | .pck | ゲームデータパッケージ（非埋め込み時） |
| DLLファイル | .dll | ANGLE/D3D12/AccessKitライブラリ |
| ZIPアーカイブ | .zip | 配布用ZIPパッケージ（オプション） |

### 出力先

- 指定されたエクスポートパス
- 一時ディレクトリ（ZIP出力時）

## 処理フロー

### 処理シーケンス

```
1. エクスポート設定の検証
   └─ テンプレート存在確認、アーキテクチャ整合性チェック
2. テンプレートファイルの選択
   └─ カスタムテンプレートまたは標準テンプレートの決定
3. 必要なライブラリのコピー
   └─ ANGLE/D3D12/AccessKitライブラリの配置
4. プロジェクトのエクスポート（EditorExportPlatformPC::export_project）
   └─ PCK生成、テンプレートコピー、リソース埋め込み
5. リソース情報の変更（modify_resources有効時）
   └─ アイコン処理、バージョン情報書き込み
6. コード署名（codesign有効時）
   └─ signtool/osslsigncodeによる署名
7. PCK埋め込み処理（embed_pck有効時）
   └─ PE形式のpckセクション更新
8. ZIP作成（ZIP出力時）
   └─ ファイルのアーカイブ化
9. Windowsアイコンキャッシュ更新
   └─ SHChangeNotify呼び出し
```

### フローチャート

```mermaid
flowchart TD
    A[エクスポート開始] --> B{テンプレート検証}
    B -->|失敗| Z[エラー終了]
    B -->|成功| C[ライブラリコピー]
    C --> D[PCK生成・テンプレートコピー]
    D --> E{リソース変更?}
    E -->|Yes| F[アイコン・バージョン情報書き込み]
    E -->|No| G{コード署名?}
    F --> G
    G -->|Yes| H[signtool/osslsigncode実行]
    G -->|No| I{PCK埋め込み?}
    H --> I
    I -->|Yes| J[PEセクション更新]
    I -->|No| K{ZIP出力?}
    J --> K
    K -->|Yes| L[ZIPアーカイブ作成]
    K -->|No| M[アイコンキャッシュ更新]
    L --> M
    M --> N[エクスポート完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-51-01 | アーキテクチャ整合性 | カスタムテンプレートのアーキテクチャは設定と一致する必要がある | カスタムテンプレート使用時 |
| BR-51-02 | バージョン形式 | ファイル/製品バージョンはX.X.X.X形式（4つの整数） | バージョン指定時 |
| BR-51-03 | 実行ファイルサイズ制限 | 埋め込みPCK使用時、合計サイズは4GiB未満 | PCK埋め込み時 |
| BR-51-04 | コード署名タイムスタンプ | タイムスタンプサーバーURL必須 | タイムスタンプ有効時 |

### 計算ロジック

アイコンサイズ生成: 16x16, 32x32, 48x48, 64x64, 128x128, 256x256ピクセルのマルチサイズICOを生成

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR_FILE_NOT_FOUND | ファイル不在 | テンプレートファイルが存在しない | テンプレートのインストール |
| ERR_CANT_CREATE | 作成失敗 | 出力ディレクトリ作成不可 | 権限確認 |
| ERR_INVALID_DATA | データ不正 | 実行ファイルが4GiB以上 | PCK分離出力 |
| ERR_FILE_CORRUPT | 破損 | PEヘッダ不正/pckセクション不在 | テンプレート再取得 |
| FAILED | 署名失敗 | signtool実行エラー | 証明書・設定確認 |

### リトライ仕様

コード署名失敗時は自動リトライなし。ユーザーによる設定修正が必要。

## トランザクション仕様

ファイルシステム操作のため、トランザクション管理なし。一時ファイル使用時は処理完了後に削除。

## パフォーマンス要件

- PCK生成時間: プロジェクトサイズに依存
- コード署名: ネットワーク遅延（タイムスタンプサーバー）に依存

## セキュリティ考慮事項

- コード署名証明書パスワードは環境変数からも取得可能（PROPERTY_USAGE_SECRET）
- SSH認証情報の安全な管理が必要

## 備考

- Windows以外のホストからのエクスポート時はosslsigncodeを使用
- osslsigncodeはidentity_typeオプションをサポートしない

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

エクスポートプリセットとプラットフォーム情報を定義するクラス構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | export_plugin.h | `platform/windows/export/export_plugin.h` | EditorExportPlatformWindowsクラスの定義 |

**読解のコツ**: EditorExportPlatformWindowsはEditorExportPlatformPCを継承しており、PC系共通処理は親クラスで実装されている。

#### Step 2: エントリーポイントを理解する

エクスポート処理の起点となる関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | export_plugin.cpp | `platform/windows/export/export_plugin.cpp` | export_project関数がメインエントリ |

**主要処理フロー**:
1. **203-206行目**: カスタムテンプレートまたは標準テンプレートの決定
2. **250-298行目**: ANGLE/D3D12ライブラリのコピー処理
3. **306行目**: EditorExportPlatformPC::export_project呼び出し
4. **312-318行目**: コード署名処理
5. **320-326行目**: PCK埋め込み後のリネーム
6. **329-364行目**: ZIP作成またはアイコンキャッシュ更新

#### Step 3: アイコン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | export_plugin.cpp | `platform/windows/export/export_plugin.cpp` | _process_icon関数でICO生成 |

**主要処理フロー**:
- **72-182行目**: ICOファイルの読み込みまたはPNG→ICO変換
- **125-132行目**: 各サイズへのリサイズ処理
- **151-180行目**: ICONDIRとICONDIRENTRYの書き込み

#### Step 4: コード署名処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | export_plugin.cpp | `platform/windows/export/export_plugin.cpp` | _code_sign関数 |

**主要処理フロー**:
- **543-714行目**: signtool/osslsigncodeのコマンドライン構築と実行
- **569-602行目**: Windows環境とそれ以外での引数差異

#### Step 5: PCK埋め込み処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | export_plugin.cpp | `platform/windows/export/export_plugin.cpp` | fixup_embedded_pck関数 |

**主要処理フロー**:
- **806-917行目**: PEヘッダ解析とpckセクションのパッチ処理
- **820-831行目**: PEマジックナンバー検証
- **857-904行目**: pckセクションの検索と更新

### プログラム呼び出し階層図

```
EditorExportPlatformWindows::export_project
    │
    ├─ EditorExportPlatformPC::export_project (親クラス)
    │      └─ EditorExportPlatform::export_project_files
    │             └─ PCK生成処理
    │
    ├─ _add_data
    │      └─ _process_icon (ICO生成)
    │             └─ TemplateModifier::modify
    │
    ├─ _code_sign (コード署名)
    │      └─ OS::execute (signtool/osslsigncode)
    │
    └─ fixup_embedded_pck (PCK埋め込み)
           └─ PEセクション操作
```

### データフロー図

```
[入力]                      [処理]                           [出力]

プロジェクトファイル ──────▶ EditorExportPlatform ──────▶ PCKファイル
                             ::export_project_files

エクスポートテンプレート ──▶ テンプレートコピー ──────────▶ 実行ファイル(.exe)
(.exe)

アイコン画像 ──────────────▶ _process_icon ──────────────▶ ICOファイル
(.png/.ico)                  (リサイズ・変換)

設定パラメータ ────────────▶ TemplateModifier::modify ──▶ リソース情報埋め込み
                             _code_sign                    署名済み実行ファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| export_plugin.cpp | `platform/windows/export/export_plugin.cpp` | ソース | Windowsエクスポートプラグイン本体 |
| export_plugin.h | `platform/windows/export/export_plugin.h` | ヘッダ | クラス定義 |
| template_modifier.cpp | `platform/windows/export/template_modifier.cpp` | ソース | EXEリソース編集 |
| export.cpp | `platform/windows/export/export.cpp` | ソース | プラグイン登録 |
| os_windows.cpp | `platform/windows/os_windows.cpp` | ソース | Windows OS抽象化 |
| display_server_windows.cpp | `platform/windows/display_server_windows.cpp` | ソース | ウィンドウ管理 |
