# 機能設計書 52-macOS対応

## 概要

本ドキュメントは、Godot EngineにおけるmacOSプラットフォーム向けビルド・エクスポート機能の設計を記載するものである。

### 本機能の処理概要

**業務上の目的・背景**：macOSは、デスクトップゲーム市場の重要なプラットフォームである。Apple Silicon（M1/M2/M3）とIntelチップの両方をサポートするユニバーサルバイナリの生成、App Store配布のためのコード署名・公証（Notarization）、サンドボックス対応など、macOS固有の要件を満たすエクスポート機能を提供する。

**機能の利用シーン**：
- macOS向けゲームのリリースビルド作成時
- App Store配布用パッケージ（.pkg）の生成時
- テスト用DMGイメージの作成時
- ユニバーサルバイナリ（x86_64 + arm64）の生成時
- 公証（Notarization）済みアプリの配布準備時

**主要な処理内容**：
1. アーキテクチャの選択（universal/x86_64/arm64）とバイナリ結合（lipo）
2. アプリケーションバンドル（.app）の構築
3. Info.plistの生成とカスタマイズ
4. ICNSアイコンファイルの生成
5. コード署名（codesign/rcodesign/built-in ad-hoc）
6. エンタイトルメントファイルの生成と適用
7. 公証（Notarization）処理
8. DMG/ZIP/PKGパッケージの作成
9. SSH経由でのリモートデプロイ・実行

**関連システム・外部連携**：
- Xcode codesign/notarytool（macOS環境のみ）
- rcodesign（クロスプラットフォーム署名ツール）
- Apple Developer Portal（公証用API）
- SSH（リモートデプロイ用）

**権限による制御**：App Store配布には有効なApple Developerアカウントと証明書が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 23 | エクスポートダイアログ | 主画面 | macOS向けビルド設定・エクスポート実行 |

## 機能種別

ファイル生成処理 / プラットフォームエクスポート

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| export/distribution_type | Int | Yes | 配布タイプ（Testing/Distribution/App Store） | 0-2 |
| binary_format/architecture | String | Yes | アーキテクチャ | universal/x86_64/arm64 |
| application/bundle_identifier | String | Yes | バンドル識別子 | 有効なパッケージ名形式 |
| application/icon | String | No | アイコンファイルパス | .icns/.png/.webp/.svg |
| codesign/codesign | Int | No | 署名ツール選択 | 0-3 |
| codesign/identity | String | No | 署名ID | codesign使用時 |
| codesign/certificate_file | String | No | 証明書ファイル | rcodesign使用時 |
| codesign/apple_team_id | String | Cond | Apple Team ID | App Store/公証時必須 |
| codesign/provisioning_profile | String | Cond | プロビジョニングプロファイル | App Store時必須 |
| notarization/notarization | Int | No | 公証ツール選択 | 0-2 |
| codesign/entitlements/app_sandbox/enabled | Bool | Cond | サンドボックス有効化 | App Store時必須 |

### 入力データソース

- エクスポートプリセット設定（project.godot）
- エクスポートテンプレートファイル（.app/.zip）
- プロジェクトリソース（アイコン画像等）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| アプリケーションバンドル | .app | macOSアプリケーションバンドル |
| ディスクイメージ | .dmg | 配布用ディスクイメージ（macOSのみ） |
| ZIPアーカイブ | .zip | 配布用圧縮ファイル |
| インストーラパッケージ | .pkg | App Store用パッケージ（macOSのみ） |

### 出力先

- 指定されたエクスポートパス
- 一時ディレクトリ（バンドル構築時）

## 処理フロー

### 処理シーケンス

```
1. エクスポート設定の検証
   └─ 配布タイプ別の必須項目チェック、バンドル識別子の検証
2. テンプレート準備
   └─ カスタムまたは標準テンプレートの解凍
3. アーキテクチャ処理
   └─ universal選択時はlipoでバイナリ結合
4. Info.plist生成
   └─ バンドル情報、最小OSバージョン、エンタイトルメント参照の設定
5. アイコン生成
   └─ ICNS形式でマルチサイズアイコン作成
6. エンタイトルメント生成
   └─ サンドボックス、プライバシー権限などの設定
7. コード署名
   └─ codesign/rcodesign/ad-hocによる署名
8. 公証処理（有効時）
   └─ notarytool/rcodesignによるApple公証
9. パッケージ作成
   └─ DMG/ZIP/PKG形式での出力
```

### フローチャート

```mermaid
flowchart TD
    A[エクスポート開始] --> B{設定検証}
    B -->|失敗| Z[エラー終了]
    B -->|成功| C[テンプレート解凍]
    C --> D{universal?}
    D -->|Yes| E[lipo実行]
    D -->|No| F[単一アーキテクチャ]
    E --> G[Info.plist生成]
    F --> G
    G --> H[アイコン生成]
    H --> I[エンタイトルメント生成]
    I --> J{コード署名?}
    J -->|Yes| K[署名実行]
    J -->|No| L{公証?}
    K --> L
    L -->|Yes| M[公証処理]
    L -->|No| N{出力形式}
    M --> N
    N -->|DMG| O[DMG作成]
    N -->|ZIP| P[ZIP作成]
    N -->|PKG| Q[PKG作成]
    O --> R[エクスポート完了]
    P --> R
    Q --> R
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-52-01 | App Storeサンドボックス必須 | App Store配布時はサンドボックス有効化が必須 | distribution_type=2 |
| BR-52-02 | 公証にはTeam ID必須 | 公証を行うにはApple Team IDの指定が必要 | notarization>0 |
| BR-52-03 | ad-hoc署名では公証不可 | ad-hoc署名されたアプリは公証できない | codesign=1かつnotarization>0 |
| BR-52-04 | rcodesignはGDExtension非対応 | rcodesignは動的ライブラリ埋め込みアプリの署名に非対応 | codesign=2かつGDExtension使用 |
| BR-52-05 | プライバシー説明必須 | 権限エンタイトルメント有効時は使用説明が必須 | 各種entitlement有効時 |

### 計算ロジック

アイコンサイズ生成: 1024, 512, 256, 128, 64, 32, 16ピクセルのICNSを生成（Retinaと非Retina両方を含む）

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR_FILE_NOT_FOUND | ファイル不在 | テンプレートファイルが存在しない | テンプレートのインストール |
| ERR_INVALID_PARAMETER | 無効なパラメータ | バンドル識別子が不正 | 有効な形式で再入力 |
| FAILED | 署名失敗 | codesign実行エラー | 証明書・設定確認 |
| FAILED | 公証失敗 | Apple APIエラー | API認証情報確認 |
| ERR_SKIP | スキップ | DMG作成がmacOS以外で要求 | ZIP形式を使用 |

### リトライ仕様

公証処理は待機・ポーリング方式で完了を確認。タイムアウト時はエラー表示。

## トランザクション仕様

ファイルシステム操作のため、トランザクション管理なし。一時ディレクトリは処理完了後に削除。

## パフォーマンス要件

- ユニバーサルバイナリ作成時: lipo処理により時間増加
- 公証処理: Apple APIの応答時間に依存（数分〜数十分）

## セキュリティ考慮事項

- 証明書パスワードはPROPERTY_USAGE_SECRET指定、環境変数からも取得可能
- Apple ID情報（パスワード、APIキー）は安全に管理が必要
- エンタイトルメントによりアプリの権限を最小限に制限可能

## 備考

- DMG作成はmacOS環境でのみ可能
- PKG作成（App Store用）はmacOS環境でのみ可能
- Liquid Glass Icon（.icon）はmacOS Tahoe以降で使用可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

エクスポートオプションと配布タイプの定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | export_plugin.h | `platform/macos/export/export_plugin.h` | EditorExportPlatformMacOSクラス定義 |

**読解のコツ**: 配布タイプ（Testing=0, Distribution=1, App Store=2）による処理分岐を理解することが重要。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | export_plugin.cpp | `platform/macos/export/export_plugin.cpp` | export_project関数がメインエントリ |

**主要処理フロー**:
1. **465-617行目**: get_export_options関数でエクスポートオプション定義
2. **77-265行目**: get_export_option_warning関数で設定検証
3. **386-411行目**: get_binary_extensions関数で出力形式決定

#### Step 3: アイコン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | export_plugin.cpp | `platform/macos/export/export_plugin.cpp` | _make_icon関数 |

**主要処理フロー**:
- **668-700行目**: ICNS形式のマルチサイズアイコン生成
- **684-695行目**: icon_infos配列で各サイズと形式を定義
- **619-666行目**: PackBits圧縮処理（レガシー形式用）

#### Step 4: コード署名とエンタイトルメントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | export_plugin.cpp | `platform/macos/export/export_plugin.cpp` | _code_sign関数、_create_entitlements_file関数 |

**主要処理フロー**:
- **83-97行目**: 署名ツールの選択ロジック（ad-hoc/rcodesign/codesign）
- **267-384行目**: エクスポートオプションの可視性制御
- **519-543行目**: エンタイトルメント関連オプション

#### Step 5: パッケージ作成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | export_plugin.cpp | `platform/macos/export/export_plugin.cpp` | DMG/ZIP/PKG作成処理 |

**主要処理フロー**:
- **391-411行目**: 配布タイプによる出力形式の決定
- DMG: hdiutilコマンド使用（macOSのみ）
- PKG: productbuildコマンド使用（macOSのみ、App Store）

### プログラム呼び出し階層図

```
EditorExportPlatformMacOS::export_project
    │
    ├─ _export_project_files (PCK生成)
    │
    ├─ _export_macos_bundle
    │      ├─ テンプレート解凍
    │      ├─ lipo (universal時)
    │      ├─ _make_icon (ICNS生成)
    │      └─ Info.plist生成
    │
    ├─ _create_entitlements_file
    │      └─ エンタイトルメント生成
    │
    ├─ _code_sign
    │      ├─ codesign (Xcode)
    │      ├─ rcodesign
    │      └─ built-in ad-hoc
    │
    ├─ _notarize
    │      ├─ notarytool (Xcode)
    │      └─ rcodesign
    │
    └─ パッケージ作成
           ├─ hdiutil (DMG)
           ├─ zip (ZIP)
           └─ productbuild (PKG)
```

### データフロー図

```
[入力]                        [処理]                         [出力]

プロジェクトファイル ────────▶ _export_project_files ──────▶ PCKファイル

テンプレート(.zip) ─────────▶ テンプレート解凍 ────────────▶ .appバンドル
  ├─ x86_64
  └─ arm64                   lipo (結合)

アイコン画像 ───────────────▶ _make_icon ─────────────────▶ icon.icns
(.png/.icns)

エクスポート設定 ───────────▶ Info.plist生成 ─────────────▶ Info.plist
                             エンタイトルメント生成 ──────▶ .entitlements

証明書/APIキー ─────────────▶ _code_sign ─────────────────▶ 署名済み.app
                             _notarize ──────────────────▶ 公証済み.app

署名済み.app ───────────────▶ パッケージ作成 ─────────────▶ .dmg/.zip/.pkg
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| export_plugin.cpp | `platform/macos/export/export_plugin.cpp` | ソース | macOSエクスポートプラグイン本体 |
| export_plugin.h | `platform/macos/export/export_plugin.h` | ヘッダ | クラス定義 |
| export.cpp | `platform/macos/export/export.cpp` | ソース | プラグイン登録 |
| codesign.cpp | `editor/export/codesign.cpp` | ソース | 内蔵コード署名処理 |
| lipo.cpp | `editor/export/lipo.cpp` | ソース | Mach-Oバイナリ結合 |
| macho.cpp | `editor/export/macho.cpp` | ソース | Mach-Oファイル操作 |
| plist.cpp | `core/io/plist.cpp` | ソース | plist読み書き |
| os_macos.mm | `platform/macos/os_macos.mm` | ソース | macOS OS抽象化 |
| display_server_macos.mm | `platform/macos/display_server_macos.mm` | ソース | ウィンドウ管理 |
