# 機能設計書 53-Linux対応

## 概要

本ドキュメントは、Godot EngineにおけるLinux/BSD向けビルド・エクスポート機能の設計を記載するものである。

### 本機能の処理概要

**業務上の目的・背景**：Linuxは、オープンソースゲームプラットフォームおよびSteamOS（Steam Deck）の基盤として重要な市場を持つ。複数のCPUアーキテクチャ（x86_64, x86_32, arm64, arm32, rv64, ppc64, loongarch64）をサポートし、様々なLinuxディストリビューションで動作する実行ファイルを生成する。

**機能の利用シーン**：
- Linux向けゲームのリリースビルド作成時
- Steam Deck（SteamOS）向けビルド作成時
- 開発中のLinuxマシンでのテスト実行時
- 組み込みLinuxデバイス向けビルド時

**主要な処理内容**：
1. アーキテクチャ（x86_64/x86_32/arm64/arm32/rv64/ppc64/loongarch64）の選択
2. ELF形式実行ファイルの生成
3. PCKファイルの生成と埋め込み
4. コンソールラッパースクリプト（.sh）の生成
5. AccessKitライブラリのコピー
6. ZIP形式でのパッケージ作成
7. SSH経由でのリモートデプロイ・実行

**関連システム・外部連携**：
- SSH（リモートデプロイ用）
- Steam Runtime（Steam配布時）

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 23 | エクスポートダイアログ | 主画面 | Linux向けビルド設定・エクスポート実行 |

## 機能種別

ファイル生成処理 / プラットフォームエクスポート

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| binary_format/architecture | String | Yes | 出力アーキテクチャ | x86_64/x86_32/arm64/arm32/rv64/ppc64/loongarch64 |
| custom_template/debug | String | No | カスタムデバッグテンプレートパス | ファイル存在・アーキテクチャ整合性 |
| custom_template/release | String | No | カスタムリリーステンプレートパス | ファイル存在・アーキテクチャ整合性 |
| debug/export_console_wrapper | Int | No | コンソールラッパー生成 | 0=No/1=Debug Only/2=Always |
| ssh_remote_deploy/enabled | Bool | No | SSHリモートデプロイ有効化 | - |
| ssh_remote_deploy/host | String | No | SSHホスト | user@host_ip形式 |
| ssh_remote_deploy/port | String | No | SSHポート | デフォルト22 |

### 入力データソース

- エクスポートプリセット設定（project.godot）
- エクスポートテンプレートファイル（ELF形式）
- プロジェクトリソース

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 実行ファイル | .{arch} | Linux ELF実行ファイル（拡張子はアーキテクチャ名） |
| コンソールラッパー | .sh | シェルスクリプトラッパー |
| PCKファイル | .pck | ゲームデータパッケージ（非埋め込み時） |
| AccessKitライブラリ | .so | アクセシビリティライブラリ |
| ZIPアーカイブ | .zip | 配布用ZIPパッケージ |

### 出力先

- 指定されたエクスポートパス
- 一時ディレクトリ（ZIP出力時）

## 処理フロー

### 処理シーケンス

```
1. エクスポート設定の検証
   └─ テンプレートのアーキテクチャ整合性チェック
2. テンプレートファイルの選択
   └─ カスタムまたは標準テンプレートの決定
3. 出力形式の決定
   └─ 直接出力またはZIP形式
4. AccessKitライブラリのコピー
   └─ libaccesskit.{arch}.soの配置
5. EditorExportPlatformPC::export_project
   └─ PCK生成、テンプレートコピー、リソース埋め込み
6. コンソールラッパー生成
   └─ .shスクリプト作成、実行権限設定
7. ZIP作成（ZIP出力時）
   └─ ファイルのアーカイブ化、一時フォルダ削除
```

### フローチャート

```mermaid
flowchart TD
    A[エクスポート開始] --> B{設定検証}
    B -->|失敗| Z[エラー終了]
    B -->|成功| C{出力形式}
    C -->|ZIP| D[一時フォルダ作成]
    C -->|直接| E[AccessKitコピー]
    D --> E
    E --> F[EditorExportPlatformPC::export_project]
    F --> G{コンソールラッパー?}
    G -->|Yes| H[.shスクリプト生成]
    G -->|No| I{ZIP出力?}
    H --> I
    I -->|Yes| J[ZIP作成・一時フォルダ削除]
    I -->|No| K[エクスポート完了]
    J --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-53-01 | アーキテクチャ整合性 | カスタムテンプレートのアーキテクチャはELFヘッダで検証 | カスタムテンプレート使用時 |
| BR-53-02 | ELFマジックナンバー | 実行ファイルは0x7F + "ELF"で始まる必要がある | テンプレート検証時 |
| BR-53-03 | 実行権限設定 | 生成された実行ファイルとスクリプトには実行権限を設定 | 全エクスポート |

### 計算ロジック

ELFアーキテクチャ判定: e_machine値によりアーキテクチャを特定
- 0x0003: x86_32
- 0x003e: x86_64
- 0x0015: ppc64
- 0x0028: arm32
- 0x00b7: arm64
- 0x00f3: rv64
- 0x0102: loongarch64

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR_FILE_NOT_FOUND | ファイル不在 | テンプレートファイルが存在しない | テンプレートのインストール |
| ERR_CANT_CREATE | 作成失敗 | 出力ディレクトリ作成不可 | 権限確認 |
| ERR_INVALID_DATA | データ不正 | ELFマジックナンバー不一致 | テンプレート再取得 |

### リトライ仕様

自動リトライなし。

## トランザクション仕様

ファイルシステム操作のため、トランザクション管理なし。ZIP出力時は一時フォルダを使用し、完了後に削除。

## パフォーマンス要件

- PCK生成時間: プロジェクトサイズに依存
- ZIP圧縮: ファイルサイズに依存

## セキュリティ考慮事項

- 生成された実行ファイルには適切な実行権限（0755）が設定される
- SSH認証情報の安全な管理が必要

## 備考

- 出力ファイルの拡張子はアーキテクチャ名（.x86_64, .arm64等）
- ZIPと直接出力の両方をサポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | export_plugin.cpp | `platform/linuxbsd/export/export_plugin.cpp` | export_project関数がメインエントリ |

**主要処理フロー**:
- **61-151行目**: export_project関数全体
- **62-74行目**: カスタムテンプレートのアーキテクチャ検証
- **76-79行目**: AccessKitライブラリのコピー
- **112行目**: EditorExportPlatformPC::export_project呼び出し
- **119-127行目**: コンソールラッパースクリプト生成
- **130-148行目**: ZIP作成処理

#### Step 2: アーキテクチャ判定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | export_plugin.cpp | `platform/linuxbsd/export/export_plugin.cpp` | _get_exe_arch関数 |

**主要処理フロー**:
- **255-293行目**: ELFヘッダからアーキテクチャを判定
- **262-267行目**: ELFマジックナンバー検証
- **275-292行目**: e_machine値によるアーキテクチャ特定

#### Step 3: コンソールラッパー生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | export_plugin.cpp | `platform/linuxbsd/export/export_plugin.cpp` | _export_debug_script関数 |

**主要処理フロー**:
- **46-59行目**: シェルスクリプト生成
- **53-56行目**: スクリプト内容（端末タイトル設定、実行パス解決）

### プログラム呼び出し階層図

```
EditorExportPlatformLinuxBSD::export_project
    │
    ├─ _get_exe_arch (アーキテクチャ検証)
    │
    ├─ DirAccess::copy (AccessKitコピー)
    │
    ├─ EditorExportPlatformPC::export_project (親クラス)
    │      └─ EditorExportPlatform::export_project_files
    │             └─ PCK生成処理
    │
    ├─ _export_debug_script (コンソールラッパー)
    │
    └─ zip_folder_recursive (ZIP作成)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

プロジェクトファイル ──────▶ export_project_files ──────────▶ PCKファイル

テンプレート(ELF) ─────────▶ テンプレートコピー ────────────▶ 実行ファイル(.x86_64等)
                             fixup_embedded_pck

設定パラメータ ────────────▶ _export_debug_script ──────────▶ コンソールラッパー(.sh)

AccessKitライブラリ ───────▶ DirAccess::copy ──────────────▶ libaccesskit.{arch}.so

全出力ファイル ────────────▶ zip_folder_recursive ──────────▶ ZIPアーカイブ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| export_plugin.cpp | `platform/linuxbsd/export/export_plugin.cpp` | ソース | Linuxエクスポートプラグイン本体 |
| export_plugin.h | `platform/linuxbsd/export/export_plugin.h` | ヘッダ | クラス定義 |
| export.cpp | `platform/linuxbsd/export/export.cpp` | ソース | プラグイン登録 |
| os_linuxbsd.cpp | `platform/linuxbsd/os_linuxbsd.cpp` | ソース | Linux OS抽象化 |
| display_server_x11.cpp | `platform/linuxbsd/x11/display_server_x11.cpp` | ソース | X11ディスプレイサーバー |
