# 機能設計書 54-Android対応

## 概要

本ドキュメントは、Godot EngineにおけるAndroidプラットフォーム向けビルド・エクスポート機能の設計を記載するものである。

### 本機能の処理概要

**業務上の目的・背景**：Androidはモバイルゲーム市場で最大のシェアを持つプラットフォームである。Google Playストアへの配布、APK/AAB形式でのパッケージング、マルチアーキテクチャ対応（arm64-v8a, armeabi-v7a, x86_64, x86）、アダプティブアイコン対応など、Android固有の要件を満たすエクスポート機能を提供する。

**機能の利用シーン**：
- Google Play Store配布用AABの生成時
- サイドローディング用APKの生成時
- 開発中のAndroidデバイスでのテスト実行時
- Oculus Quest等のVRデバイス向けビルド時

**主要な処理内容**：
1. エクスポート形式の選択（APK/AAB）
2. Gradleビルドシステムとの連携
3. AndroidManifest.xmlの生成とカスタマイズ
4. アダプティブアイコン（Foreground/Background/Monochrome）の生成
5. APK署名（デバッグ/リリースキー）
6. GDExtensionネイティブライブラリの統合
7. ADB経由でのデバイスデプロイ・実行
8. パーミッション設定

**関連システム・外部連携**：
- Android SDK（ビルドツール、ADB）
- Gradle（ビルドシステム）
- Java/JDK
- Google Play Console（AAB配布時）

**権限による制御**：各種Androidパーミッションの設定により、カメラ、マイク、位置情報等へのアクセスを制御。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 23 | エクスポートダイアログ | 主画面 | Android向けビルド設定・エクスポート実行 |

## 機能種別

ファイル生成処理 / プラットフォームエクスポート

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| gradle_build/use_gradle_build | Bool | Yes | Gradleビルド使用 | - |
| gradle_build/export_format | Int | Yes | 出力形式 | 0=APK/1=AAB |
| gradle_build/min_sdk | Int | No | 最小SDKバージョン | デフォルト24 |
| gradle_build/target_sdk | Int | No | ターゲットSDKバージョン | デフォルト35 |
| package/unique_name | String | Yes | パッケージ名 | 有効なJavaパッケージ名形式 |
| version/code | Int | Yes | バージョンコード | 正の整数 |
| version/name | String | Yes | バージョン名 | - |
| launcher_icons/main_192x192 | String | No | メインアイコンパス | .png/.webp/.svg |
| launcher_icons/adaptive_foreground_432x432 | String | No | アダプティブアイコン前景 | - |
| launcher_icons/adaptive_background_432x432 | String | No | アダプティブアイコン背景 | - |
| keystore/debug | String | No | デバッグキーストアパス | - |
| keystore/release | String | No | リリースキーストアパス | - |

### 入力データソース

- エクスポートプリセット設定（project.godot）
- Androidビルドテンプレート
- プロジェクトリソース（アイコン画像等）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| APKファイル | .apk | Android Package（サイドローディング用） |
| AABファイル | .aab | Android App Bundle（Play Store用） |

### 出力先

- 指定されたエクスポートパス

## 処理フロー

### 処理シーケンス

```
1. エクスポート設定の検証
   └─ SDK/JDK存在確認、キーストア検証、パーミッション整合性
2. Androidビルドテンプレートの準備
   └─ テンプレート解凍、バージョン整合性確認
3. プロジェクトファイルのエクスポート
   └─ res://をAndroidアセットディレクトリにコピー
4. アイコン処理
   └─ 各密度向けアイコン生成（mdpi〜xxxhdpi）
5. AndroidManifest.xml生成
   └─ パーミッション、機能要件、メタデータ設定
6. GDExtensionライブラリ処理
   └─ ネイティブライブラリをjniLibsにコピー
7. Gradleビルド実行
   └─ APKまたはAABの生成
8. 署名処理
   └─ デバッグ/リリースキーストアによる署名
```

### フローチャート

```mermaid
flowchart TD
    A[エクスポート開始] --> B{設定検証}
    B -->|失敗| Z[エラー終了]
    B -->|成功| C[テンプレート準備]
    C --> D[プロジェクトファイルコピー]
    D --> E[アイコン処理]
    E --> F[AndroidManifest.xml生成]
    F --> G[GDExtensionライブラリコピー]
    G --> H{出力形式}
    H -->|APK| I[Gradle assembleDebug/Release]
    H -->|AAB| J[Gradle bundleDebug/Release]
    I --> K[署名処理]
    J --> K
    K --> L[エクスポート完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-54-01 | パッケージ名形式 | com.example.appの形式（Java識別子ルール） | 全エクスポート |
| BR-54-02 | バージョンコード増加 | Play Store更新時はバージョンコードを増加させる必要あり | AABアップロード時 |
| BR-54-03 | 最小SDK制限 | Godot 4.xはminSdk 24以上が必要 | 全エクスポート |
| BR-54-04 | AAB必須（Play Store） | 新規アプリはAAB形式が必須 | Play Store配布時 |

### 計算ロジック

アイコンサイズ生成:
- xxxhdpi: 192px (main), 432px (adaptive)
- xxhdpi: 144px (main), 324px (adaptive)
- xhdpi: 96px (main), 216px (adaptive)
- hdpi: 72px (main), 162px (adaptive)
- mdpi: 48px (main), 108px (adaptive)

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR_FILE_NOT_FOUND | ファイル不在 | Android SDKが見つからない | SDK設定確認 |
| ERR_UNCONFIGURED | 未設定 | キーストアパスワード未設定 | パスワード入力 |
| FAILED | ビルド失敗 | Gradleビルドエラー | ビルドログ確認 |
| ERR_INVALID_DATA | データ不正 | テンプレートバージョン不一致 | テンプレート再インストール |

### リトライ仕様

Gradleビルド失敗時は自動リトライなし。

## トランザクション仕様

ファイルシステム操作のため、トランザクション管理なし。

## パフォーマンス要件

- Gradleビルド時間: プロジェクトサイズとマシン性能に依存
- 初回ビルドはGradleキャッシュ構築のため時間がかかる

## セキュリティ考慮事項

- キーストアパスワードはPROPERTY_USAGE_SECRET指定
- リリースキーストアは安全に管理が必要
- デバッグキーストアは自動生成可能

## 備考

- C#/.NETプロジェクトではAndroidエディタ内ビルドは非サポート
- ADBによるリモートデバッグはeditor_settingsで設定

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | export_plugin.h | `platform/android/export/export_plugin.h` | EditorExportPlatformAndroidクラス定義 |

**読解のコツ**: ANDROID_PERMS配列で定義されたパーミッション一覧を確認すると、対応する権限の範囲が分かる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | export_plugin.cpp | `platform/android/export/export_plugin.cpp` | export_project関数 |

**主要処理フロー**:
- **68-223行目**: パーミッション定数定義
- **247-254行目**: ランチャーアイコン定義
- **283-291行目**: デフォルトSDKバージョン
- **293-479行目**: デバイス検出スレッド

#### Step 3: アイコン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | export_plugin.cpp | `platform/android/export/export_plugin.cpp` | アイコン生成処理 |

**主要処理フロー**:
- **247-281行目**: ランチャーアイコンとアダプティブアイコンの定義
- アダプティブアイコンはForeground/Background/Monochromeの3層構造

### プログラム呼び出し階層図

```
EditorExportPlatformAndroid::export_project
    │
    ├─ _check_for_changes_poll_thread
    │      └─ ADBデバイス検出
    │
    ├─ _export_project_files
    │      └─ アセットコピー
    │
    ├─ _create_launcher_icons
    │      └─ 各密度向けアイコン生成
    │
    ├─ _write_manifest
    │      └─ AndroidManifest.xml生成
    │
    └─ Gradleビルド
           └─ APK/AAB生成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| export_plugin.cpp | `platform/android/export/export_plugin.cpp` | ソース | Androidエクスポートプラグイン本体 |
| export_plugin.h | `platform/android/export/export_plugin.h` | ヘッダ | クラス定義 |
| java_godot_wrapper.cpp | `platform/android/java_godot_wrapper.cpp` | ソース | JNIラッパー |
| os_android.cpp | `platform/android/os_android.cpp` | ソース | Android OS抽象化 |
| display_server_android.cpp | `platform/android/display_server_android.cpp` | ソース | ディスプレイ管理 |
