# 機能設計書 55-iOS対応

## 概要

本ドキュメントは、Godot EngineにおけるiOSプラットフォーム向けビルド・エクスポート機能の設計を記載するものである。

### 本機能の処理概要

**業務上の目的・背景**：iOSはモバイルゲーム市場で高い収益性を持つプラットフォームである。App Store配布のためのコード署名、プロビジョニングプロファイル、エンタイトルメント対応、iPhone/iPad両対応のユニバーサルアプリ生成など、iOS固有の要件を満たすエクスポート機能を提供する。

**機能の利用シーン**：
- App Store配布用IPAの生成時
- TestFlight配布用ビルドの作成時
- 開発用デバイスでのテスト実行時
- Ad Hoc配布用ビルドの作成時

**主要な処理内容**：
1. Xcodeプロジェクト（.xcodeproj）の生成
2. Info.plistの生成とカスタマイズ
3. アプリアイコン（App Icon Asset Catalog）の生成
4. Launch Screen Storyboardの生成
5. コード署名（Xcode codesign/rcodesign）
6. エンタイトルメントファイルの生成と適用
7. デバイスファミリー（iPhone/iPad）の設定
8. MoltenVKフレームワークの統合

**関連システム・外部連携**：
- Xcode（macOS環境のみ）
- rcodesign（クロスプラットフォーム署名ツール）
- Apple Developer Portal
- TestFlight

**権限による制御**：有効なApple Developerアカウントとプロビジョニングプロファイルが必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 23 | エクスポートダイアログ | 主画面 | iOS向けビルド設定・エクスポート実行 |

## 機能種別

ファイル生成処理 / プラットフォームエクスポート

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| application/targeted_device_family | Int | Yes | 対象デバイス | 0=iPhone/1=iPad/2=Both |
| application/bundle_identifier | String | Yes | バンドル識別子 | 有効なパッケージ名形式 |
| application/min_ios_version | String | Yes | 最小iOSバージョン | - |
| storyboard/image_scale_mode | Int | No | スプラッシュ画像スケールモード | 0-4 |
| storyboard/custom_image@2x | String | No | カスタムスプラッシュ@2x | .png/.jpg |
| storyboard/custom_image@3x | String | No | カスタムスプラッシュ@3x | .png/.jpg |
| codesign/identity | String | Cond | 署名ID | codesign使用時 |
| codesign/provisioning_profile | String | Cond | プロビジョニングプロファイル | 配布時必須 |

### 入力データソース

- エクスポートプリセット設定（project.godot）
- iOSエクスポートテンプレート
- プロジェクトリソース（アイコン画像等）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Xcodeプロジェクト | .xcodeproj | Xcodeプロジェクトファイル |
| アプリアーカイブ | .ipa | iOS App Archive（配布用） |
| ZIPアーカイブ | .zip | プロジェクト一式 |

### 出力先

- 指定されたエクスポートパス

## 処理フロー

### 処理シーケンス

```
1. エクスポート設定の検証
   └─ テンプレート存在確認、署名設定検証
2. Xcodeプロジェクトテンプレートの解凍
3. プロジェクトファイルのエクスポート
   └─ res://をプロジェクトディレクトリにコピー
4. アイコン処理
   └─ App Icon Asset Catalog生成（各サイズ・解像度）
5. Info.plist生成
   └─ バンドル情報、デバイスファミリー、最小OS設定
6. Launch Screen Storyboard生成
   └─ スプラッシュ画像配置
7. エンタイトルメント生成
   └─ 権限設定
8. Xcodeプロジェクト設定ファイル更新
   └─ pbxproj編集
9. コード署名（macOS環境時）
```

### フローチャート

```mermaid
flowchart TD
    A[エクスポート開始] --> B{設定検証}
    B -->|失敗| Z[エラー終了]
    B -->|成功| C[テンプレート解凍]
    C --> D[プロジェクトファイルコピー]
    D --> E[アイコン処理]
    E --> F[Info.plist生成]
    F --> G[Launch Screen生成]
    G --> H[エンタイトルメント生成]
    H --> I[pbxproj更新]
    I --> J{macOS環境?}
    J -->|Yes| K[コード署名]
    J -->|No| L[ZIP出力]
    K --> L
    L --> M[エクスポート完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-55-01 | Metal必須バージョン | Metal rendererはiOS 14+が必要 | Metal使用時 |
| BR-55-02 | App Store不透明アイコン | App Store用アイコンは不透明である必要がある | 1024x1024アイコン |
| BR-55-03 | Retina対応 | @2x、@3xの両方のスプラッシュ画像が必要 | カスタムスプラッシュ時 |

### 計算ロジック

アイコンサイズ生成:
- Settings: 58x58(@2x), 87x87(@3x)
- Notifications: 40x40(@2x), 60x60(@3x), 76x76(@2x), 114x114(@3x)
- Spotlight: 80x80(@2x), 120x120(@3x)
- iPhone Home: 120x120(@2x), 180x180(@3x)
- iPad Home: 152x152(@2x), 167x167(@2x)
- App Store: 1024x1024(@1x)

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR_FILE_NOT_FOUND | ファイル不在 | テンプレートファイルが存在しない | テンプレートのインストール |
| ERR_UNCONFIGURED | 未設定 | アイコン未設定 | アイコン画像を指定 |
| ERR_CANT_CREATE | 作成失敗 | アイコンセットディレクトリ作成不可 | 権限確認 |
| ERR_FILE_CANT_WRITE | 書き込み失敗 | スプラッシュ画像保存失敗 | ディスク容量確認 |

### リトライ仕様

自動リトライなし。

## トランザクション仕様

ファイルシステム操作のため、トランザクション管理なし。

## パフォーマンス要件

- アイコン生成: 各サイズへのリサイズ処理
- Xcodeビルドは別途Xcodeで実行が必要

## セキュリティ考慮事項

- 証明書パスワードは安全に管理が必要
- プロビジョニングプロファイルは適切なデバイス・アプリに限定

## 備考

- 完全なIPAビルドはmacOS + Xcodeが必要
- 非macOS環境ではZIP形式でXcodeプロジェクトを出力し、macOSでビルド

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | export_plugin.h | `platform/ios/export/export_plugin.h` | EditorExportPlatformIOSクラス定義 |

**読解のコツ**: EditorExportPlatformAppleEmbeddedを継承しており、macOSとの共通処理は親クラスにある。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | export_plugin.cpp | `platform/ios/export/export_plugin.cpp` | get_export_options、_export_icons関数 |

**主要処理フロー**:
- **40-47行目**: initialize関数でロゴ設定
- **55-66行目**: get_export_options関数でiOS固有オプション
- **68-90行目**: has_valid_export_configuration関数でMetal/iOSバージョン検証
- **196-231行目**: get_icon_infos関数でアイコンサイズ定義
- **233-387行目**: _export_icons関数でアイコン生成

#### Step 3: アイコン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | export_plugin.cpp | `platform/ios/export/export_plugin.cpp` | get_icon_infos、_export_icons関数 |

**主要処理フロー**:
- **196-231行目**: IconInfo配列で各サイズ・解像度を定義
- **252-365行目**: 通常/ダーク/色付きアイコンの3モード対応
- **366-387行目**: Contents.jsonの生成

#### Step 4: スプラッシュ画面処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | export_plugin.cpp | `platform/ios/export/export_plugin.cpp` | _export_loading_screen_file関数 |

**主要処理フロー**:
- **136-194行目**: カスタムまたはデフォルトスプラッシュの処理
- **140-163行目**: カスタム画像の@2x/@3x処理

### プログラム呼び出し階層図

```
EditorExportPlatformIOS
    │
    ├─ EditorExportPlatformAppleEmbedded (親クラス)
    │
    ├─ get_export_options
    │      └─ iOS固有オプション追加
    │
    ├─ _export_icons
    │      └─ App Icon Asset Catalog生成
    │
    ├─ _export_loading_screen_file
    │      └─ Launch Screen画像生成
    │
    └─ _process_config_file_line
           └─ pbxproj変数置換
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| export_plugin.cpp | `platform/ios/export/export_plugin.cpp` | ソース | iOSエクスポートプラグイン本体 |
| export_plugin.h | `platform/ios/export/export_plugin.h` | ヘッダ | クラス定義 |
| export.cpp | `platform/ios/export/export.cpp` | ソース | プラグイン登録 |
| godot_app_delegate.mm | `platform/ios/godot_app_delegate.mm` | ソース | アプリデリゲート |
| os_ios.mm | `platform/ios/os_ios.mm` | ソース | iOS OS抽象化 |
| display_server_ios.mm | `platform/ios/display_server_ios.mm` | ソース | ディスプレイ管理 |
