# 機能設計書 56-Web（HTML5）対応

## 概要

本ドキュメントは、Godot EngineにおけるWebプラットフォーム（HTML5/WebAssembly）向けビルド・エクスポート機能の設計を記載するものである。

### 本機能の処理概要

**業務上の目的・背景**：Webプラットフォームは、インストール不要でブラウザから直接ゲームをプレイできるため、itch.io、Newgrounds等のWebゲームプラットフォームや、自社サイトでの配信に適している。WebAssembly（Wasm）によるネイティブ近いパフォーマンス、Progressive Web App（PWA）対応、スレッドサポートなど、モダンWebゲームの要件を満たすエクスポート機能を提供する。

**機能の利用シーン**：
- WebゲームポータルへのHTML5ゲーム配信時
- 自社サイトへのゲーム埋め込み時
- PWA形式でのオフライン対応ゲーム配信時
- ブラウザベースのゲームデモ公開時

**主要な処理内容**：
1. WebAssembly（.wasm）バイナリの生成
2. HTMLシェルファイルのカスタマイズ
3. JavaScript（.js）エンジンファイルの生成
4. PCKファイルの生成
5. PWA対応（Service Worker、Manifest）
6. アイコン・スプラッシュ画像の処理
7. スレッドサポート（COEP/COOP対応）

**関連システム・外部連携**：
- Emscripten（ビルドツールチェーン）
- Webブラウザ（実行環境）
- Webサーバー（配信）

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 23 | エクスポートダイアログ | 主画面 | Web向けビルド設定・エクスポート実行 |

## 機能種別

ファイル生成処理 / プラットフォームエクスポート

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| variant/extensions_support | Bool | No | GDExtensionサポート | - |
| variant/thread_support | Bool | No | スレッドサポート | - |
| vram_texture_compression/for_desktop | Bool | No | デスクトップ向けテクスチャ圧縮（S3TC/BPTC） | - |
| vram_texture_compression/for_mobile | Bool | No | モバイル向けテクスチャ圧縮（ETC2/ASTC） | - |
| html/export_icon | Bool | No | アイコンエクスポート | - |
| html/custom_html_shell | String | No | カスタムHTMLシェル | .html |
| html/head_include | String | No | HTMLヘッド追加コンテンツ | - |
| html/canvas_resize_policy | Int | No | キャンバスリサイズポリシー | 0-2 |
| html/focus_canvas_on_start | Bool | No | 開始時キャンバスフォーカス | - |
| progressive_web_app/enabled | Bool | No | PWA有効化 | - |
| progressive_web_app/display | Int | No | PWA表示モード | 0-3 |
| progressive_web_app/orientation | Int | No | PWA画面向き | 0-2 |

### 入力データソース

- エクスポートプリセット設定（project.godot）
- Webエクスポートテンプレート（.zip）
- プロジェクトリソース

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| HTMLファイル | .html | メインHTMLファイル |
| JavaScriptファイル | .js | エンジンJavaScript |
| WebAssemblyファイル | .wasm | Wasmバイナリ |
| PCKファイル | .pck | ゲームデータパッケージ |
| Service Worker | .service.worker.js | PWA用サービスワーカー |
| Manifest | .manifest.json | PWAマニフェスト |
| オフラインページ | .offline.html | オフライン時表示ページ |
| Audio Worklet | .audio.worklet.js | オーディオ処理用Worklet |

### 出力先

- 指定されたエクスポートパス

## 処理フロー

### 処理シーケンス

```
1. エクスポート設定の検証
   └─ テンプレート存在確認、テクスチャ圧縮設定確認
2. テンプレートファイルの解凍
   └─ ZIPからファイル抽出
3. プロジェクトファイルのエクスポート
   └─ PCK生成
4. HTMLファイル処理
   └─ テンプレート変数置換、カスタマイズ適用
5. アイコン処理（有効時）
   └─ favicon.ico、apple-touch-icon生成
6. PWA処理（有効時）
   └─ Service Worker、Manifestファイル生成
```

### フローチャート

```mermaid
flowchart TD
    A[エクスポート開始] --> B{設定検証}
    B -->|失敗| Z[エラー終了]
    B -->|成功| C[テンプレート解凍]
    C --> D[PCK生成]
    D --> E[HTML処理]
    E --> F{アイコン出力?}
    F -->|Yes| G[アイコン生成]
    F -->|No| H{PWA有効?}
    G --> H
    H -->|Yes| I[Service Worker生成]
    H -->|No| J[エクスポート完了]
    I --> K[Manifest生成]
    K --> J
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-56-01 | C#/.NET非対応 | Godot 4でのWeb+C#は非サポート | .NET使用時 |
| BR-56-02 | スレッドサポートとCOI | スレッド使用時はCOEP/COOPヘッダが必要 | thread_support有効時 |
| BR-56-03 | PWAアイコンサイズ | PWAアイコンは144x144、180x180、512x512の3サイズ | PWA有効時 |

### 計算ロジック

PWAアイコンサイズ: 144x144, 180x180, 512x512ピクセル

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR_FILE_NOT_FOUND | ファイル不在 | テンプレートファイルが存在しない | テンプレートのインストール |
| ERR_FILE_CORRUPT | 破損 | テンプレートZIPが不正 | テンプレート再取得 |
| ERR_FILE_CANT_WRITE | 書き込み失敗 | 出力ディレクトリ書き込み不可 | 権限確認 |

### リトライ仕様

自動リトライなし。

## トランザクション仕様

ファイルシステム操作のため、トランザクション管理なし。

## パフォーマンス要件

- Wasm生成はEmscriptenビルドに依存
- 出力サイズはプロジェクト規模に比例

## セキュリティ考慮事項

- Cross-Origin Isolation: スレッドサポート時はCOEP/COOPヘッダが必要
- Service Workerは同一オリジンポリシーに従う

## 備考

- C#/.NETプロジェクトはGodot 4でWebエクスポート非対応
- スレッドサポートはブラウザの対応状況に依存

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | export_plugin.cpp | `platform/web/export/export_plugin.cpp` | export_project関数 |

**主要処理フロー**:
- **48-102行目**: _extract_template関数でテンプレート解凍
- **132-191行目**: _fix_html関数でHTML変数置換
- **345-364行目**: get_preset_features関数でfeature設定
- **367-407行目**: get_export_options関数でオプション定義
- **487-500行目**: export_project関数エントリ

#### Step 2: HTML処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | export_plugin.cpp | `platform/web/export/export_plugin.cpp` | _fix_html関数 |

**主要処理フロー**:
- **132-191行目**: HTML文字列置換処理
- **134-155行目**: Engine.js config構築
- **156-164行目**: PWA関連ヘッド要素追加
- **167-191行目**: テンプレート変数置換

#### Step 3: PWA処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | export_plugin.cpp | `platform/web/export/export_plugin.cpp` | _build_pwa関数 |

**主要処理フロー**:
- **226-343行目**: _build_pwa関数全体
- **232-269行目**: Service Worker生成
- **301-340行目**: Manifest生成
- **193-224行目**: _add_manifest_icon関数でアイコン追加

### プログラム呼び出し階層図

```
EditorExportPlatformWeb::export_project
    │
    ├─ _extract_template
    │      └─ テンプレートZIP解凍
    │
    ├─ export_project_files
    │      └─ PCK生成
    │
    ├─ _fix_html
    │      ├─ Engine.js config生成
    │      └─ HTML変数置換
    │
    ├─ _add_manifest_icon
    │      └─ PWAアイコン生成
    │
    └─ _build_pwa
           ├─ Service Worker生成
           └─ Manifest生成
```

### データフロー図

```
[入力]                      [処理]                           [出力]

テンプレートZIP ───────────▶ _extract_template ─────────────▶ 各種ファイル
                                                              (.js, .wasm, .html)

プロジェクトファイル ──────▶ export_project_files ──────────▶ .pck

設定パラメータ ────────────▶ _fix_html ─────────────────────▶ カスタマイズ済み.html

アイコン画像 ──────────────▶ _add_manifest_icon ────────────▶ PWAアイコン

PWA設定 ───────────────────▶ _build_pwa ────────────────────▶ .service.worker.js
                                                              .manifest.json
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| export_plugin.cpp | `platform/web/export/export_plugin.cpp` | ソース | Webエクスポートプラグイン本体 |
| export_plugin.h | `platform/web/export/export_plugin.h` | ヘッダ | クラス定義 |
| export.cpp | `platform/web/export/export.cpp` | ソース | プラグイン登録 |
| os_web.cpp | `platform/web/os_web.cpp` | ソース | Web OS抽象化 |
| display_server_web.cpp | `platform/web/display_server_web.cpp` | ソース | ディスプレイ管理 |
| audio_driver_web.cpp | `platform/web/audio_driver_web.cpp` | ソース | オーディオドライバ |
