# 機能設計書 58-タイルセット

## 概要

本ドキュメントは、Godot EngineにおけるTileSetリソースの設計を記載するものである。

### 本機能の処理概要

**業務上の目的・背景**：TileSetは、タイルマップで使用するタイルの定義を保持するリソースである。各タイルの画像、物理形状、ナビゲーション領域、オクルージョン、アニメーション、テレイン（自動タイル接続）などのデータを一元管理し、TileMapLayerから参照される。

**機能の利用シーン**：
- タイルマップエディタでのタイル定義作成
- 複数のTileMapLayer間でのタイルセット共有
- プロシージャル生成でのタイル配置
- テレインを使用した自動タイル接続

**主要な処理内容**：
1. タイル形状（正方形/アイソメトリック/半オフセット正方形/六角形）の定義
2. タイルソース（TileSetAtlasSource/TileSetScenesCollectionSource）の管理
3. 物理レイヤー、ナビゲーションレイヤー、カスタムデータレイヤーの定義
4. テレイン（地形）とテレインセットの管理
5. タイルパターンの保存と適用
6. 座標変換（マップ座標⇔ローカル座標）

**関連システム・外部連携**：
- TileMapLayer（タイル配置）
- TileSetAtlasSource（アトラステクスチャからのタイル定義）
- TileSetScenesCollectionSource（シーンタイル）

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | TileSetエディタ | エディタ | タイルセットの定義・編集 |

## 機能種別

リソース / データ定義

## 入力仕様

### プロパティ

| プロパティ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| tile_shape | TileShape | No | タイル形状 | SQUARE/ISOMETRIC/HALF_OFFSET_SQUARE/HEXAGON |
| tile_layout | TileLayout | No | タイルレイアウト | - |
| tile_offset_axis | TileOffsetAxis | No | オフセット軸 | HORIZONTAL/VERTICAL |
| tile_size | Vector2i | Yes | タイルサイズ（ピクセル） | 1以上 |

### メソッド入力

| メソッド名 | パラメータ | 説明 |
|-----------|-----------|------|
| add_source | source: TileSetSource, atlas_source_id_override: int | ソースを追加 |
| get_source | source_id: int | ソースを取得 |
| remove_source | source_id: int | ソースを削除 |
| map_to_local | map_position: Vector2i | マップ座標をローカル座標に変換 |
| local_to_map | local_position: Vector2 | ローカル座標をマップ座標に変換 |

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| タイルデータ | TileData | 各タイルの属性データ |
| テレインパターン | TerrainsPattern | テレインマッチング用パターン |

## 処理フロー

### 座標変換処理

```
map_to_local:
1. タイル形状に応じた座標計算
   └─ 正方形: coords * tile_size
   └─ アイソメトリック: 斜め投影変換
   └─ 六角形: オフセット考慮変換
2. タイル中心座標を返却
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-58-01 | タイルサイズ制限 | 幅・高さは1ピクセル以上 | 常時 |
| BR-58-02 | ソースID管理 | ソースIDは0以上、-1はINVALID_SOURCE | 常時 |
| BR-58-03 | テレイン隣接ビット | タイル形状に応じた有効な隣接ビットのみ使用可能 | テレイン使用時 |

### 計算ロジック

隣接タイル列挙（CellNeighbor）:
- RIGHT_SIDE, RIGHT_CORNER, BOTTOM_RIGHT_SIDE, BOTTOM_RIGHT_CORNER
- BOTTOM_SIDE, BOTTOM_CORNER, BOTTOM_LEFT_SIDE, BOTTOM_LEFT_CORNER
- LEFT_SIDE, LEFT_CORNER, TOP_LEFT_SIDE, TOP_LEFT_CORNER
- TOP_SIDE, TOP_CORNER, TOP_RIGHT_SIDE, TOP_RIGHT_CORNER

## データベース操作仕様

本機能はデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR_INVALID_PARAMETER | パラメータ不正 | タイルサイズが0以下 | 1以上を指定 |
| ERR_DOES_NOT_EXIST | 存在しない | 無効なソースID | 有効なIDを指定 |

## トランザクション仕様

リソースファイルとして保存。トランザクション管理なし。

## パフォーマンス要件

- テレインマッチングはキャッシュ済みパターンを使用
- メッシュ生成は変更時のみ再計算（dirty flag）

## セキュリティ考慮事項

特になし。

## 備考

- INVALID_SOURCE = -1
- INVALID_ATLAS_COORDS = Vector2i(-1, -1)
- INVALID_TILE_ALTERNATIVE = -1

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | tile_set.h | `scene/resources/2d/tile_set.h` | TileSetクラス定義、列挙型定義 |

**読解のコツ**: TileShape、TileLayout、TileOffsetAxis、CellNeighbor列挙型がタイル形状と隣接関係を定義する。

#### Step 2: タイル形状処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | tile_set.cpp | `scene/resources/2d/tile_set.cpp` | set_tile_shape、map_to_local関数 |

**主要処理フロー**:
- **352-366行目**: set_tile_shape関数でタイル形状設定
- **391-397行目**: set_tile_size関数でタイルサイズ設定
- **330行目**: INVALID_SOURCE定数定義

#### Step 3: テレインパターンを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | tile_set.cpp | `scene/resources/2d/tile_set.cpp` | TerrainsPattern構造体 |

**主要処理フロー**:
- **228-266行目**: TerrainsPatternの比較演算子
- **268-297行目**: テレインビットの設定・取得
- **299-328行目**: 配列との相互変換

#### Step 4: パターン管理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | tile_set.cpp | `scene/resources/2d/tile_set.cpp` | TileMapPattern関数群 |

**主要処理フロー**:
- **48-105行目**: タイルデータのシリアライズ
- **107-131行目**: セルの設定・削除
- **150-161行目**: 使用中セルの取得

### プログラム呼び出し階層図

```
TileSet
    │
    ├─ set_tile_shape
    │      └─ notify_tile_data_properties_should_change
    │
    ├─ set_tile_size
    │      └─ terrain_bits_meshes_dirty = true
    │
    ├─ add_source / get_source / remove_source
    │      └─ sources HashMap管理
    │
    ├─ map_to_local
    │      └─ タイル形状に応じた座標変換
    │
    └─ TerrainsPattern
           ├─ set_terrain_peering_bit
           └─ get_terrain_peering_bit
```

### データフロー図

```
[入力]                      [処理]                           [出力]

タイル形状設定 ────────────▶ set_tile_shape ────────────────▶ tile_shape
                             notify変更通知

タイルサイズ設定 ──────────▶ set_tile_size ─────────────────▶ tile_size
                             dirty flag設定

ソース追加 ────────────────▶ add_source ────────────────────▶ sources HashMap

マップ座標 ────────────────▶ map_to_local ──────────────────▶ ローカル座標
                             形状別変換
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| tile_set.cpp | `scene/resources/2d/tile_set.cpp` | ソース | TileSet本体 |
| tile_set.h | `scene/resources/2d/tile_set.h` | ヘッダ | クラス・列挙型定義 |
| tile_set_atlas_source.cpp | `scene/resources/2d/tile_set_atlas_source.cpp` | ソース | アトラスソース |
| tile_set_scenes_collection_source.cpp | `scene/resources/2d/tile_set_scenes_collection_source.cpp` | ソース | シーンソース |
| tile_map_layer.cpp | `scene/2d/tile_map_layer.cpp` | ソース | TileSetを使用するレイヤー |
