# 機能設計書 61-メッシュライブラリ

## 概要

本ドキュメントは、Godot Engineにおけるメッシュライブラリ（MeshLibrary）機能の設計書である。メッシュライブラリは、GridMapで使用する3Dメッシュアイテムのコレクションを管理するリソースクラスであり、3Dタイルベースのレベル構築において中核となる機能を提供する。

### 本機能の処理概要

メッシュライブラリは、複数の3Dメッシュをライブラリとして一元管理し、GridMapノードと連携してタイルベースの3Dレベル構築を可能にする機能である。

**業務上の目的・背景**：ゲーム開発において、繰り返し使用される3Dオブジェクト（壁、床、柱など）を効率的に管理・配置する必要がある。メッシュライブラリは、これらのオブジェクトをパレット化し、GridMapと組み合わせることで、ブロック単位での3Dレベル構築を容易にする。これにより、広大なダンジョンや都市などの3D環境を効率的に設計・構築できる。

**機能の利用シーン**：3Dダンジョン、ブロックベースの建築ゲーム、タイルベースの3Dフィールドなど、規則的なグリッド上にオブジェクトを配置するシーンで活用される。エディタ上でメッシュライブラリエディタを使用してメッシュの追加・編集を行い、GridMapエディタで実際の配置作業を行う。

**主要な処理内容**：
1. メッシュアイテムの作成・登録・管理（create_item, set_item_mesh等）
2. 各アイテムのプロパティ設定（名前、メッシュ、変形、シャドウ設定）
3. 物理形状（コリジョンシェイプ）の設定
4. ナビゲーションメッシュの設定
5. プレビュー画像の管理
6. アイテムの検索・一覧取得

**関連システム・外部連携**：GridMapノードと密接に連携し、GridMapのタイルソースとして機能する。また、NavigationMeshと連携してAIナビゲーションをサポートする。

**権限による制御**：特別な権限制御はなく、エディタおよびランタイムの両方で利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 48 | メッシュライブラリエディタ | 主画面 | GridMap用MeshLibraryの編集 |

## 機能種別

リソース管理 / CRUD操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| id | int | Yes | アイテムの一意識別子 | 0以上の整数 |
| name | String | No | アイテムの表示名 | なし |
| mesh | Ref<Mesh> | No | 3Dメッシュリソース | 有効なMeshリソース |
| mesh_transform | Transform3D | No | メッシュの変形情報 | なし |
| mesh_cast_shadow | int | No | シャドウキャスト設定 | 0-3の範囲 |
| shapes | Array | No | コリジョンシェイプ配列 | Shape3D/Transform3Dペア |
| navigation_mesh | Ref<NavigationMesh> | No | ナビゲーションメッシュ | 有効なNavigationMesh |
| navigation_mesh_transform | Transform3D | No | ナビメッシュの変形 | なし |
| navigation_layers | uint32_t | No | ナビゲーションレイヤー | ビットマスク |
| preview | Ref<Texture2D> | No | プレビュー画像 | 有効なTexture2D |

### 入力データソース

- エディタのメッシュライブラリエディタUI
- GDScript/C#からのAPI呼び出し
- リソースファイル（.meshlib）からの読み込み

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| item_list | Vector<int> | 登録済みアイテムIDの一覧 |
| item_name | String | 指定IDのアイテム名 |
| item_mesh | Ref<Mesh> | 指定IDのメッシュ |
| item_preview | Ref<Texture2D> | 指定IDのプレビュー画像 |
| last_unused_item_id | int | 次に使用可能なID |

### 出力先

- メモリ上のMeshLibraryリソース
- .meshlibファイル（リソース保存時）
- GridMapへの参照提供

## 処理フロー

### 処理シーケンス

```
1. アイテム作成（create_item）
   └─ 指定IDでアイテムマップにエントリを作成
2. プロパティ設定
   └─ set_item_mesh、set_item_name等で各プロパティを設定
3. 物理形状設定
   └─ set_item_shapesでコリジョンシェイプを設定
4. ナビゲーション設定
   └─ set_item_navigation_meshでナビメッシュを設定
5. プレビュー設定
   └─ set_item_previewでサムネイルを設定
6. 変更通知
   └─ emit_changed()でリソース変更を通知
```

### フローチャート

```mermaid
flowchart TD
    A[create_item呼び出し] --> B{IDが有効か}
    B -->|No| C[エラー終了]
    B -->|Yes| D{IDは未使用か}
    D -->|No| C
    D -->|Yes| E[item_mapにエントリ追加]
    E --> F[emit_changed発火]
    F --> G[プロパティ設定可能状態]
    G --> H[set_item_mesh等]
    H --> I[emit_changed発火]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | ID一意性 | 同一MeshLibrary内でIDは一意でなければならない | アイテム作成時 |
| BR-02 | ID非負数 | IDは0以上の整数でなければならない | アイテム作成時 |
| BR-03 | シャドウ設定値 | mesh_cast_shadowは0-3の値を取る | シャドウ設定時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

メッシュライブラリは内部データ構造（RBMap）で管理されるため、データベース操作は発生しない。

| 操作 | 対象 | 操作種別 | 概要 |
|-----|------|---------|------|
| 作成 | item_map | INSERT | 新規アイテムをマップに追加 |
| 更新 | item_map | UPDATE | 既存アイテムのプロパティ変更 |
| 削除 | item_map | DELETE | remove_itemでアイテム削除 |
| 参照 | item_map | SELECT | get_item_*でプロパティ取得 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR_FAIL_COND | 引数エラー | IDが負数 | 正のIDを指定 |
| ERR_FAIL_COND | 重複エラー | 既存IDで作成試行 | 別のIDを使用 |
| ERR_FAIL_COND_MSG | 存在エラー | 存在しないIDを参照 | 有効なIDを確認 |

### リトライ仕様

リトライは不要（同期処理）

## トランザクション仕様

トランザクション管理は不要（メモリ上のリソース操作）

## パフォーマンス要件

- アイテム追加・取得: O(log n)（RBMap使用）
- アイテム一覧取得: O(n)
- 多数のアイテム（数百〜数千）を効率的に処理可能

## セキュリティ考慮事項

特別なセキュリティ考慮事項はなし

## 備考

- .meshlib拡張子でリソースとして保存可能
- エディタでは専用のメッシュライブラリエディタUIが提供される
- GridMapと組み合わせて使用することを想定

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

メッシュライブラリの内部データ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | mesh_library.h | `scene/resources/3d/mesh_library.h` | Item構造体とRBMapの定義を確認 |

**読解のコツ**:
- **54-66行目**: Item構造体の定義。メッシュ、変形、シャドウ設定、物理形状、ナビメッシュ、プレビュー等のプロパティを持つ
- **68行目**: `RBMap<int, Item> item_map` - アイテムIDをキーとした赤黒木マップ
- **49-52行目**: ShapeData構造体。Shape3Dとローカル変形をペアで保持

#### Step 2: エントリーポイントを理解する

アイテム作成がエントリーポイントとなる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | mesh_library.cpp | `scene/resources/3d/mesh_library.cpp` | create_itemメソッドの実装 |

**主要処理フロー**:
1. **158-164行目**: create_item - ID検証、マップへのエントリ追加、変更通知
2. **166-170行目**: set_item_name - 名前設定と変更通知
3. **172-176行目**: set_item_mesh - メッシュ設定と変更通知

#### Step 3: プロパティ設定メソッドを理解する

各種setter/getterメソッドの実装を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | mesh_library.cpp | `scene/resources/3d/mesh_library.cpp` | 各set_item_*/get_item_*メソッド |

**主要処理フロー**:
- **191-196行目**: set_item_shapes - 物理形状の設定
- **199-203行目**: set_item_navigation_mesh - ナビメッシュ設定
- **274-279行目**: remove_item - アイテム削除とマップからのエントリ消去

#### Step 4: シリアライズ処理を理解する

プロパティの読み書きカスタム処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | mesh_library.cpp | `scene/resources/3d/mesh_library.cpp` | _set, _get, _get_property_listメソッド |

**主要処理フロー**:
- **37-102行目**: _set - "item/{id}/{prop}"形式のプロパティパス解析と設定
- **104-141行目**: _get - プロパティ値の取得
- **143-156行目**: _get_property_list - 動的プロパティリスト生成

### プログラム呼び出し階層図

```
MeshLibrary
    │
    ├─ create_item(id)
    │      └─ item_map[id] = Item()
    │
    ├─ set_item_mesh(id, mesh)
    │      └─ item_map[id].mesh = mesh
    │
    ├─ set_item_shapes(id, shapes)
    │      └─ item_map[id].shapes = shapes
    │
    ├─ set_item_navigation_mesh(id, nav_mesh)
    │      └─ item_map[id].navigation_mesh = nav_mesh
    │
    └─ GridMap（利用側）
           └─ get_item_mesh(id) で参照
```

### データフロー図

```
[入力]                    [処理]                      [出力]

エディタUI      ───▶ create_item()     ───▶ item_map
                      set_item_*()            ↓
                                              ↓
GDScript        ───▶ get_item_*()      ───▶ Mesh/Shape/NavMesh
                                              ↓
リソースファイル ───▶ _set()/_get()     ───▶ GridMap描画
(.meshlib)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| mesh_library.h | `scene/resources/3d/mesh_library.h` | ヘッダー | クラス定義・構造体定義 |
| mesh_library.cpp | `scene/resources/3d/mesh_library.cpp` | ソース | メソッド実装 |
| grid_map.cpp | `modules/gridmap/grid_map.cpp` | ソース | MeshLibraryの主要利用先 |
| mesh_library_editor_plugin.cpp | `modules/gridmap/editor/mesh_library_editor_plugin.cpp` | ソース | エディタ統合 |
