# 機能設計書 62-glTFインポート

## 概要

本ドキュメントは、Godot EngineにおけるglTF（GL Transmission Format）インポート機能の設計書である。glTFは3Dモデルおよびシーンの標準的な交換フォーマットであり、本機能はglTF 2.0形式のファイル（.gltf/.glb）をGodotのシーンおよびリソースとして読み込む機能を提供する。

### 本機能の処理概要

glTFインポート機能は、Khronos Groupが策定したglTF 2.0フォーマットのファイルを解析し、Godotのノード階層、メッシュ、マテリアル、アニメーション、スケルトンなどに変換する包括的なインポートシステムである。

**業務上の目的・背景**：3Dコンテンツ制作において、Blender、Maya、3ds Maxなどの主要3Dソフトウェアで作成されたアセットをゲームエンジンに取り込む必要がある。glTFは「3DのJPEG」とも呼ばれる標準フォーマットであり、多くの3Dソフトウェアがサポートしている。本機能により、外部ツールで作成された高品質な3Dアセットを効率的にGodotプロジェクトに統合できる。

**機能の利用シーン**：キャラクターモデル、背景オブジェクト、プロップ、アニメーション付きモデルのインポート。Blenderから直接.blendファイルをインポートする際の内部変換処理。ランタイムでの動的な3Dモデル読み込み。

**主要な処理内容**：
1. glTF/GLBファイルの解析（JSONパース、バイナリバッファ読み込み）
2. ノード階層の構築（シーンツリー生成）
3. メッシュデータの変換（頂点、法線、UV、スキニング情報）
4. マテリアル・テクスチャの変換（PBRマテリアル対応）
5. アニメーションの変換（ボーンアニメーション、シェイプキー）
6. スケルトン・スキンの処理

**関連システム・外部連携**：FBXインポート（内部でglTF変換を使用可能）、Blenderインポート（.blendをglTFに変換）、リソースローダーシステムとの統合。

**権限による制御**：エディタでのインポート設定、ランタイムでのdocument.append_from_file()による動的読み込みの両方が可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 13 | インポートドック | 主画面 | glTFモデルのインポート設定 |

## 機能種別

データ変換処理 / インポート処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| source_file | String | Yes | glTF/GLBファイルパス | 有効なファイルパス |
| flags | uint32_t | No | インポートフラグ | ビットマスク |
| generate_tangents | bool | No | タンジェント生成 | - |
| use_named_skin_binds | bool | No | 名前付きスキンバインド | - |
| discard_meshes_and_materials | bool | No | メッシュ・マテリアル破棄 | - |
| force_disable_mesh_compression | bool | No | メッシュ圧縮無効化 | - |

### 入力データソース

- .gltfファイル（JSON形式 + 外部バイナリ/画像）
- .glbファイル（バイナリ形式、データ埋め込み）
- エディタのインポート設定UI
- GDScript/C#からのAPI呼び出し

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| scene | Node* | 変換されたシーンルートノード |
| meshes | Array<Mesh> | 抽出されたメッシュリソース |
| materials | Array<Material> | 変換されたマテリアル |
| animations | Array<Animation> | アニメーションリソース |
| textures | Array<Texture2D> | テクスチャリソース |

### 出力先

- インポートされた.scnファイル（PackedScene）
- 抽出されたリソースファイル
- ランタイム読み込み時はメモリ上のシーン

## 処理フロー

### 処理シーケンス

```
1. ファイル読み込み
   └─ glTF(JSON)またはGLB(バイナリ)を検出・解析
2. バッファ/アクセサ解析
   └─ バイナリデータの位置とフォーマットを特定
3. メッシュ変換
   └─ 頂点データ、インデックス、スキニング情報を変換
4. マテリアル/テクスチャ変換
   └─ PBRマテリアルをStandardMaterial3Dに変換
5. ノード階層構築
   └─ glTFノードをGodotノードツリーに変換
6. スケルトン/スキン処理
   └─ ボーン階層とスキンバインドを処理
7. アニメーション変換
   └─ キーフレームアニメーションを変換
8. 拡張機能処理
   └─ KHR_lights、physics等の拡張を処理
9. シーン生成
   └─ 最終的なGodotシーンを構築
```

### フローチャート

```mermaid
flowchart TD
    A[glTF/GLBファイル] --> B{ファイル形式判定}
    B -->|.gltf| C[JSON解析]
    B -->|.glb| D[GLBヘッダー解析]
    C --> E[外部リソース読み込み]
    D --> F[埋め込みデータ抽出]
    E --> G[バッファ/アクセサ解析]
    F --> G
    G --> H[メッシュ変換]
    H --> I[マテリアル変換]
    I --> J[ノード階層構築]
    J --> K[スケルトン処理]
    K --> L[アニメーション変換]
    L --> M[拡張機能処理]
    M --> N[Godotシーン生成]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | glTF 2.0準拠 | glTF 2.0仕様に準拠したファイルを処理 | 全てのインポート |
| BR-02 | PBRマテリアル変換 | glTF PBRをStandardMaterial3Dに変換 | マテリアル処理時 |
| BR-03 | 座標系変換 | glTFのY-Up右手系からGodotのY-Up右手系へ | 全ての座標データ |
| BR-04 | 拡張機能サポート | KHR_*拡張機能を可能な限りサポート | 拡張使用時 |

### 計算ロジック

- タンジェント生成: MikkTSpaceアルゴリズムによる計算
- 法線生成: スムースグループを考慮した法線計算
- LOD生成: メッシュ最適化オプション有効時

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は発生しない（ファイルベースの変換処理）。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR_FILE_CORRUPT | ファイル破損 | glTF/GLB形式不正 | ファイルを確認 |
| ERR_CANT_OPEN | ファイルオープン失敗 | ファイル不存在/権限 | パスを確認 |
| ERR_PARSE_ERROR | JSON解析エラー | 不正なJSON構文 | ファイル形式確認 |
| ERR_INVALID_DATA | データ不正 | バッファ/アクセサ不正 | glTFバリデータ使用 |

### リトライ仕様

リトライは不要（同期処理、失敗時は即座にエラー返却）

## トランザクション仕様

トランザクション管理は不要

## パフォーマンス要件

- 小規模モデル（数千ポリゴン）: 1秒未満
- 中規模モデル（数十万ポリゴン）: 数秒
- 大規模シーン: メモリ使用量に注意（ストリーミング未対応）

## セキュリティ考慮事項

- 外部参照URI: file://スキームによるローカルファイルアクセスに注意
- データURIのサイズ制限に注意
- 信頼できないソースからのglTFは検証推奨

## 備考

- Blender連携: Blenderがインストールされている場合、.blendファイルを自動的にglTFに変換してインポート可能
- 拡張機能ドキュメント: GLTFDocumentExtensionでカスタム拡張を追加可能
- エクスポート機能: 同じモジュールでglTFエクスポートもサポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

glTFの内部データ構造を表すクラス群を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | gltf_state.h | `modules/gltf/gltf_state.h` | GLTFStateクラス - 変換中間状態を保持 |
| 1-2 | gltf_node.h | `modules/gltf/structures/gltf_node.h` | GLTFNodeクラス - ノード情報 |
| 1-3 | gltf_mesh.h | `modules/gltf/structures/gltf_mesh.h` | GLTFMeshクラス - メッシュ情報 |

**読解のコツ**: 各構造体クラスはglTF仕様のJSONスキーマに対応している。glTF 2.0仕様書と併せて読むと理解しやすい。

#### Step 2: エントリーポイントを理解する

GLTFDocumentクラスのメインメソッドを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | gltf_document.cpp | `modules/gltf/gltf_document.cpp` | _serializeと_parseメソッド |

**主要処理フロー**:
1. **102-200行目**: _serialize - エクスポート時のシリアライズ処理
2. append_from_file / append_from_buffer - インポートエントリーポイント

#### Step 3: 各コンポーネントの変換処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | gltf_document.cpp | `modules/gltf/gltf_document.cpp` | _parse_meshes, _parse_materials等 |
| 3-2 | skin_tool.cpp | `modules/gltf/skin_tool.cpp` | スケルトン/スキン処理 |

**主要処理フロー**:
- _serialize_meshes: メッシュデータのエクスポート
- _serialize_materials: マテリアルのエクスポート
- _serialize_animations: アニメーションのエクスポート

#### Step 4: 拡張機能システムを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | gltf_document_extension.cpp | `modules/gltf/extensions/gltf_document_extension.cpp` | 拡張機能の基底クラス |
| 4-2 | gltf_light.cpp | `modules/gltf/extensions/gltf_light.cpp` | KHR_lights_punctual実装例 |

### プログラム呼び出し階層図

```
GLTFDocument
    │
    ├─ append_from_file(path)
    │      ├─ _parse_gltf_state()
    │      │      ├─ _parse_nodes()
    │      │      ├─ _parse_meshes()
    │      │      ├─ _parse_materials()
    │      │      ├─ _parse_textures()
    │      │      └─ _parse_animations()
    │      └─ generate_scene()
    │
    ├─ GLTFDocumentExtension[]
    │      └─ export_preserialize() / import_post_parse()
    │
    └─ SkinTool
           └─ create_skeletons()
```

### データフロー図

```
[入力]                     [処理]                      [出力]

.gltf/.glb        ───▶ GLTFDocument        ───▶ Node (シーン)
   │                    ├─ parse             │
   │                    ├─ convert           ├─ Mesh[]
   │                    └─ generate          ├─ Material[]
   │                                         ├─ Animation[]
JSON/Binary       ───▶ GLTFState           └─ Texture2D[]
(中間表現)               (中間データ)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| gltf_document.cpp | `modules/gltf/gltf_document.cpp` | ソース | メインドキュメントクラス |
| gltf_document.h | `modules/gltf/gltf_document.h` | ヘッダー | クラス定義 |
| gltf_state.cpp | `modules/gltf/gltf_state.cpp` | ソース | 状態管理クラス |
| skin_tool.cpp | `modules/gltf/skin_tool.cpp` | ソース | スキン処理ユーティリティ |
| editor_scene_importer_gltf.cpp | `modules/gltf/editor/editor_scene_importer_gltf.cpp` | ソース | エディタ統合 |
| editor_scene_importer_blend.cpp | `modules/gltf/editor/editor_scene_importer_blend.cpp` | ソース | Blender連携 |
| gltf_document_extension.cpp | `modules/gltf/extensions/gltf_document_extension.cpp` | ソース | 拡張機能基底 |
| gltf_light.cpp | `modules/gltf/extensions/gltf_light.cpp` | ソース | ライト拡張 |
| gltf_physics_shape.cpp | `modules/gltf/extensions/physics/gltf_physics_shape.cpp` | ソース | 物理形状拡張 |
