# 機能設計書 63-FBXインポート

## 概要

本ドキュメントは、Godot EngineにおけるFBX（Filmbox）インポート機能の設計書である。FBXはAutodeskが開発した3Dデータ交換フォーマットであり、本機能はufbxライブラリを使用してFBXファイルをGodotのシーンおよびリソースとして読み込む機能を提供する。

### 本機能の処理概要

FBXインポート機能は、Autodesk FBXフォーマットのファイルを解析し、Godotのノード階層、メッシュ、マテリアル、アニメーション、スケルトンなどに変換する機能である。内部でufbxライブラリを使用し、glTFモジュールの構造体を活用した変換処理を行う。

**業務上の目的・背景**：ゲーム・映像制作業界において、Maya、3ds Max、MotionBuilderなどのAutodesk製品が広く使用されており、これらのツールからの主要な出力フォーマットがFBXである。本機能により、Autodesk製ツールで作成された高品質な3Dアセットやアニメーションを効率的にGodotプロジェクトに統合できる。

**機能の利用シーン**：Mayaや3ds Maxで作成されたキャラクターモデル、背景アセット、アニメーションデータのインポート。モーションキャプチャデータの取り込み。既存のFBXアセットライブラリの活用。

**主要な処理内容**：
1. FBXファイルの解析（ufbxライブラリによるパース）
2. ノード階層の構築（FBXノードからGodotノードへの変換）
3. メッシュデータの変換（頂点、法線、UV、スキニング情報）
4. マテリアル・テクスチャの変換
5. アニメーションの変換（ボーンアニメーション、ブレンドシェイプ）
6. スケルトン・スキンの処理

**関連システム・外部連携**：glTFモジュールの構造体（GLTFAnimation、GLTFCamera等）を活用。fbx2gltfによる外部変換オプションも提供（レガシーサポート）。

**権限による制御**：エディタでのインポート設定、ランタイムでの動的読み込みの両方が可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 13 | インポートドック | 主画面 | FBXモデルのインポート設定 |

## 機能種別

データ変換処理 / インポート処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| source_file | String | Yes | FBXファイルパス | 有効なファイルパス |
| flags | uint32_t | No | インポートフラグ | ビットマスク |
| use_named_skin_binds | bool | No | 名前付きスキンバインド | - |
| discard_meshes_and_materials | bool | No | メッシュ・マテリアル破棄 | - |
| force_disable_mesh_compression | bool | No | メッシュ圧縮無効化 | - |

### 入力データソース

- .fbxファイル（バイナリまたはASCII形式）
- エディタのインポート設定UI
- GDScript/C#からのAPI呼び出し

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| scene | Node* | 変換されたシーンルートノード |
| meshes | Array<Mesh> | 抽出されたメッシュリソース |
| materials | Array<Material> | 変換されたマテリアル |
| animations | Array<Animation> | アニメーションリソース |
| textures | Array<Texture2D> | テクスチャリソース |

### 出力先

- インポートされた.scnファイル（PackedScene）
- 抽出されたリソースファイル
- ランタイム読み込み時はメモリ上のシーン

## 処理フロー

### 処理シーケンス

```
1. FBXファイル読み込み
   └─ ufbx_load_file()でFBXデータをパース
2. ノード階層解析
   └─ ufbx_nodeからGodotノード構造を構築
3. メッシュ変換
   └─ ufbx_meshから頂点、法線、UV、スキニング情報を抽出
4. マテリアル/テクスチャ変換
   └─ ufbx_materialからStandardMaterial3Dを生成
5. スケルトン/スキン処理
   └─ ボーン階層とスキンバインドを処理
6. アニメーション変換
   └─ ufbx_anim_stackからAnimationリソースを生成
7. シーン生成
   └─ 最終的なGodotシーンを構築
```

### フローチャート

```mermaid
flowchart TD
    A[.fbxファイル] --> B[ufbx_load_file]
    B --> C{解析成功?}
    C -->|No| D[エラー終了]
    C -->|Yes| E[ufbx_scene取得]
    E --> F[ノード階層構築]
    F --> G[メッシュ変換]
    G --> H[マテリアル変換]
    H --> I[スケルトン処理]
    I --> J[アニメーション変換]
    J --> K[Godotシーン生成]
    K --> L[ufbx_free_scene]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | FBX形式対応 | バイナリ・ASCII両方のFBX形式を処理 | 全てのインポート |
| BR-02 | 座標系変換 | FBXの座標系をGodotに変換 | 全ての座標データ |
| BR-03 | スケール正規化 | FBXのスケール設定をGodot単位に正規化 | ノード変換時 |
| BR-04 | ufbxライブラリ使用 | 内部でufbxライブラリを使用 | 全てのインポート |

### 計算ロジック

- 座標変換: `_as_vec3()`, `_as_quaternion()`, `_as_transform()`関数
- マテリアルカラー: `_material_color()`関数でufbx_material_mapを変換
- 頂点属性デコード: `_decode_vertex_attrib_*`関数群

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は発生しない（ファイルベースの変換処理）。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR_FILE_CORRUPT | ファイル破損 | FBX形式不正 | ファイルを確認 |
| ERR_CANT_OPEN | ファイルオープン失敗 | ファイル不存在/権限 | パスを確認 |
| ufbx_error | ufbxパースエラー | FBXデータ不正 | FBXファイル再エクスポート |

### リトライ仕様

リトライは不要（同期処理、失敗時は即座にエラー返却）

## トランザクション仕様

トランザクション管理は不要

## パフォーマンス要件

- ufbxはシングルヘッダーライブラリで高速な解析を提供
- 大規模モデルでは一時メモリ使用量に注意
- スキニング付きメッシュは追加処理時間が必要

## セキュリティ考慮事項

- 外部テクスチャ参照パスに注意
- 信頼できないソースからのFBXは検証推奨
- ufbxライブラリのセキュリティアップデートを追跡

## 備考

- fbx2gltf: 外部ツールを使用したFBX→glTF変換オプションも提供（レガシー）
- ufbx: MIT/Public Domainライセンスのシングルヘッダーライブラリを使用
- glTFモジュールの構造体を活用することで、コードの再利用性を向上

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ufbxライブラリのデータ構造とヘルパー関数を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | fbx_document.cpp | `modules/fbx/fbx_document.cpp` | ufbx型からGodot型への変換関数 |

**読解のコツ**:
- **77-79行目**: `_as_vec2()` - ufbx_vec2からVector2への変換
- **81-83行目**: `_as_color()` - ufbx_vec4からColorへの変換
- **85-87行目**: `_as_quaternion()` - ufbx_quatからQuaternionへの変換
- **89-94行目**: `_as_transform()` - ufbx_transformからTransform3Dへの変換

#### Step 2: ファイル読み込み処理を理解する

カスタムファイルアクセスコールバックの実装。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | fbx_document.cpp | `modules/fbx/fbx_document.cpp` | ファイルアクセス関数 |

**主要処理フロー**:
1. **66-69行目**: `_file_access_read_fn` - ufbxのファイル読み込みコールバック
2. **71-75行目**: `_file_access_skip_fn` - ufbxのファイルスキップコールバック

#### Step 3: マテリアル変換を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | fbx_document.cpp | `modules/fbx/fbx_document.cpp` | マテリアルカラー取得 |

**主要処理フロー**:
- **100-116行目**: `_material_color(ufbx_material_map)` - マテリアルマップからカラー取得
- **118-127行目**: `_material_color(map, factor)` - ファクター付きカラー取得

#### Step 4: 頂点属性デコードを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | fbx_document.cpp | `modules/fbx/fbx_document.cpp` | 頂点データ変換 |

**主要処理フロー**:
- **154-163行目**: `_decode_vertex_attrib_vec2` - UV座標のデコード
- **165-174行目**: `_decode_vertex_attrib_vec3` - 法線/頂点のデコード
- **176-189行目**: `_decode_vertex_attrib_vec3_as_tangent` - タンジェントのデコード
- **191-199行目**: `_decode_vertex_attrib_color` - 頂点カラーのデコード

### プログラム呼び出し階層図

```
FBXDocument
    │
    ├─ ufbx_load_file()
    │      └─ _file_access_read_fn (コールバック)
    │
    ├─ _parse_scene(ufbx_scene*)
    │      ├─ ノード階層構築
    │      ├─ メッシュ変換
    │      │      └─ _decode_vertex_attrib_*
    │      ├─ マテリアル変換
    │      │      └─ _material_color()
    │      ├─ スケルトン処理
    │      │      └─ SkinTool (glTFモジュール)
    │      └─ アニメーション変換
    │
    └─ ufbx_free_scene()
```

### データフロー図

```
[入力]                     [処理]                      [出力]

.fbxファイル      ───▶ ufbx_load_file     ───▶ ufbx_scene
                           │                      │
FileAccess        ───▶ コールバック関数        │
                           │                      │
                           ▼                      ▼
                    FBXDocument          ───▶ Node (シーン)
                    ├─ 座標変換                  ├─ Mesh[]
                    ├─ マテリアル変換            ├─ Material[]
                    └─ アニメーション変換        └─ Animation[]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| fbx_document.cpp | `modules/fbx/fbx_document.cpp` | ソース | メインドキュメントクラス |
| fbx_document.h | `modules/fbx/fbx_document.h` | ヘッダー | クラス定義 |
| fbx_state.cpp | `modules/fbx/fbx_state.cpp` | ソース | 状態管理クラス |
| editor_scene_importer_ufbx.cpp | `modules/fbx/editor/editor_scene_importer_ufbx.cpp` | ソース | エディタ統合（ufbx版） |
| editor_scene_importer_fbx2gltf.cpp | `modules/fbx/editor/editor_scene_importer_fbx2gltf.cpp` | ソース | fbx2gltfツール連携 |
| ufbx.h | (外部ライブラリ) | ヘッダー | FBXパースライブラリ |
| skin_tool.cpp | `modules/gltf/skin_tool.cpp` | ソース | スキン処理（glTFモジュール共有） |
