# 機能設計書 64-OBJインポート

## 概要

本ドキュメントは、Godot EngineにおけるWavefront OBJインポート機能の設計書である。OBJはシンプルで広くサポートされている3Dモデルフォーマットであり、本機能は.objファイルとその関連マテリアルファイル（.mtl）をGodotのメッシュリソースとして読み込む機能を提供する。

### 本機能の処理概要

OBJインポート機能は、テキストベースのWavefront OBJフォーマットを解析し、頂点、法線、UV座標、フェイスデータを抽出してGodotのメッシュリソースに変換する機能である。MTLファイルによるマテリアル定義もサポートする。

**業務上の目的・背景**：OBJフォーマットはほぼ全ての3Dソフトウェアでサポートされる汎用フォーマットであり、シンプルな3Dモデルの交換に広く使用されている。特にプロトタイピングや簡易モデルのインポート、レガシーアセットの活用において重要な役割を果たす。

**機能の利用シーン**：シンプルな3Dモデル（小道具、環境オブジェクト等）のインポート。他の3Dソフトウェアからの汎用エクスポート。テスト用プリミティブモデルの取り込み。

**主要な処理内容**：
1. OBJファイルのテキスト解析（頂点、法線、UV、フェイス）
2. MTLファイルの解析（マテリアル定義、テクスチャパス）
3. サーフェス単位でのメッシュ構築
4. 法線・タンジェントの自動生成
5. LOD生成、シャドウメッシュ生成（オプション）
6. ライトマップUV2生成（オプション）

**関連システム・外部連携**：SurfaceToolを使用したメッシュ構築。StandardMaterial3Dへのマテリアル変換。ResourceImporterSceneとの統合。

**権限による制御**：エディタでのインポート設定で各種オプションを制御可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 13 | インポートドック | 主画面 | OBJモデルのインポート設定 |

## 機能種別

データ変換処理 / インポート処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| source_file | String | Yes | OBJファイルパス | 有効なファイルパス |
| generate_tangents | bool | No | タンジェント生成 | デフォルト: true |
| generate_lods | bool | No | LOD生成 | デフォルト: true |
| generate_shadow_mesh | bool | No | シャドウメッシュ生成 | デフォルト: true |
| generate_lightmap_uv2 | bool | No | ライトマップUV2生成 | デフォルト: false |
| generate_lightmap_uv2_texel_size | float | No | UV2テクセルサイズ | 0.001-100、デフォルト: 0.2 |
| scale_mesh | Vector3 | No | メッシュスケール | デフォルト: (1,1,1) |
| offset_mesh | Vector3 | No | メッシュオフセット | デフォルト: (0,0,0) |
| force_disable_mesh_compression | bool | No | 圧縮無効化 | デフォルト: false |

### 入力データソース

- .objファイル（テキスト形式）
- .mtlファイル（マテリアルライブラリ、オプション）
- テクスチャファイル（.mtlから参照）
- エディタのインポート設定UI

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| mesh | Mesh | 変換されたメッシュリソース |
| surfaces | Array | サーフェス情報（マテリアル毎） |
| materials | Array<StandardMaterial3D> | 変換されたマテリアル |

### 出力先

- .meshファイル（エディタインポート時）
- メモリ上のMeshリソース

## 処理フロー

### 処理シーケンス

```
1. OBJファイル読み込み
   └─ テキストファイルとして行単位で解析
2. COFFヘッダーチェック
   └─ Visual Studioビルドアーティファクトを除外
3. 頂点データ解析
   └─ v, vt, vn コマンドから頂点/UV/法線を抽出
4. フェイスデータ解析
   └─ f コマンドから三角形を構築
5. MTLファイル解析
   └─ mtllib参照からマテリアルを読み込み
6. サーフェス構築
   └─ usemtl毎にサーフェスを分割
7. 法線/タンジェント生成
   └─ 不足分を自動生成
8. LOD/シャドウメッシュ生成
   └─ オプション有効時に実行
9. ライトマップUV2生成
   └─ オプション有効時に実行
10. メッシュ最適化
    └─ インデックス最適化
```

### フローチャート

```mermaid
flowchart TD
    A[.objファイル] --> B{COFF検出?}
    B -->|Yes| C[エラー: バイナリファイル]
    B -->|No| D[行解析ループ]
    D --> E{コマンド種別}
    E -->|v| F[頂点追加]
    E -->|vt| G[UV追加]
    E -->|vn| H[法線追加]
    E -->|f| I[フェイス構築]
    E -->|mtllib| J[MTL読み込み]
    E -->|usemtl| K[サーフェス切替]
    F --> D
    G --> D
    H --> D
    I --> D
    J --> D
    K --> D
    D -->|EOF| L[法線/タンジェント生成]
    L --> M[LOD生成]
    M --> N[シャドウメッシュ生成]
    N --> O[メッシュ最適化]
    O --> P[Mesh出力]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 行継続 | バックスラッシュで行を継続可能 | フェイス定義等 |
| BR-02 | 負のインデックス | 負のインデックスは末尾からの相対参照 | フェイス定義時 |
| BR-03 | UV座標Y反転 | OBJのV座標はGodotでは1.0-vとなる | UV処理時 |
| BR-04 | スムージンググループ | s コマンドでスムージング制御 | 法線計算時 |

### 計算ロジック

- 頂点座標計算: `vtx = v * scale_mesh + offset_mesh`
- UV座標変換: `uv.y = 1.0 - v`
- メタリック近似: `metallic = MAX(r, MAX(g, b))` （Ks から）

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は発生しない（ファイルベースの変換処理）。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR_CANT_OPEN | ファイルオープン失敗 | ファイル不存在/権限 | パスを確認 |
| ERR_FILE_CORRUPT | ファイル破損 | COFFヘッダー検出 | 正しいOBJファイル使用 |
| ERR_FILE_CORRUPT | データ不正 | 頂点数不足 | OBJファイル確認 |
| ERR_INVALID_DATA | フォーマット不正 | フェイス定義エラー | OBJ再エクスポート |

### リトライ仕様

リトライは不要（同期処理）

## トランザクション仕様

トランザクション管理は不要

## パフォーマンス要件

- シンプルなOBJ（数千ポリゴン）: 高速処理
- 大規模OBJ（数十万ポリゴン）: LOD生成時に処理時間増加
- ライトマップUV2生成: 追加の処理時間が必要

## セキュリティ考慮事項

- MTLからの外部テクスチャパス参照に注意
- 相対パス・絶対パスの両方をサポート

## 備考

- OBJ as Mesh: ResourceImporterOBJは単一メッシュとしてインポート
- シーンインポート: EditorOBJImporterは複数オブジェクトをシーンとしてインポート
- 頂点カラー: OBJ拡張形式の頂点カラー（v x y z r g b）をサポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

インポート処理のメイン関数を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | resource_importer_obj.cpp | `editor/import/3d/resource_importer_obj.cpp` | import()関数とget_import_options() |

**読解のコツ**:
- **609-611行目**: get_importer_name() - "wavefront_obj"を返す
- **641-650行目**: get_import_options() - インポートオプション定義
- **661-701行目**: import() - メインインポート処理

#### Step 2: OBJパース処理を理解する

_parse_obj関数でOBJファイルの解析処理を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | resource_importer_obj.cpp | `editor/import/3d/resource_importer_obj.cpp` | _parse_obj関数 |

**主要処理フロー**:
1. **220-236行目**: COFFヘッダーチェック（Visual Studioアーティファクト検出）
2. **266-297行目**: 行解析ループ開始
3. **276-297行目**: "v "コマンド - 頂点座標と頂点カラー解析
4. **298-305行目**: "vt "コマンド - UV座標解析
5. **306-314行目**: "vn "コマンド - 法線解析
6. **315-386行目**: "f "コマンド - フェイス（三角形）構築

#### Step 3: MTL解析を理解する

マテリアルライブラリファイルの解析処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | resource_importer_obj.cpp | `editor/import/3d/resource_importer_obj.cpp` | _parse_material_library関数 |

**主要処理フロー**:
- **51-56行目**: "newmtl "コマンド - 新規マテリアル開始
- **61-70行目**: "Kd "コマンド - ディフューズカラー
- **71-80行目**: "Ks "コマンド - スペキュラカラー（メタリック変換）
- **88-99行目**: "d "コマンド - 透明度
- **117-135行目**: "map_Kd "コマンド - ディフューズテクスチャ

#### Step 4: サーフェス構築を理解する

SurfaceToolを使用したメッシュ構築処理。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | resource_importer_obj.cpp | `editor/import/3d/resource_importer_obj.cpp` | サーフェスコミット処理 |

**主要処理フロー**:
- **401-419行目**: メッシュ圧縮フラグ設定
- **423-431行目**: 法線・タンジェント自動生成
- **446-463行目**: サーフェスをメッシュに追加

### プログラム呼び出し階層図

```
ResourceImporterOBJ
    │
    ├─ import()
    │      └─ _parse_obj()
    │             ├─ 頂点解析 (v, vt, vn)
    │             ├─ フェイス解析 (f)
    │             ├─ _parse_material_library()
    │             │      └─ StandardMaterial3D生成
    │             └─ SurfaceTool
    │                    ├─ add_vertex()
    │                    ├─ generate_normals()
    │                    ├─ generate_tangents()
    │                    └─ commit()
    │
    └─ EditorOBJImporter
           └─ import_scene()
                  └─ _parse_obj() (複数メッシュ対応)
```

### データフロー図

```
[入力]                     [処理]                      [出力]

.objファイル      ───▶ _parse_obj          ───▶ ImporterMesh
   │                    ├─ 頂点解析              │
   │                    ├─ フェイス解析          ├─ surfaces[]
   │                    └─ SurfaceTool           └─ materials[]
   │
.mtlファイル      ───▶ _parse_material_library ───▶ StandardMaterial3D[]
   │                    ├─ カラー解析
   │                    └─ テクスチャ参照
   │
テクスチャ        ───▶ ResourceLoader      ───▶ Texture2D
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| resource_importer_obj.cpp | `editor/import/3d/resource_importer_obj.cpp` | ソース | メインインポーター |
| resource_importer_obj.h | `editor/import/3d/resource_importer_obj.h` | ヘッダー | クラス定義 |
| surface_tool.cpp | `scene/resources/surface_tool.cpp` | ソース | メッシュ構築ユーティリティ |
| importer_mesh.cpp | `scene/resources/3d/importer_mesh.cpp` | ソース | インポートメッシュクラス |
