# 機能設計書 65-画像インポート

## 概要

本ドキュメントは、Godot Engineにおける画像インポート機能の設計書である。本機能は、PNG、JPG、WebP、SVG、HDR、EXR等の画像ファイルをGodotのテクスチャリソース（CompressedTexture2D）として読み込み、用途に応じた最適な圧縮形式に変換する機能を提供する。

### 本機能の処理概要

画像インポート機能は、様々な画像フォーマットを読み込み、ゲーム実行時に最適なパフォーマンスを発揮できるよう圧縮・変換処理を行う包括的なインポートシステムである。2D/3D用途の自動検出、VRAM圧縮、ミップマップ生成など、多様なオプションを提供する。

**業務上の目的・背景**：ゲーム開発において、テクスチャはメモリ使用量の大部分を占めることが多い。本機能は、画質とファイルサイズ/メモリ使用量のバランスを最適化し、ターゲットプラットフォームに適した圧縮形式を自動選択することで、効率的なアセット管理を実現する。

**機能の利用シーン**：スプライト、UI要素、3Dテクスチャ（アルベド、法線、ラフネス等）、背景画像のインポート。SVGアイコンのラスタライズ。HDR環境マップの取り込み。

**主要な処理内容**：
1. 画像ファイルの読み込み（PNG、JPG、WebP、SVG、HDR、EXR等）
2. 圧縮モード選択（Lossless、Lossy、VRAM Compressed、Basis Universal）
3. ミップマップ生成
4. チャンネルリマップ処理
5. 法線マップ/ラフネスマップ検出・最適化
6. プラットフォーム別フォーマット出力（S3TC、ETC2、ASTC、BPTC）

**関連システム・外部連携**：ImageLoaderシステム、プロジェクト設定のVRAM圧縮設定、エディタテーマシステム（SVGカラー変換）。

**権限による制御**：エディタのインポート設定で各種オプションを制御。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | ファイルシステムドック | 遷移先機能 | 画像ファイル選択時のインポート設定連携 |
| 13 | インポートドック | 主画面 | テクスチャ・画像のインポート設定 |

## 機能種別

データ変換処理 / インポート処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| compress/mode | int | No | 圧縮モード（0-4） | 0:Lossless, 1:Lossy, 2:VRAM, 3:Uncompressed, 4:BasisU |
| compress/high_quality | bool | No | 高品質圧縮（BPTC/ASTC） | VRAM圧縮時のみ |
| compress/lossy_quality | float | No | 非可逆圧縮品質 | 0.0-1.0、デフォルト: 0.7 |
| compress/normal_map | int | No | 法線マップ設定 | 0:検出, 1:有効, 2:無効 |
| mipmaps/generate | bool | No | ミップマップ生成 | デフォルト: false (2D), true (3D) |
| mipmaps/limit | int | No | ミップマップ制限 | -1: 無制限 |
| roughness/mode | int | No | ラフネスモード | 0-6 |
| process/size_limit | int | No | サイズ制限 | 0: 無制限 |
| svg/scale | float | No | SVGスケール | 0.001-100 |

### 入力データソース

- 画像ファイル（PNG、JPG、WebP、SVG、HDR、EXR、TGA、BMP、DDS等）
- エディタのインポート設定UI

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ctex | CompressedTexture2D | 圧縮テクスチャリソース |
| variants | Array | プラットフォーム別バリアント |

### 出力先

- .ctexファイル（圧縮テクスチャ）
- プラットフォーム別バリアント（.s3tc.ctex、.etc2.ctex等）

## 処理フロー

### 処理シーケンス

```
1. 画像読み込み
   └─ ImageLoaderで画像データを取得
2. 前処理
   └─ サイズ制限、チャンネルリマップ、アルファ修正
3. 圧縮モード判定
   └─ 設定に基づき圧縮方式を選択
4. ミップマップ生成
   └─ 必要に応じてミップマップを生成
5. VRAM圧縮（該当時）
   └─ S3TC/ETC2/ASTC/BPTC形式に圧縮
6. .ctexファイル出力
   └─ GST2フォーマットで保存
7. バリアント生成
   └─ プラットフォーム別に複数形式を出力
```

### フローチャート

```mermaid
flowchart TD
    A[画像ファイル] --> B[ImageLoader読み込み]
    B --> C{SVG?}
    C -->|Yes| D[SVGラスタライズ]
    C -->|No| E[サイズ制限チェック]
    D --> E
    E --> F[チャンネルリマップ]
    F --> G{圧縮モード}
    G -->|Lossless| H[PNG/WebP圧縮]
    G -->|Lossy| I[WebP圧縮]
    G -->|VRAM| J[S3TC/ETC2/ASTC/BPTC]
    G -->|BasisU| K[Basis Universal圧縮]
    H --> L[ミップマップ生成]
    I --> L
    J --> L
    K --> L
    L --> M[.ctex出力]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 3D検出 | 3Dで使用されたテクスチャを自動検出しVRAM圧縮 | detect_3d有効時 |
| BR-02 | 法線マップ検出 | 法線マップを自動検出しRG圧縮 | detect_normal有効時 |
| BR-03 | サイズ制限 | 圧縮形式毎の最大サイズを適用 | Lossy: 16383、BasisU: 16384 |
| BR-04 | プラットフォーム別出力 | Desktop用S3TC/BPTC、Mobile用ETC2/ASTC | VRAM圧縮時 |

### 計算ロジック

- ラフネスミップマップ: 法線マップからラフネスミップを生成
- HDR露出クランプ: Filamentトーンマッピング式による露出制限

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は発生しない（ファイルベースの変換処理）。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR_CANT_OPEN | ファイルオープン失敗 | ファイル不存在 | パスを確認 |
| 警告 | サイズ超過 | サイズ制限超過 | 自動リサイズ |

### リトライ仕様

リトライは不要

## トランザクション仕様

トランザクション管理は不要

## パフォーマンス要件

- 通常画像: 高速処理
- VRAM圧縮: 圧縮処理に時間を要する
- Basis Universal: 高品質設定時は処理時間増加

## セキュリティ考慮事項

- 画像ファイルの検証（フォーマット確認）
- サイズ制限によるメモリ保護

## 備考

- GST2: Godot Streamable Texture 2Dフォーマットのマジックナンバー
- エディタ専用画像: SVGでエディタスケール/テーマカラー対応可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | resource_importer_texture.cpp | `editor/import/resource_importer_texture.cpp` | import()メソッド |

**読解のコツ**:
- **164-166行目**: get_importer_name() - "texture"を返す
- **233-272行目**: get_import_options() - インポートオプション定義
- **701-1006行目**: import() - メインインポート処理

#### Step 2: 圧縮処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | resource_importer_texture.cpp | `editor/import/resource_importer_texture.cpp` | save_to_ctex_format() |

**主要処理フロー**:
- **274-352行目**: save_to_ctex_format() - 圧縮形式別の保存処理
- **276-300行目**: COMPRESS_LOSSLESS - PNG/WebP可逆圧縮
- **301-316行目**: COMPRESS_LOSSY - WebP非可逆圧縮
- **317-327行目**: COMPRESS_VRAM_COMPRESSED - VRAM圧縮
- **338-350行目**: COMPRESS_BASIS_UNIVERSAL - Basis Universal圧縮

### プログラム呼び出し階層図

```
ResourceImporterTexture
    │
    ├─ import()
    │      ├─ ImageLoader::load_image()
    │      ├─ _remap_channels()
    │      ├─ _save_ctex()
    │      │      └─ save_to_ctex_format()
    │      └─ プラットフォーム別バリアント生成
    │
    ├─ update_imports()
    │      └─ 3D/法線マップ/ラフネス自動検出
    │
    └─ _texture_reimport_*
           └─ 再インポートコールバック
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| resource_importer_texture.cpp | `editor/import/resource_importer_texture.cpp` | ソース | メインインポーター |
| resource_importer_texture.h | `editor/import/resource_importer_texture.h` | ヘッダー | クラス定義 |
| compressed_texture.cpp | `scene/resources/compressed_texture.cpp` | ソース | 圧縮テクスチャクラス |
| image_loader.cpp | `core/io/image_loader.cpp` | ソース | 画像読み込み基盤 |
