# 機能設計書 66-オーディオインポート

## 概要

本ドキュメントは、Godot EngineにおけるWAVオーディオインポート機能の設計書である。本機能は、WAV形式のオーディオファイルを読み込み、AudioStreamWAVリソースとして変換する機能を提供する。PCM、IMA ADPCM、Quite OK Audio（QOA）の各種圧縮形式をサポートする。

### 本機能の処理概要

オーディオインポート機能は、WAV形式のサウンドファイルを解析し、ゲーム実行時に効率的に再生できるAudioStreamWAVリソースに変換する。圧縮オプションにより、ファイルサイズと音質のバランスを調整可能。

**業務上の目的・背景**：ゲーム開発において、効果音やBGMなどのオーディオアセットは重要な要素である。WAVは非圧縮の高品質フォーマットとして広く使用されているが、そのままではファイルサイズが大きい。本機能は、用途に応じた圧縮処理を行い、品質とファイルサイズを最適化する。

**機能の利用シーン**：効果音（SE）のインポート、短いBGMループのインポート、環境音のインポート。長尺のBGMにはOGG/MP3ストリーミング形式が推奨される。

**主要な処理内容**：
1. WAVファイルの解析（サンプルレート、ビット深度、チャンネル数）
2. 圧縮モード選択（PCM、IMA ADPCM、QOA）
3. ループポイント設定
4. 8bit強制変換（オプション）
5. モノラル変換（オプション）
6. サンプルレート制限（オプション）
7. トリム処理（オプション）
8. 正規化処理（オプション）

**関連システム・外部連携**：AudioStreamWAVクラス、AudioServerシステム。

**権限による制御**：エディタのインポート設定で各種オプションを制御。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 13 | インポートドック | 主画面 | WAV/OGG/MP3のインポート設定 |

## 機能種別

データ変換処理 / インポート処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| force/8_bit | bool | No | 8bit強制変換 | デフォルト: false |
| force/mono | bool | No | モノラル変換 | デフォルト: false |
| force/max_rate | bool | No | 最大レート制限有効 | デフォルト: false |
| force/max_rate_hz | float | No | 最大サンプルレート | 11025-192000、デフォルト: 44100 |
| edit/trim | bool | No | 無音トリム | デフォルト: false |
| edit/normalize | bool | No | 正規化 | デフォルト: false |
| edit/loop_mode | int | No | ループモード | 0-4、デフォルト: 0 (自動検出) |
| edit/loop_begin | int | No | ループ開始点 | サンプル単位 |
| edit/loop_end | int | No | ループ終了点 | サンプル単位、-1で末尾 |
| compress/mode | int | No | 圧縮モード | 0:PCM, 1:IMA ADPCM, 2:QOA |

### 入力データソース

- .wavファイル
- エディタのインポート設定UI

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| sample | AudioStreamWAV | 変換されたオーディオリソース |

### 出力先

- .sampleファイル（AudioStreamWAV）

## 処理フロー

### 処理シーケンス

```
1. WAVファイル読み込み
   └─ AudioStreamWAV::load_from_file()
2. オプション適用
   └─ 8bit変換、モノラル変換、レート制限等
3. 編集処理
   └─ トリム、正規化
4. ループ設定
   └─ WAV内のループポイント検出または手動設定
5. 圧縮処理
   └─ PCM/IMA ADPCM/QOA形式で出力
6. リソース保存
   └─ .sampleファイルとして保存
```

### フローチャート

```mermaid
flowchart TD
    A[.wavファイル] --> B[AudioStreamWAV::load_from_file]
    B --> C{8bit強制?}
    C -->|Yes| D[8bit変換]
    C -->|No| E{モノラル強制?}
    D --> E
    E -->|Yes| F[モノラル変換]
    E -->|No| G{レート制限?}
    F --> G
    G -->|Yes| H[リサンプリング]
    G -->|No| I{トリム?}
    H --> I
    I -->|Yes| J[無音トリム]
    I -->|No| K{正規化?}
    J --> K
    K -->|Yes| L[正規化処理]
    K -->|No| M[ループ設定]
    L --> M
    M --> N{圧縮モード}
    N -->|PCM| O[PCM出力]
    N -->|ADPCM| P[IMA ADPCM圧縮]
    N -->|QOA| Q[QOA圧縮]
    O --> R[.sample保存]
    P --> R
    Q --> R
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | ループ自動検出 | WAVファイル内のループポイントを検出 | loop_mode=0 |
| BR-02 | QOA推奨 | QOAは軽量で高品質な圧縮を提供 | デフォルト設定 |
| BR-03 | ループモード同期 | AudioStreamWAV::LoopModeと+1オフセット | ループ設定時 |

### 計算ロジック

特になし（AudioStreamWAVクラスに委譲）

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は発生しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR_CANT_OPEN | ファイルオープン失敗 | ファイル不存在 | パスを確認 |
| ERR_FILE_CORRUPT | ファイル破損 | 無効なWAVフォーマット | ファイル確認 |

### リトライ仕様

リトライは不要

## トランザクション仕様

トランザクション管理は不要

## パフォーマンス要件

- WAVパース: 高速
- QOA圧縮: 軽量・高速
- IMA ADPCM圧縮: 中程度の処理時間

## セキュリティ考慮事項

- ファイルサイズの検証

## 備考

- Quite OK Audio (QOA): 軽量で高品質な非可逆圧縮形式、デフォルト推奨
- IMA ADPCM: 従来の圧縮形式、互換性重視
- PCM: 非圧縮、最高品質
- OGG/MP3: 長尺BGM用のストリーミング形式は別インポーター

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: インポーター実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | resource_importer_wav.cpp | `editor/import/resource_importer_wav.cpp` | 全体構成 |

**読解のコツ**:
- **35-37行目**: get_importer_name() - "wav"を返す
- **76-89行目**: get_import_options() - インポートオプション定義
- **91-100行目**: import() - メインインポート処理

#### Step 2: AudioStreamWAVクラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | audio_stream_wav.cpp | `scene/resources/audio_stream_wav.cpp` | load_from_file()メソッド |

### プログラム呼び出し階層図

```
ResourceImporterWAV
    │
    ├─ import()
    │      └─ AudioStreamWAV::load_from_file()
    │             ├─ WAVヘッダー解析
    │             ├─ PCMデータ読み込み
    │             ├─ オプション処理
    │             └─ 圧縮処理
    │
    └─ ResourceSaver::save()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| resource_importer_wav.cpp | `editor/import/resource_importer_wav.cpp` | ソース | WAVインポーター |
| resource_importer_wav.h | `editor/import/resource_importer_wav.h` | ヘッダー | クラス定義 |
| audio_stream_wav.cpp | `scene/resources/audio_stream_wav.cpp` | ソース | AudioStreamWAVクラス |
