# 機能設計書 67-OpenXR対応

## 概要

本ドキュメントは、Godot EngineにおけるOpenXRサポート機能の設計書である。OpenXRはKhronos Groupが策定したVR/ARデバイス向けのオープンスタンダードAPIであり、本機能はOpenXRランタイムとの通信を担当し、様々なVR/ARヘッドセットでの動作を可能にする。

### 本機能の処理概要

OpenXR対応機能は、OpenXR APIを通じてVR/ARデバイスとの通信を行い、ヘッドトラッキング、コントローラー入力、ハンドトラッキング、レンダリング同期などのXR機能を提供する包括的なインターフェースである。

**業務上の目的・背景**：VR/AR市場では多様なデバイス（Meta Quest、Valve Index、HTC Vive、Windows Mixed Reality等）が存在する。OpenXRという標準APIを採用することで、単一のコードベースで複数のVR/ARプラットフォームをサポートし、開発効率を大幅に向上させる。

**機能の利用シーン**：VRゲームの開発、ARアプリケーションの開発、トレーニングシミュレーション、バーチャルショールーム、教育用VRコンテンツ。

**主要な処理内容**：
1. OpenXRセッション管理（初期化、開始、終了）
2. ビューポートレンダリング（ステレオレンダリング）
3. ヘッドトラッキング・ポーズ取得
4. コントローラー入力処理
5. ハンドトラッキング（オプション）
6. アクションマップ管理
7. フォビエーションレンダリング（オプション）
8. パフォーマンス設定

**関連システム・外部連携**：XRServer、RenderingServer、InputSystem。各種OpenXR拡張機能（KHR_*、FB_*等）。

**権限による制御**：プロジェクト設定でXR機能の有効化、アクションマップでの入力設定。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | XRアクションマップエディタ | 主画面 | アクションマップの編集 |

## 機能種別

デバイス連携 / ランタイムAPI

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| display_refresh_rate | float | No | ディスプレイリフレッシュレート | デバイス依存 |
| render_target_size_multiplier | float | No | レンダーターゲットサイズ倍率 | - |
| foveation_level | int | No | フォビエーションレベル | 0-4 |
| foveation_dynamic | bool | No | 動的フォビエーション | - |
| vrs_min_radius | float | No | VRS最小半径 | 1.0-100.0 |
| vrs_strength | float | No | VRS強度 | 0.1-10.0 |

### 入力データソース

- OpenXRランタイム
- VR/ARデバイスセンサー
- コントローラー入力
- プロジェクト設定
- アクションマップリソース

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| head_pose | Transform3D | ヘッド位置・回転 |
| controller_poses | Array<Transform3D> | コントローラー位置・回転 |
| hand_joint_data | Array | ハンドジョイント情報 |
| rendered_frames | Array<Texture> | レンダリング済みフレーム |

### 出力先

- XRサーバーへのポーズデータ
- VRヘッドセットへのレンダリング出力
- 入力イベントシステム

## 処理フロー

### 処理シーケンス

```
1. OpenXRインスタンス作成
   └─ xrCreateInstance()
2. システム取得
   └─ xrGetSystem()
3. セッション作成
   └─ xrCreateSession()
4. アクションセット設定
   └─ アクションマップからアクションを作成
5. レンダリングループ
   └─ xrWaitFrame() → xrBeginFrame() → render → xrEndFrame()
6. ポーズ・入力取得
   └─ xrLocateViews(), xrSyncActions()
7. セッション終了
   └─ xrDestroySession()
```

### フローチャート

```mermaid
flowchart TD
    A[initialize] --> B[xrCreateInstance]
    B --> C[xrGetSystem]
    C --> D[xrCreateSession]
    D --> E[アクションセット設定]
    E --> F{セッション状態}
    F -->|READY| G[xrBeginSession]
    G --> H[レンダリングループ]
    H --> I[xrWaitFrame]
    I --> J[xrBeginFrame]
    J --> K[ビューレンダリング]
    K --> L[xrEndFrame]
    L --> M{継続?}
    M -->|Yes| I
    M -->|No| N[xrEndSession]
    N --> O[xrDestroySession]
    F -->|STOPPING| N
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | セッション状態管理 | OpenXRセッション状態に応じた処理 | 常時 |
| BR-02 | フレーム同期 | xrWaitFrame/xrBeginFrame/xrEndFrameの順序 | レンダリング時 |
| BR-03 | アクションセット活性化 | 使用するアクションセットをアタッチ | セッション開始時 |

### 計算ロジック

- ビュープロジェクション行列の計算
- ハンドジョイント位置の相対計算

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は発生しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| XR_ERROR_RUNTIME_FAILURE | ランタイムエラー | OpenXRランタイム異常 | ランタイム再起動 |
| XR_ERROR_SESSION_LOST | セッション喪失 | ヘッドセット切断等 | 再接続処理 |
| XR_ERROR_INSTANCE_LOST | インスタンス喪失 | ランタイム終了 | 再初期化 |

### リトライ仕様

セッション喪失時は自動再接続を試行

## トランザクション仕様

トランザクション管理は不要

## パフォーマンス要件

- フレームレート: 72Hz〜120Hz（デバイス依存）
- レイテンシ: 最小限を目指す
- フォビエーション: GPU負荷軽減に有効

## セキュリティ考慮事項

- ルーム境界の尊重
- プライバシー（カメラ/ハンドトラッキングデータ）

## 備考

- 拡張機能: 多数のOpenXR拡張をサポート（ハンドトラッキング、アイトラッキング等）
- アクションマップ: GDResourceとして保存・編集可能
- 複数ランタイム: SteamVR、Oculus、WMR等に対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: インターフェース定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | openxr_interface.cpp | `modules/openxr/openxr_interface.cpp` | _bind_methods()でAPIを確認 |

**読解のコツ**:
- **43-194行目**: _bind_methods() - シグナル、プロパティ、メソッドのバインド定義
- **196-198行目**: get_name() - "OpenXR"を返す
- **123-131行目**: SESSION_STATE_* 定数

#### Step 2: コアAPI実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | openxr_api.cpp | `modules/openxr/openxr_api.cpp` | OpenXR API呼び出し |

#### Step 3: 拡張機能を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | openxr_hand_tracking_extension.cpp | `modules/openxr/extensions/openxr_hand_tracking_extension.cpp` | ハンドトラッキング |
| 3-2 | openxr_fb_foveation_extension.cpp | `modules/openxr/extensions/openxr_fb_foveation_extension.cpp` | フォビエーション |

### プログラム呼び出し階層図

```
OpenXRInterface
    │
    ├─ initialize()
    │      └─ OpenXRAPI::initialize()
    │             └─ xrCreateInstance()
    │
    ├─ process()
    │      ├─ xrWaitFrame()
    │      ├─ xrBeginFrame()
    │      └─ xrEndFrame()
    │
    ├─ OpenXRActionMap
    │      └─ アクションセット管理
    │
    └─ Extensions[]
           ├─ OpenXRHandTrackingExtension
           ├─ OpenXRFBFoveationExtension
           └─ ...
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| openxr_interface.cpp | `modules/openxr/openxr_interface.cpp` | ソース | メインインターフェース |
| openxr_api.cpp | `modules/openxr/openxr_api.cpp` | ソース | OpenXR API呼び出し |
| openxr_action_map.cpp | `modules/openxr/action_map/openxr_action_map.cpp` | ソース | アクションマップ |
| openxr_hand_tracking_extension.cpp | `modules/openxr/extensions/openxr_hand_tracking_extension.cpp` | ソース | ハンドトラッキング |
