# 機能設計書 68-XRノード

## 概要

本ドキュメントは、Godot EngineにおけるXRノード機能の設計書である。XRノードは、VR/AR体験を構築するためのシーンノード群であり、XRCamera3D、XRController3D、XROrigin3D等のノードを含む。これらのノードはXRインターフェース（OpenXR、WebXR等）と連携して動作する。

### 本機能の処理概要

XRノード機能は、VR/ARシーンを構築するための専用ノードクラス群を提供する。XROrigin3Dを原点として、XRCamera3Dでヘッドセットの視点を、XRController3Dでコントローラーの位置・入力を表現し、XRハンドモディファイアでハンドトラッキングを反映する。

**業務上の目的・背景**：VR/ARアプリケーション開発において、ヘッドセットやコントローラーの位置・回転を3Dシーンに反映する必要がある。XRノードはこれらのトラッキングデータを自動的にノードのトランスフォームに適用し、開発者がVR/ARコンテンツを容易に構築できるようにする。

**機能の利用シーン**：VRゲームのプレイヤー視点設定、コントローラーでのオブジェクト操作、ハンドトラッキングによる手のアニメーション、AR空間でのオブジェクト配置。

**主要な処理内容**：
1. XROrigin3Dによるワールド空間の原点設定
2. XRCamera3Dによるヘッドセットポーズの反映
3. XRController3Dによるコントローラートラッキング
4. XRHandModifier3Dによるハンドボーンアニメーション
5. XRBodyModifier3Dによるボディトラッキング
6. XRFaceModifier3Dによるフェイストラッキング

**関連システム・外部連携**：XRServer、XRInterface（OpenXR/WebXR）、XRTracker。

**権限による制御**：なし（ノード配置による構成）。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 4 | 3Dエディタ | 主画面 | XRノードの配置・設定 |

## 機能種別

シーンノード / トラッキング連携

## 入力仕様

### 入力パラメータ

#### XROrigin3D
| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| world_scale | float | No | ワールドスケール | デフォルト: 1.0 |
| current | bool | No | 現在のオリジンとして使用 | - |

#### XRCamera3D
| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| tracker | StringName | No | トラッカー名 | デフォルト: "head" |
| pose | StringName | No | ポーズ名 | デフォルト: "default" |

#### XRController3D
| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| tracker | StringName | No | トラッカー名 | "left_hand"/"right_hand"等 |
| pose | StringName | No | ポーズ名 | "grip"/"aim"等 |

### 入力データソース

- XRサーバーからのトラッキングデータ
- XRインターフェース（OpenXR/WebXR）
- シーンエディタでのノード設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| global_transform | Transform3D | ワールド空間での位置・回転 |
| input_events | InputEvent | コントローラー入力イベント |

### 出力先

- ノードのトランスフォーム
- 入力イベントシステム
- シグナル（button_pressed等）

## 処理フロー

### 処理シーケンス

```
1. XROrigin3D配置
   └─ シーンのXR原点として設定
2. XRCamera3D配置（XROrigin3Dの子）
   └─ ヘッドトラッカーにバインド
3. XRController3D配置（XROrigin3Dの子）
   └─ コントローラートラッカーにバインド
4. 毎フレーム更新
   └─ トラッカーからポーズを取得しトランスフォーム更新
5. 入力処理
   └─ ボタン/トリガー入力をシグナル/イベントとして発行
```

### フローチャート

```mermaid
flowchart TD
    A[XROrigin3D] --> B[XRCamera3D]
    A --> C[XRController3D Left]
    A --> D[XRController3D Right]
    B --> E[ヘッドトラッカーバインド]
    C --> F[左手トラッカーバインド]
    D --> G[右手トラッカーバインド]
    E --> H[ポーズ更新ループ]
    F --> H
    G --> H
    H --> I[トランスフォーム適用]
    H --> J[入力イベント発行]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | オリジン親子関係 | XRCamera3D/XRController3DはXROrigin3Dの子として配置 | 常時 |
| BR-02 | トラッカーバインド | tracker名に一致するトラッカーに自動バインド | トラッカー追加時 |
| BR-03 | 物理補間無効推奨 | XRCamera3Dはジッター防止のため物理補間OFFを推奨 | 常時 |

### 計算ロジック

- ポーズ変換: XRPose::get_adjusted_transform()で調整済みトランスフォーム取得
- プロジェクション: XRInterfaceからビュー毎のプロジェクション行列取得

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は発生しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 警告 | 親ノード不正 | XROrigin3Dの子でない | 親ノードを確認 |
| 警告 | 物理補間有効 | 物理補間モードがONの場合 | 設定変更を推奨 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- 毎フレームのトランスフォーム更新は軽量
- VRフレームレート（72-120Hz）に追従

## セキュリティ考慮事項

特になし

## 備考

- XRHandModifier3D: Skeleton3Dの子として配置し、ハンドジョイントを反映
- XRBodyModifier3D: 全身トラッキング対応
- XRFaceModifier3D: フェイストラッキング対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 基本ノードを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | xr_nodes.cpp | `scene/3d/xr/xr_nodes.cpp` | XRCamera3D、XRController3D、XROrigin3D |

**読解のコツ**:
- **39-47行目**: XRCamera3D::_validate_property() - エディタでの非表示プロパティ
- **49-62行目**: _bind_tracker() - トラッカーへのバインド処理
- **83-87行目**: _pose_changed() - ポーズ変更時のトランスフォーム更新
- **94-111行目**: get_configuration_warnings() - 構成警告

#### Step 2: ハンドモディファイアを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | xr_hand_modifier_3d.cpp | `scene/3d/xr/xr_hand_modifier_3d.cpp` | ハンドボーン制御 |

#### Step 3: ボディ/フェイスモディファイアを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | xr_body_modifier_3d.cpp | `scene/3d/xr/xr_body_modifier_3d.cpp` | ボディトラッキング |
| 3-2 | xr_face_modifier_3d.cpp | `scene/3d/xr/xr_face_modifier_3d.cpp` | フェイストラッキング |

### プログラム呼び出し階層図

```
XROrigin3D (シーンルート的役割)
    │
    ├─ XRCamera3D
    │      ├─ _bind_tracker("head")
    │      ├─ _pose_changed()
    │      └─ プロジェクション計算
    │
    ├─ XRController3D (左手)
    │      ├─ _bind_tracker("left_hand")
    │      ├─ _pose_changed()
    │      └─ ボタン/トリガー入力
    │
    ├─ XRController3D (右手)
    │      └─ 同上
    │
    └─ XRHandModifier3D
           └─ Skeleton3D ボーン制御
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| xr_nodes.cpp | `scene/3d/xr/xr_nodes.cpp` | ソース | XRCamera3D、XRController3D、XROrigin3D |
| xr_nodes.h | `scene/3d/xr/xr_nodes.h` | ヘッダー | クラス定義 |
| xr_hand_modifier_3d.cpp | `scene/3d/xr/xr_hand_modifier_3d.cpp` | ソース | ハンドモディファイア |
| xr_body_modifier_3d.cpp | `scene/3d/xr/xr_body_modifier_3d.cpp` | ソース | ボディモディファイア |
| xr_face_modifier_3d.cpp | `scene/3d/xr/xr_face_modifier_3d.cpp` | ソース | フェイスモディファイア |
