# 機能設計書 69-WebXR

## 概要

本ドキュメントは、Godot EngineにおけるWebXRサポート機能の設計書である。WebXRはWebブラウザ上でVR/AR体験を実現するためのJavaScript APIであり、本機能はGodotのWebエクスポートでWebXRデバイスを利用可能にする。

### 本機能の処理概要

WebXR機能は、ブラウザのWebXR Device APIを通じてVR/ARデバイスとの通信を行い、Webベースのイマーシブ体験を提供する。Emscriptenを使用してJavaScriptとの橋渡しを行う。

**業務上の目的・背景**：Webブラウザ上でVR/ARコンテンツを配信することで、アプリのインストールなしでイマーシブ体験を提供できる。Meta Quest Browser、Chrome、Edge等のWebXR対応ブラウザで動作し、より広いユーザーへのリーチを可能にする。

**機能の利用シーン**：WebVRゲーム、プロダクト3Dビューアー、バーチャルツアー、教育コンテンツ、ARウェブアプリ。

**主要な処理内容**：
1. セッションサポート確認
2. XRセッション開始/終了
3. 参照空間タイプ設定
4. 入力ソース管理
5. ハンドトラッキング（オプション）
6. 可視性状態管理
7. プレイエリア境界取得

**関連システム・外部連携**：Emscripten/JavaScript Bridge、WebGL2レンダラー、XRServer。

**権限による制御**：ブラウザのXRパーミッション（ユーザー許可）。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | ブラウザUI | 主画面 | WebXRセッション開始 |

## 機能種別

ブラウザAPI連携 / XRインターフェース

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| session_mode | String | No | セッションモード | "immersive-vr"/"immersive-ar"/"inline" |
| required_features | String | No | 必須機能 | カンマ区切り |
| optional_features | String | No | オプション機能 | カンマ区切り |
| requested_reference_space_types | String | No | 参照空間タイプ | カンマ区切り |

### 入力データソース

- ブラウザWebXR API
- XRInputSource（コントローラー/ハンド）
- スクリプトからのAPI呼び出し

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| session_supported | bool | セッションサポート状態 |
| reference_space_type | String | 使用中の参照空間タイプ |
| enabled_features | String | 有効化された機能 |
| visibility_state | String | 可視性状態 |
| play_area | PackedVector3Array | プレイエリア境界 |

### 出力先

- シグナル（session_started、session_ended等）
- XRサーバーへのトラッキングデータ

## 処理フロー

### 処理シーケンス

```
1. セッションサポート確認
   └─ is_session_supported() → session_supported シグナル
2. セッション開始
   └─ initialize() → session_started シグナル
3. 入力ソース処理
   └─ 入力イベント検出・シグナル発行
4. フレームレンダリング
   └─ WebGL2によるVRレンダリング
5. セッション終了
   └─ uninitialize() → session_ended シグナル
```

### フローチャート

```mermaid
flowchart TD
    A[is_session_supported] --> B{サポート?}
    B -->|Yes| C[session_supported = true]
    B -->|No| D[session_supported = false]
    C --> E[initialize]
    E --> F{セッション開始?}
    F -->|Yes| G[session_started シグナル]
    F -->|No| H[session_failed シグナル]
    G --> I[レンダリングループ]
    I --> J{セッション継続?}
    J -->|Yes| I
    J -->|No| K[session_ended シグナル]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | セキュアコンテキスト | HTTPSまたはlocalhost必須 | 常時 |
| BR-02 | ユーザージェスチャ | セッション開始はユーザー操作後 | セッション開始時 |
| BR-03 | 入力ソース上限 | 最大入力ソース数の制限 | 常時 |

### 計算ロジック

特になし（ブラウザAPIに委譲）

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は発生しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| session_failed | セッション失敗 | パーミッション拒否等 | ユーザーに再試行促す |
| 非対応 | 機能未サポート | ブラウザ非対応 | フォールバック処理 |

### リトライ仕様

ユーザー操作による再試行

## トランザクション仕様

該当なし

## パフォーマンス要件

- Webブラウザのフレームレート制限に依存
- WebGL2レンダラーの性能に依存

## セキュリティ考慮事項

- HTTPSコンテキスト必須
- ユーザーパーミッション要求
- プライバシー（カメラ/トラッキングデータ）

## 備考

- Web専用: WEB_ENABLEDビルドでのみ有効
- Emscripten連携: C++とJavaScript間のブリッジ
- フォールバック: 非対応時のデスクトップモード

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: インターフェース定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | webxr_interface_js.cpp | `modules/webxr/webxr_interface_js.cpp` | メインインターフェース |

**読解のコツ**:
- **50-59行目**: _emwebxr_on_session_supported - セッションサポートコールバック
- **61-73行目**: _emwebxr_on_session_started - セッション開始コールバック
- **120-122行目**: is_session_supported() - サポート確認
- **124-130行目**: set_session_mode/get_session_mode

#### Step 2: JavaScript連携を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | godot_webxr.h | `modules/webxr/godot_webxr.h` | JavaScript関数宣言 |

#### Step 3: 入力処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | webxr_interface_js.cpp | `modules/webxr/webxr_interface_js.cpp` | 入力イベント処理 |

**主要処理フロー**:
- **99-107行目**: _emwebxr_on_input_event - 入力イベントコールバック
- **164-180行目**: 入力ソース関連メソッド

### プログラム呼び出し階層図

```
WebXRInterfaceJS
    │
    ├─ is_session_supported()
    │      └─ godot_webxr_is_session_supported() [JS]
    │             └─ _emwebxr_on_session_supported() [callback]
    │
    ├─ initialize()
    │      └─ godot_webxr_initialize() [JS]
    │             └─ _emwebxr_on_session_started() [callback]
    │
    ├─ _on_input_event()
    │      └─ XRControllerTracker更新
    │
    └─ uninitialize()
           └─ _emwebxr_on_session_ended() [callback]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| webxr_interface_js.cpp | `modules/webxr/webxr_interface_js.cpp` | ソース | メインインターフェース |
| webxr_interface.cpp | `modules/webxr/webxr_interface.cpp` | ソース | 基底クラス |
| godot_webxr.h | `modules/webxr/godot_webxr.h` | ヘッダー | JS関数宣言 |
| library_godot_webxr.js | `modules/webxr/` | JavaScript | ブラウザ側実装 |
