# 機能設計書 70-TextServer

## 概要

本ドキュメントは、Godot EngineにおけるTextServer機能の設計書である。TextServerは多言語テキストのシェーピングとレンダリングを提供するサーバーAPIであり、フォント管理、テキスト整形、グリフレンダリング等の機能を提供する。

### 本機能の処理概要

TextServer機能は、テキスト処理の中核を担うサーバーインターフェースを提供する。TextServerManagerを通じて複数のTextServer実装（Advanced/Fallback）を管理し、多言語対応のテキストレンダリングを実現する。

**業務上の目的・背景**：ゲームやアプリケーションにおける多言語テキスト表示の需要に応える。アラビア語やヘブライ語の右から左への記述（RTL）、日本語・中国語・韓国語の縦書き、複雑な合字処理など、世界中の文字システムをサポートする。

**機能の利用シーン**：UI要素のテキスト表示、多言語対応ゲームのローカライズ、エディタ内のコード表示、リッチテキストの表示。

**主要な処理内容**：
1. フォントの読み込みと管理
2. テキストシェーピング（文字配置計算）
3. グリフ（字形）のレンダリング
4. 双方向テキスト（BiDi）処理
5. カシダ伸長（アラビア語均等配置）
6. 改行・単語区切り処理
7. ヒットテスト・キャレット計算

**関連システム・外部連携**：FreeType（フォントレンダリング）、HarfBuzz（テキストシェーピング）、ICU（国際化）、MSDF（距離フィールドフォント）。

**権限による制御**：なし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 全画面 | 共通基盤 | テキスト表示 |
| 1 | 2Dエディタ | 利用画面 | Label等のテキスト表示 |
| 5 | スクリプトエディタ | 利用画面 | コードテキスト表示 |

## 機能種別

サーバーAPI / テキスト処理エンジン

## 入力仕様

### 入力パラメータ

#### フォント作成
| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| data | PackedByteArray | Yes | フォントバイナリデータ | - |
| face_index | int64 | No | フェイスインデックス | 0以上 |
| antialiasing | FontAntialiasing | No | アンチエイリアシング | NONE/GRAY/LCD |
| hinting | Hinting | No | ヒンティング | NONE/LIGHT/NORMAL |
| msdf | bool | No | MSDF有効化 | - |

#### シェイプドテキスト
| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| direction | Direction | No | テキスト方向 | AUTO/LTR/RTL |
| orientation | Orientation | No | 表示方向 | HORIZONTAL/VERTICAL |
| text | String | Yes | シェーピング対象テキスト | - |
| fonts | TypedArray[RID] | Yes | フォントRID配列 | - |
| size | int64 | Yes | フォントサイズ | 正の整数 |

### 入力データソース

- フォントファイル（TTF/OTF/WOFF/BMFont）
- スクリプトからのテキスト文字列
- ICUサポートデータ（多言語処理用）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| shaped_text | RID | シェイプドテキストハンドル |
| glyphs | Array[Glyph] | グリフ配列 |
| size | Size2 | テキストサイズ |
| ascent | double | アセント（ベースライン上の高さ） |
| descent | double | ディセント（ベースライン下の深さ） |
| caret_info | CaretInfo | キャレット位置情報 |

### 出力先

- RenderingServerへのグリフ描画命令
- Label/RichTextLabel等のUIノード

## 処理フロー

### 処理シーケンス

```
1. TextServerManager初期化
   └─ インターフェース登録（Advanced/Fallback）
2. フォント作成
   └─ create_font() → RID取得
   └─ font_set_data() → フォントデータ設定
3. シェイプドテキスト作成
   └─ create_shaped_text() → RID取得
   └─ shaped_text_add_string() → テキスト追加
4. シェーピング実行
   └─ shaped_text_shape() → グリフ生成
5. レンダリング
   └─ shaped_text_draw() → 描画
```

### フローチャート

```mermaid
flowchart TD
    A[TextServerManager::get_primary_interface] --> B[create_font]
    B --> C[font_set_data]
    C --> D[create_shaped_text]
    D --> E[shaped_text_add_string]
    E --> F[shaped_text_shape]
    F --> G{シェーピング成功?}
    G -->|Yes| H[shaped_text_get_glyphs]
    G -->|No| I[エラー処理]
    H --> J[shaped_text_draw]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | インターフェース優先順位 | Advancedが利用可能ならAdvancedを優先 | 初期化時 |
| BR-02 | フォールバック | グリフが見つからない場合システムフォントにフォールバック | シェーピング時 |
| BR-03 | RID管理 | 未使用リソースは明示的にfree_rid()で解放 | 常時 |

### 計算ロジック

- グリフアドバンス: 次のグリフへのベースライン上の移動量
- カーニング: 隣接グリフ間の間隔調整
- シェーピング: HarfBuzz/ICUによる複合文字の合字・配置計算

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は発生しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR_INVALID_PARAMETER | パラメータ不正 | 無効なRID指定 | RIDの有効性確認 |
| フォント読み込み失敗 | データ不正 | 不正なフォントデータ | フォントファイル確認 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- シェーピング結果はキャッシュされる
- フォントテクスチャはオンデマンド生成
- MSDFフォントは解像度非依存でスケーラブル

## セキュリティ考慮事項

- spoof_check(): 視覚的に紛らわしい文字の検出
- is_confusable(): 類似文字列の検出

## 備考

- TextServerAdvanced: ICU/HarfBuzz統合の高機能実装
- TextServerFallback: 基本的なLTRテキストのみサポートする軽量実装
- TSマクロ: `TS->method()` でプライマリインターフェースにアクセス

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 基底クラスとマネージャーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | text_server.h | `servers/text/text_server.h` | クラス定義・enum・構造体 |
| 1-2 | text_server.cpp | `servers/text/text_server.cpp` | TextServerManager実装 |

**読解のコツ**:
- **47-49行目** (text_server.h): TextServerクラス定義 - RefCounted継承
- **51-228行目** (text_server.h): Feature、Direction、Orientation等のenum定義
- **463-621行目** (text_server.h): シェイプドテキストインターフェース
- **659-690行目** (text_server.h): TextServerManagerクラス - シングルトン
- **45-58行目** (text_server.cpp): TextServerManager::_bind_methods() - シグナル登録
- **60-73行目** (text_server.cpp): add_interface() - インターフェース登録
- **130-142行目** (text_server.cpp): set_primary_interface() - プライマリ設定
- **198-500行目** (text_server.cpp): TextServer::_bind_methods() - API登録

#### Step 2: 高機能実装（Advanced）を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | text_server_adv.cpp | `modules/text_server_adv/text_server_adv.cpp` | ICU/HarfBuzz統合 |

**読解のコツ**:
- **94行目**: HarfBuzzフォント関数テーブル
- **96-265行目**: ビットマップフォントのHarfBuzzインターフェース
- **355-380行目**: _has_feature() - サポート機能フラグ
- **382-396行目**: _get_name()/_get_features() - 実装識別

#### Step 3: フォールバック実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | text_server_fb.cpp | `modules/text_server_fb/text_server_fb.cpp` | 軽量実装 |

**読解のコツ**:
- **89-104行目**: _has_feature() - SIMPLE_LAYOUT中心
- **106-112行目**: _get_name() - "Fallback"識別
- **114-124行目**: _get_features() - 基本機能のみ

### プログラム呼び出し階層図

```
TextServerManager (シングルトン)
    │
    ├─ add_interface(TextServer)
    │      └─ interfaces配列に追加
    │
    ├─ set_primary_interface(TextServer)
    │      └─ primary_interface設定
    │
    └─ get_primary_interface() → TS マクロ
           │
           ├─ create_font() → RID
           │      └─ font_set_data()
           │      └─ font_set_antialiasing()
           │      └─ font_set_hinting()
           │
           ├─ create_shaped_text() → RID
           │      └─ shaped_text_set_direction()
           │      └─ shaped_text_add_string()
           │
           ├─ shaped_text_shape()
           │      └─ HarfBuzz::hb_shape() [Advanced]
           │      └─ 単純配置 [Fallback]
           │
           └─ shaped_text_draw()
                  └─ font_draw_glyph()
```

### データフロー図

```
┌──────────────────┐
│  フォントファイル  │
│  (TTF/OTF/WOFF)  │
└────────┬─────────┘
         │ font_set_data()
         ▼
┌──────────────────┐
│   FontData       │
│  (RID管理下)     │
└────────┬─────────┘
         │ create_shaped_text()
         ▼
┌──────────────────┐
│ ShapedTextData   │
│  + text string   │
│  + fonts array   │
└────────┬─────────┘
         │ shaped_text_shape()
         ▼
┌──────────────────┐
│   Glyph[]        │
│  位置・アドバンス │
└────────┬─────────┘
         │ shaped_text_draw()
         ▼
┌──────────────────┐
│ RenderingServer  │
│   描画コマンド    │
└──────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| text_server.h | `servers/text/text_server.h` | ヘッダー | TextServer基底クラス・TextServerManager |
| text_server.cpp | `servers/text/text_server.cpp` | ソース | 基底実装・マネージャー |
| text_server_adv.h | `modules/text_server_adv/text_server_adv.h` | ヘッダー | Advanced実装定義 |
| text_server_adv.cpp | `modules/text_server_adv/text_server_adv.cpp` | ソース | ICU/HarfBuzz統合実装 |
| text_server_fb.h | `modules/text_server_fb/text_server_fb.h` | ヘッダー | Fallback実装定義 |
| text_server_fb.cpp | `modules/text_server_fb/text_server_fb.cpp` | ソース | 軽量フォールバック実装 |
| text_server_extension.cpp | `servers/text/text_server_extension.cpp` | ソース | GDExtension拡張インターフェース |
