# 機能設計書 71-フォント管理

## 概要

本ドキュメントは、Godotエンジンにおけるフォント管理機能の設計を記述する。TrueType/OpenTypeフォントの読み込み、レンダリング、文字列描画機能を提供する。

### 本機能の処理概要

フォント管理機能は、ゲームやアプリケーションにおけるテキスト表示の基盤を提供する。TrueType/OpenType形式のフォントファイルを読み込み、TextServerと連携して多言語テキストのレンダリングを実現する。

**業務上の目的・背景**：ゲーム開発において、UI表示やダイアログ、字幕など様々な場面でテキスト表示が必要となる。フォント管理機能は、開発者が複数のフォントスタイル、サイズ、言語に対応したテキスト表示を効率的に実装できる基盤を提供する。特に多言語対応（国際化）においては、各言語に適したフォントの切り替えやフォールバック機能が重要となる。

**機能の利用シーン**：
- ゲームUIにおけるボタンラベル、メニュー項目の表示
- キャラクターの台詞やナレーションの表示
- デバッグ情報やステータス表示
- 多言語対応ゲームにおける言語別フォント切り替え

**主要な処理内容**：
1. TrueType/OpenTypeフォントファイルの読み込みとパース
2. フォントメトリクス（高さ、アセント、ディセント）の取得
3. 文字列サイズの計算（get_string_size, get_multiline_string_size）
4. Canvas上への文字列描画（draw_string, draw_multiline_string）
5. アウトライン付き文字列の描画（draw_string_outline）
6. 個別文字の描画とサイズ取得
7. フォントフォールバック機構による代替フォント適用
8. フォントバリエーション（太さ、スタイル）の管理

**関連システム・外部連携**：TextServer（テキストシェーピング）、RenderingServer（描画処理）、リソースローダー（フォントファイル読み込み）

**権限による制御**：特になし（すべてのスクリプトから利用可能）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 該当画面なし | - | フォントはプロジェクト全体で使用されるリソースのため、特定の画面に限定されない |

## 機能種別

リソース管理 / テキストレンダリング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| font_file | String | Yes | フォントファイルパス（.ttf, .otf, .woff, .woff2） | ファイル存在チェック |
| font_size | int | No | フォントサイズ（デフォルト: 16） | 0より大きい値 |
| text | String | Yes | 描画する文字列 | - |
| alignment | HorizontalAlignment | No | 水平揃え | enum値チェック |
| width | float | No | 描画幅（-1で自動） | -1以上 |
| modulate | Color | No | 描画色 | - |

### 入力データソース

- res:// 配下のフォントリソースファイル（.ttf, .otf, .woff, .woff2）
- システムフォント（SystemFont使用時）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| height | real_t | フォントの行高さ |
| ascent | real_t | ベースラインからの上部距離 |
| descent | real_t | ベースラインからの下部距離 |
| string_size | Size2 | 文字列描画サイズ |
| font_name | String | フォント名 |
| font_style | BitField | フォントスタイル（Bold, Italicなど） |

### 出力先

- Canvas上への描画（RenderingServer経由）
- メトリクス値の返却（スクリプトへ）

## 処理フロー

### 処理シーケンス

```
1. フォントリソース読み込み
   └─ FontFile/SystemFontクラスがフォントデータをパース
2. RIDの取得と管理
   └─ TextServerにフォントを登録しRIDを取得
3. フォールバック設定
   └─ 必要に応じて代替フォントを登録
4. 文字列描画リクエスト
   └─ draw_string/draw_multiline_stringの呼び出し
5. TextLineまたはTextParagraphの生成
   └─ シェーピング処理とレイアウト計算
6. キャッシュ確認
   └─ 同一パラメータの場合はキャッシュを再利用
7. 描画実行
   └─ TextServerとRenderingServer経由で描画
```

### フローチャート

```mermaid
flowchart TD
    A[フォントリソース読み込み] --> B[RID取得]
    B --> C[フォールバック設定]
    C --> D{描画リクエスト?}
    D -->|Yes| E[TextLine/TextParagraph生成]
    D -->|No| F[メトリクス返却]
    E --> G{キャッシュあり?}
    G -->|Yes| H[キャッシュから取得]
    G -->|No| I[シェーピング処理]
    I --> J[キャッシュに保存]
    H --> K[描画実行]
    J --> K
    K --> L[終了]
    F --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-71-01 | フォントフォールバック | 文字がないフォントの場合、フォールバックリストから順に検索 | has_charがfalseの場合 |
| BR-71-02 | キャッシュ管理 | 同一パラメータの描画はキャッシュを使用 | キャッシュヒット時 |
| BR-71-03 | 循環参照防止 | フォールバックチェーンの循環を検出して防止 | set_fallbacks呼び出し時 |
| BR-71-04 | 最大深度制限 | フォールバックの最大深度は64 | _update_rids_fb実行時 |

### 計算ロジック

- **行高さ計算**: `height = ascent + descent + spacing_top + spacing_bottom`
- **文字列幅計算**: TextServerによるシェーピング結果から計算

## データベース操作仕様

本機能はデータベース操作を行わない（インメモリ処理）。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR_FILE_NOT_FOUND | ファイルエラー | フォントファイルが存在しない | 有効なパスを指定 |
| ERR_INVALID_DATA | データエラー | フォントファイルが破損 | 有効なフォントを使用 |
| - | 循環参照エラー | フォールバックの循環を検出 | フォールバック設定を修正 |

### リトライ仕様

フォント読み込みにリトライ機構はない。

## トランザクション仕様

該当なし（インメモリ処理）

## パフォーマンス要件

- フォントキャッシュによる描画高速化
- TextLine/TextParagraphのキャッシュによるシェーピング結果再利用
- set_cache_capacityによるキャッシュサイズ制御

## セキュリティ考慮事項

- 外部フォントファイル読み込み時のファイルパス検証
- 不正なフォントファイルによるバッファオーバーフロー対策（FreeType/HarfBuzz内部で処理）

## 備考

- HarfBuzzによる高度なテキストシェーピングをサポート
- OpenTypeフィーチャー（リガチャー、カーニングなど）に対応
- 可変フォント（Variable Font）のバリエーション軸に対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

フォントクラスの基本構造とプロパティを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | font.h | `scene/resources/font.h` | Fontクラスの基本構造、プロパティ定義 |
| 1-2 | font.cpp | `scene/resources/font.cpp` | メソッド実装の詳細 |

**読解のコツ**: Font抽象基底クラスから派生するFontFile、SystemFont、FontVariationの継承関係を把握する。

#### Step 2: エントリーポイントを理解する

フォント描画のメインAPIを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | font.cpp | `scene/resources/font.cpp` | draw_string、draw_multiline_stringの実装 |

**主要処理フロー**:
1. **48-102行目**: _bind_methodsでGDScript向けAPIを定義
2. **104-123行目**: _update_ridsでフォントRIDを更新
3. **176-195行目**: set_fallbacksでフォールバック設定
4. **300-323行目**: get_string_sizeで文字列サイズ計算
5. **349-378行目**: draw_stringで文字列描画

#### Step 3: TextServerとの連携を理解する

フォントとTextServerの連携を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | text_line.cpp | `scene/resources/text_line.cpp` | 単一行テキストのシェーピング |
| 3-2 | text_paragraph.cpp | `scene/resources/text_paragraph.cpp` | 複数行テキストのレイアウト |

**主要処理フロー**:
- TextLineがTextServerを呼び出してシェーピング実行
- TextParagraphが行分割とレイアウト計算を担当

### プログラム呼び出し階層図

```
Font::draw_string()
    │
    ├─ Font::_update_rids()
    │      └─ Font::_update_rids_fb() [フォールバック収集]
    │
    ├─ cache.has(key) / cache.get(key)
    │      └─ [キャッシュ確認/取得]
    │
    └─ TextLine::add_string()
           │
           └─ TextServer::shaped_text_add_string()
                  │
                  └─ TextLine::draw()
                         │
                         └─ RenderingServer::canvas_item_add_*()
```

### データフロー図

```
[入力]               [処理]                    [出力]

フォントファイル ───▶ FontFile ───▶ RID取得 ───▶ TextServer
     │                                              │
文字列 ───────────▶ TextLine ────────────────────▶ シェーピング
     │                    │                         │
描画パラメータ ──────────────────────────────────▶ RenderingServer ───▶ Canvas描画
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| font.cpp | `scene/resources/font.cpp` | ソース | Fontクラス実装 |
| font.h | `scene/resources/font.h` | ヘッダー | Fontクラス定義 |
| text_line.cpp | `scene/resources/text_line.cpp` | ソース | 単一行テキスト処理 |
| text_paragraph.cpp | `scene/resources/text_paragraph.cpp` | ソース | 複数行テキスト処理 |
| font_config_plugin.cpp | `editor/scene/gui/font_config_plugin.cpp` | ソース | エディタ用フォント設定UI |
| text_server.cpp | `servers/text/text_server.cpp` | ソース | テキストシェーピングサーバー |
