# 機能設計書 72-国際化（i18n）

## 概要

本ドキュメントは、Godotエンジンにおける国際化（Internationalization: i18n）機能の設計を記述する。多言語テキストの翻訳、ロケール管理、複数形対応などの機能を提供する。

### 本機能の処理概要

国際化機能は、ゲームやアプリケーションを複数の言語・地域に対応させるための基盤を提供する。翻訳リソースの管理、ロケールの検出・切り替え、複数形の適切な処理などを行う。

**業務上の目的・背景**：グローバル市場に向けたゲーム開発において、多言語対応は必須要件となっている。国際化機能は、開発者がソースコードを変更することなく、翻訳リソースの追加・更新だけで複数言語に対応できる仕組みを提供する。

**機能の利用シーン**：
- ゲームのUI要素（ボタン、メニュー、ダイアログ）のローカライズ
- ストーリーテキストや台詞の翻訳
- 数値フォーマット（日付、通貨、数字表記）のローカル化
- 言語設定による動的な翻訳切り替え

**主要な処理内容**：
1. ロケール情報の初期化と管理（init_locale_info）
2. 翻訳リソース（.po/.csv/.xliff）の読み込み
3. メッセージの翻訳（translate, translate_plural）
4. ロケールの標準化と比較（standardize_locale, compare_locales）
5. 複数形ルールの処理（get_plural_rules）
6. 言語・スクリプト・国情報の取得
7. 擬似ローカライズ機能（pseudolocalization）
8. 翻訳ドメインの管理

**関連システム・外部連携**：TranslationDomain、Translation、POファイルローダー、プロジェクト設定

**権限による制御**：特になし（すべてのスクリプトから利用可能）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 該当画面なし | - | 国際化はアプリケーション全体で使用される基盤機能 |

## 機能種別

コアシステム / テキスト処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| locale | String | Yes | ロケール文字列（例: "ja_JP", "en_US"） | 空文字チェック |
| message | StringName | Yes | 翻訳対象のメッセージキー | - |
| context | StringName | No | メッセージのコンテキスト | - |
| n | int | No | 複数形判定用の数値 | - |
| domain | StringName | No | 翻訳ドメイン名 | - |

### 入力データソース

- res:// 配下の翻訳ファイル（.po, .csv, .xliff）
- プロジェクト設定（Project Settings）
- OS環境のロケール情報

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| translated_message | StringName | 翻訳されたメッセージ |
| locale | String | 現在のロケール |
| locale_name | String | ロケールの表示名 |
| language_name | String | 言語の表示名 |
| country_name | String | 国の表示名 |
| all_languages | Vector<String> | 対応言語コード一覧 |

### 出力先

- スクリプトへの翻訳結果返却
- ノードの翻訳プロパティ更新

## 処理フロー

### 処理シーケンス

```
1. TranslationServer初期化
   └─ init_locale_info()で言語・国・スクリプト情報を初期化
2. プロジェクト翻訳読み込み
   └─ load_project_translations()で翻訳ファイルをロード
3. ロケール設定
   └─ set_locale()でアプリケーションロケールを設定
4. 翻訳リクエスト
   └─ translate()/translate_plural()の呼び出し
5. 翻訳検索
   └─ TranslationDomainから最適な翻訳を検索
6. 複数形処理
   └─ 必要に応じて複数形ルールを適用
7. 結果返却
   └─ 翻訳されたメッセージまたは元のメッセージを返却
```

### フローチャート

```mermaid
flowchart TD
    A[TranslationServer初期化] --> B[ロケール情報初期化]
    B --> C[翻訳ファイル読み込み]
    C --> D[ロケール設定]
    D --> E{翻訳リクエスト}
    E -->|translate| F[単数形翻訳]
    E -->|translate_plural| G[複数形翻訳]
    F --> H[ドメイン検索]
    G --> I[複数形ルール適用]
    I --> H
    H --> J{翻訳存在?}
    J -->|Yes| K[翻訳返却]
    J -->|No| L[元メッセージ返却]
    K --> M[終了]
    L --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-72-01 | ロケールマッチング | 完全一致(10)→言語+スクリプト+国(8)→言語一致(5)の順で検索 | compare_locales実行時 |
| BR-72-02 | フォールバック | 翻訳が見つからない場合はfallbackロケールを使用 | 翻訳検索失敗時 |
| BR-72-03 | 複数形ルール | 言語ごとの複数形ルールに従って適切な翻訳を選択 | translate_plural呼び出し時 |
| BR-72-04 | ロケール標準化 | 入力ロケールをBCP47準拠形式に正規化 | standardize_locale呼び出し時 |

### ロケールマッチングスコア

```
完全一致: 10
言語一致 + スクリプト一致 + 国一致: 8
言語一致 + スクリプト一致: 6
言語一致 + 国一致: 6
言語一致のみ: 5
不一致: 0
```

## データベース操作仕様

本機能はデータベース操作を行わない（インメモリ処理）。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR_FAIL_COND | バリデーションエラー | 空のロケール指定 | 有効なロケールを指定 |
| - | 翻訳未発見 | 翻訳キーが存在しない | 元のメッセージを返却（フォールバック） |
| ERR_FAIL_COND_MSG | ドメインエラー | メインドメイン削除試行 | メインドメインは削除不可 |

### リトライ仕様

翻訳処理にリトライ機構はない（即座にフォールバック）。

## トランザクション仕様

該当なし（インメモリ処理）

## パフォーマンス要件

- ロケール比較結果のキャッシュ（locale_compare_cache）
- 翻訳検索のHashMapによる高速アクセス
- 起動時の一括翻訳ロード

## セキュリティ考慮事項

- 翻訳ファイルの信頼性検証（悪意のある翻訳文による攻撃防止）
- 書式文字列インジェクション対策

## 備考

- 擬似ローカライズ（pseudolocalization）機能でUIレイアウトのテストが可能
- POファイル形式（gettext互換）をサポート
- 翻訳ドメインによる名前空間分離が可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

TranslationServerの基本構造とロケール情報を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | translation_server.h | `core/string/translation_server.h` | TranslationServerクラス定義 |
| 1-2 | translation.h | `core/string/translation.h` | Translationクラス定義 |
| 1-3 | locales.h | `core/string/locales.h` | ロケール情報定義 |

**読解のコツ**: TranslationServerはシングルトンとして動作し、複数のTranslationDomainを管理する。

#### Step 2: エントリーポイントを理解する

翻訳APIのメインエントリーポイントを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | translation_server.cpp | `core/string/translation_server.cpp` | TranslationServer実装 |

**主要処理フロー**:
1. **41-153行目**: init_locale_info()でロケール情報を初期化
2. **255-276行目**: format_number()で数値フォーマット
3. **315-317行目**: standardize_locale()でロケール標準化
4. **319-375行目**: compare_locales()でロケール比較
5. **479-493行目**: set_locale()でロケール設定
6. **556-562行目**: translate()/translate_plural()で翻訳

#### Step 3: 翻訳リソース読み込みを理解する

翻訳ファイルのローダーを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | translation_loader_po.cpp | `core/io/translation_loader_po.cpp` | POファイルパーサー |
| 3-2 | translation_domain.cpp | `core/string/translation_domain.cpp` | 翻訳ドメイン管理 |

**主要処理フロー**:
- TranslationLoaderPOがPOファイルをパース
- TranslationDomainが翻訳オブジェクトを管理

### プログラム呼び出し階層図

```
TranslationServer::translate()
    │
    ├─ TranslationDomain::translate()
    │      │
    │      ├─ get_translations()
    │      │      └─ [翻訳リスト取得]
    │      │
    │      └─ Translation::get_message()
    │             │
    │             └─ messages.has(key)
    │
    └─ [翻訳結果またはフォールバック返却]
```

### データフロー図

```
[入力]               [処理]                      [出力]

POファイル ────▶ TranslationLoaderPO ───▶ Translation
     │                                           │
ロケール ─────▶ TranslationServer ────────────▶ 翻訳検索
     │               │                           │
メッセージキー ──────────────────────────────▶ TranslationDomain ───▶ 翻訳結果
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| translation_server.cpp | `core/string/translation_server.cpp` | ソース | TranslationServer実装 |
| translation_server.h | `core/string/translation_server.h` | ヘッダー | TranslationServer定義 |
| translation.cpp | `core/string/translation.cpp` | ソース | Translation実装 |
| translation_domain.cpp | `core/string/translation_domain.cpp` | ソース | TranslationDomain実装 |
| translation_loader_po.cpp | `core/io/translation_loader_po.cpp` | ソース | POファイルローダー |
| locales.h | `core/string/locales.h` | ヘッダー | ロケール情報定義 |
| locales.cpp | `core/string/locales.cpp` | ソース | ロケールデータ |
