# 機能設計書 78-Noiseジェネレーター

## 概要

本ドキュメントは、Godotエンジンにおける Noiseジェネレーター機能の設計を記述する。手続き的なノイズ生成（Perlin、Simplex、Cellularなど）とそれを使用したテクスチャ生成機能を提供する。

### 本機能の処理概要

Noiseジェネレーター機能は、FastNoiseLiteライブラリをベースに、様々なノイズアルゴリズムを使用した手続き的コンテンツ生成を可能にする。地形生成、テクスチャパターン、雲のシミュレーションなど多様な用途に対応する。

**業務上の目的・背景**：ゲーム開発において、自然な見た目の地形、テクスチャ、パターンを手続き的に生成することで、手作業を削減し、無限に変化するコンテンツを作成できる。Noiseジェネレーターは、こうしたプロシージャル生成の基盤を提供する。

**機能の利用シーン**：
- プロシージャル地形生成
- 雲や霧のテクスチャ生成
- 水面の波紋パターン
- 植生配置のランダム化
- ダメージテクスチャの生成

**主要な処理内容**：
1. 1D/2D/3Dノイズ値取得（get_noise_1d/2d/3d）
2. 2D/3D画像生成（get_image, get_image_3d）
3. シームレス画像生成（get_seamless_image）
4. ノイズの正規化処理
5. 反転処理
6. アルファブレンドによるシームレス化

**関連システム・外部連携**：FastNoiseLite、Image、NoiseTexture2D/3D

**権限による制御**：特になし（すべてのスクリプトから利用可能）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 該当画面なし | - | Noiseは特定画面に限定されないリソース |

## 機能種別

ユーティリティ / プロシージャル生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| x, y, z | real_t | Yes | ノイズ座標 | - |
| width | int | Yes | 画像幅 | 0より大きい |
| height | int | Yes | 画像高さ | 0より大きい |
| depth | int | No | 3D画像深度 | 0より大きい |
| invert | bool | No | 反転フラグ（デフォルト: false） | - |
| in_3d_space | bool | No | 3D空間でサンプリング（デフォルト: false） | - |
| normalize | bool | No | 正規化フラグ（デフォルト: true） | - |
| skirt | real_t | No | シームレスブレンド幅（デフォルト: 0.1） | - |

### 入力データソース

- スクリプトからのAPI呼び出し
- FastNoiseLiteパラメータ（シード、周波数、オクターブなど）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| noise_value | real_t | ノイズ値（-1.0〜1.0または0.0〜1.0） |
| image | Image | 生成された2D画像 |
| image_3d | TypedArray<Image> | 生成された3D画像スライス |

### 出力先

- スクリプトへの結果返却
- NoiseTexture2D/3Dへのデータ提供

## 処理フロー

### 処理シーケンス

```
1. Noise/FastNoiseLiteインスタンス生成
2. パラメータ設定（シード、周波数、ノイズタイプなど）
3. ノイズサンプリング
   └─ get_noise_1d/2d/3dで個別サンプリング
   └─ get_image/get_image_3dで画像生成
4. オプション処理
   └─ 正規化/反転/シームレス化
5. 結果返却
```

### フローチャート

```mermaid
flowchart TD
    A[FastNoiseLite設定] --> B{出力形式}
    B -->|単一値| C[get_noise_Xd]
    B -->|2D画像| D[get_image]
    B -->|3D画像| E[get_image_3d]
    B -->|シームレス| F[get_seamless_image]
    C --> G[ノイズ値返却]
    D --> H{normalize?}
    E --> H
    F --> I[ブレンド処理]
    I --> H
    H -->|Yes| J[min/max正規化]
    H -->|No| K[[-1,1]→[0,255]変換]
    J --> L{invert?}
    K --> L
    L -->|Yes| M[255-値]
    L -->|No| N[Image返却]
    M --> N
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-78-01 | サイズ検証 | width, height, depthは正の整数 | 画像生成時 |
| BR-78-02 | 正規化範囲 | normalizeなしは[-1,1]→[0,255]、ありは[min,max]→[0,255] | 画像生成時 |
| BR-78-03 | シームレススカート | ブレンド幅は画像の割合で指定 | get_seamless_image |
| BR-78-04 | グレースケール出力 | 画像はFORMAT_L8形式 | 画像生成時 |

### ノイズアルゴリズム（FastNoiseLite）

```
TYPE_VALUE           - 値ノイズ
TYPE_VALUE_CUBIC     - 値ノイズ（キュービック補間）
TYPE_PERLIN          - パーリンノイズ
TYPE_CELLULAR        - セルラーノイズ
TYPE_SIMPLEX         - シンプレックスノイズ
TYPE_SIMPLEX_SMOOTH  - シンプレックスノイズ（スムーズ）
```

## データベース操作仕様

本機能はデータベース操作を行わない（インメモリ処理）。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR_FAIL_COND_V | パラメータエラー | width/height/depth <= 0 | 正の値を指定 |

### リトライ仕様

ノイズ生成にリトライ機構はない。

## トランザクション仕様

該当なし（インメモリ処理）

## パフォーマンス要件

- 大きな画像生成は処理時間がかかる
- get_seamless_imageはより多くの計算を必要とする
- 正規化処理は2パス必要（min/max計算 + 正規化）

## セキュリティ考慮事項

特になし

## 備考

- FastNoiseLiteライブラリを使用
- シームレス画像はタイリング可能なテクスチャ生成に有用
- NoiseTexture2D/3Dでリソースとして使用可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Noise抽象クラスとFastNoiseLite派生クラスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | noise.h | `modules/noise/noise.h` | Noise基底クラス定義 |
| 1-2 | fastnoise_lite.h | `modules/noise/fastnoise_lite.h` | FastNoiseLite定義 |

**読解のコツ**: Noiseは抽象基底クラスで、get_noise_Xdが純粋仮想関数。FastNoiseLiteが実装を提供。

#### Step 2: 画像生成を理解する

ノイズから画像を生成する処理を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | noise.cpp | `modules/noise/noise.cpp` | _get_image, get_imageの実装 |

**主要処理フロー**:
1. **81-163行目**: _get_image()で画像データ生成
2. **33-51行目**: _get_seamless_image()でシームレス画像生成
3. **165-171行目**: get_image()で2D画像取得
4. **173-182行目**: get_image_3d()で3D画像取得

#### Step 3: FastNoiseLite実装を理解する

FastNoiseLiteライブラリとの連携を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | fastnoise_lite.cpp | `modules/noise/fastnoise_lite.cpp` | FastNoiseLite実装 |

**主要処理フロー**:
- get_noise_2d/3dがFastNoiseLiteライブラリを呼び出し
- 各種パラメータ設定がライブラリに反映

### プログラム呼び出し階層図

```
Noise::get_image()
    │
    └─ Noise::_get_image()
           │
           ├─ get_noise_2d() [FastNoiseLite]
           │
           ├─ [正規化処理: min/max計算]
           │
           └─ [Image生成: FORMAT_L8]

Noise::get_seamless_image()
    │
    ├─ Noise::_get_image() [拡張サイズ]
    │
    └─ Noise::_generate_seamless_image()
           │
           └─ [アルファブレンド処理]
```

### データフロー図

```
[入力]               [処理]                      [出力]

座標(x,y,z) ─────────▶ FastNoiseLite ──────────▶ ノイズ値
     │                    │
width/height ────────▶ _get_image ────────────▶ Image
     │                    │
skirt ───────────────▶ _get_seamless_image ───▶ シームレスImage
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| noise.cpp | `modules/noise/noise.cpp` | ソース | Noise基底クラス実装 |
| noise.h | `modules/noise/noise.h` | ヘッダー | Noise基底クラス定義 |
| fastnoise_lite.cpp | `modules/noise/fastnoise_lite.cpp` | ソース | FastNoiseLite実装 |
| fastnoise_lite.h | `modules/noise/fastnoise_lite.h` | ヘッダー | FastNoiseLite定義 |
| noise_texture_2d.cpp | `modules/noise/noise_texture_2d.cpp` | ソース | NoiseTexture2D |
| noise_texture_3d.cpp | `modules/noise/noise_texture_3d.cpp` | ソース | NoiseTexture3D |
