# 機能設計書 79-LightmapGI

## 概要

本ドキュメントは、Godotエンジンにおける LightmapGI機能の設計を記述する。事前計算されたライトマップによる高品質な間接照明とグローバルイルミネーション機能を提供する。

### 本機能の処理概要

LightmapGI機能は、シーン内の静的ジオメトリに対して事前にライティング計算を行い、ライトマップテクスチャとして保存する。これにより、実行時に複雑なライティング計算を行うことなく、高品質な間接照明効果を実現する。

**業務上の目的・背景**：リアルタイムグローバルイルミネーションは計算コストが高く、特にモバイルデバイスやローエンドハードウェアでは困難である。LightmapGIは事前計算により、あらゆるデバイスで高品質な照明効果を実現する。

**機能の利用シーン**：
- 建築ビジュアライゼーション
- 静的な屋内シーン
- モバイルゲームの高品質照明
- VRアプリケーションでの安定した照明

**主要な処理内容**：
1. シーン内のメッシュとライトの収集（_find_meshes_and_lights）
2. ライトマップUV展開
3. レイトレーシングによるベイク処理
4. 球面調和関数（SH）による方向性照明
5. ライトプローブによる動的オブジェクト対応
6. シャドウマスクのサポート

**関連システム・外部連携**：RenderingServer、LightmapperRD、MeshInstance3D、Light3D

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 該当画面なし | - | LightmapGIはシーン全体で使用されるノード |

## 機能種別

レンダリング / ライティング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| quality | BakeQuality | No | ベイク品質 | enum値チェック |
| bounces | int | No | 光線バウンス数 | 0-16 |
| bounce_indirect_energy | float | No | 間接光エネルギー | 0-1 |
| directional | bool | No | 方向性ライトマップ | - |
| use_denoiser | bool | No | デノイザー使用 | - |
| use_texture_for_bounces | bool | No | バウンスにテクスチャ使用 | - |
| environment_mode | EnvironmentMode | No | 環境モード | enum値チェック |
| max_texture_size | int | No | 最大テクスチャサイズ | 2048-16384 |

### 入力データソース

- シーン内のMeshInstance3D（GI_MODE_STATIC）
- シーン内のLight3D（BAKE_STATIC/BAKE_DYNAMIC）
- シーン内のLightmapProbe

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| lightmap_textures | TypedArray<TextureLayered> | ライトマップテクスチャ |
| shadowmask_textures | TypedArray<TextureLayered> | シャドウマスクテクスチャ |
| probe_data | Dictionary | ライトプローブデータ |
| user_data | Array | ユーザー（メッシュ）データ |

### 出力先

- LightmapGIDataリソース（.lmbakeファイル）
- シーン内のメッシュへのライトマップ適用

## 処理フロー

### 処理シーケンス

```
1. シーン解析
   └─ _find_meshes_and_lights()でメッシュ・ライト・プローブを収集
2. メッシュ準備
   └─ UV2チェック、メッシュデータ抽出
3. ライトマッパー初期化
   └─ LightmapperRDのセットアップ
4. ベイク実行
   └─ レイトレーシングによる照明計算
5. ライトプローブベイク
   └─ 動的オブジェクト用のプローブ計算
6. テクスチャ生成
   └─ ライトマップとシャドウマスクの生成
7. BSPツリー構築
   └─ プローブ補間用のBSP構造
8. データ保存
   └─ LightmapGIDataリソースへ保存
```

### フローチャート

```mermaid
flowchart TD
    A[シーン解析] --> B[メッシュ収集]
    B --> C[ライト収集]
    C --> D[プローブ収集]
    D --> E[ライトマッパー初期化]
    E --> F[ベイク実行]
    F --> G{ライトプローブ?}
    G -->|Yes| H[プローブベイク]
    G -->|No| I[テクスチャ生成]
    H --> J[BSPツリー構築]
    J --> I
    I --> K{シャドウマスク?}
    K -->|Yes| L[シャドウマスク生成]
    K -->|No| M[LightmapGIData保存]
    L --> M
    M --> N[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-79-01 | UV2必須 | メッシュにUV2が必要 | GI_MODE_STATICメッシュ |
| BR-79-02 | Normal必須 | メッシュにNormal属性が必要 | GI_MODE_STATICメッシュ |
| BR-79-03 | 三角形のみ | PRIMITIVETRIANGLESのみ対応 | メッシュサーフェス |
| BR-79-04 | テクスチャサイズ制限 | 最大16384まで | max_texture_size |
| BR-79-05 | フォールバック深度 | BSPの最大深度は64 | プローブBSP構築時 |

### ベイク品質定数

```
BAKE_QUALITY_LOW     - 低品質（高速）
BAKE_QUALITY_MEDIUM  - 中品質
BAKE_QUALITY_HIGH    - 高品質
BAKE_QUALITY_ULTRA   - 最高品質（低速）
```

### 環境モード定数

```
ENVIRONMENT_MODE_DISABLED   - 環境光なし
ENVIRONMENT_MODE_SCENE      - シーン環境使用
ENVIRONMENT_MODE_CUSTOM_SKY - カスタムスカイ
ENVIRONMENT_MODE_CUSTOM_COLOR - カスタムカラー
```

## データベース操作仕様

本機能はデータベース操作を行わない（ファイル処理）。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| BAKE_ERROR_NO_LIGHTMAPPER | モジュールエラー | lightmapper_rdモジュールなし | モジュール有効化 |
| BAKE_ERROR_NO_MESHES | メッシュエラー | ベイク対象メッシュなし | メッシュを追加 |
| BAKE_ERROR_NO_RAYCASTER | レイキャスターエラー | Embreeなし | 依存関係確認 |
| BAKE_ERROR_MESHES_INVALID | メッシュエラー | UV2/Normalなし | メッシュを修正 |

### リトライ仕様

ベイク処理にリトライ機構はない。

## トランザクション仕様

ベイク処理は長時間かかる可能性があるため、キャンセル機能をサポート。

## パフォーマンス要件

- ベイク処理はエディタ時のみ実行
- GPUアクセラレーション（lightmapper_rd）を推奨
- テクスチャサイズは品質とメモリのトレードオフ

## セキュリティ考慮事項

特になし（エディタ専用機能）

## 備考

- Embreeレイトレーシングライブラリを使用
- 球面調和関数（SH）による方向性照明をサポート
- シャドウマスクによる動的シャドウとの組み合わせが可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

LightmapGIとLightmapGIDataクラスの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lightmap_gi.h | `scene/3d/lightmap_gi.h` | LightmapGI/LightmapGIData定義 |
| 1-2 | lightmap_gi.cpp | `scene/3d/lightmap_gi.cpp` | 実装詳細 |

**読解のコツ**: LightmapGIはノード、LightmapGIDataはベイク結果を格納するリソース。

#### Step 2: データ管理を理解する

ライトマップデータの管理方法を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | lightmap_gi.cpp | `scene/3d/lightmap_gi.cpp` | LightmapGIData実装 |

**主要処理フロー**:
1. **46-100行目**: ユーザー（メッシュ）データ管理
2. **102-129行目**: ライトマップテクスチャ設定
3. **135-175行目**: シャドウマスクテクスチャ設定
4. **222-241行目**: キャプチャデータ（プローブ）設定

#### Step 3: ベイク処理を理解する

ライトマップのベイク処理フローを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | lightmap_gi.cpp | `scene/3d/lightmap_gi.cpp` | _find_meshes_and_lights, bake |

**主要処理フロー**:
1. **384-480行目**: _find_meshes_and_lightsでシーン解析
2. **482-500行目**: _bsp_get_simplex_sideでBSP構築

### プログラム呼び出し階層図

```
LightmapGI::bake()
    │
    ├─ _find_meshes_and_lights()
    │      │
    │      ├─ [MeshInstance3D収集]
    │      ├─ [Light3D収集]
    │      └─ [LightmapProbe収集]
    │
    ├─ Lightmapper::bake()
    │      │
    │      └─ [レイトレーシング計算]
    │
    ├─ [ライトプローブベイク]
    │      │
    │      └─ _compute_bsp_tree()
    │
    └─ LightmapGIData::set_lightmap_textures()
           │
           └─ RS::lightmap_set_textures()
```

### データフロー図

```
[入力]               [処理]                      [出力]

メッシュ(UV2) ───────▶ ライトマッパー ─────────▶ ライトマップテクスチャ
     │                    │
ライト ──────────────────────────────────────▶ シャドウマスク
     │                    │
プローブ ────────────▶ BSP構築 ─────────────────▶ プローブデータ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| lightmap_gi.cpp | `scene/3d/lightmap_gi.cpp` | ソース | LightmapGI実装 |
| lightmap_gi.h | `scene/3d/lightmap_gi.h` | ヘッダー | LightmapGI定義 |
| lightmapper_rd.cpp | `modules/lightmapper_rd/lightmapper_rd.cpp` | ソース | GPUライトマッパー |
| lightmap_probe.cpp | `scene/3d/lightmap_probe.cpp` | ソース | ライトプローブ |
