# 機能設計書 80-VoxelGI

## 概要

本ドキュメントは、Godotエンジンにおける VoxelGI機能の設計を記述する。ボクセルベースのリアルタイムグローバルイルミネーション機能を提供する。

### 本機能の処理概要

VoxelGI機能は、シーンをボクセル（3Dピクセル）化し、光の伝播をシミュレートすることでリアルタイムグローバルイルミネーションを実現する。LightmapGIとは異なり、動的な照明変化にも対応可能だが、より高い計算コストがかかる。

**業務上の目的・背景**：動的に変化する照明環境（昼夜サイクル、動く光源など）に対応した間接照明が必要な場面で、VoxelGIは事前計算なしにリアルタイムでグローバルイルミネーションを提供する。

**機能の利用シーン**：
- 昼夜サイクルのあるオープンワールドゲーム
- 動的な照明変化が必要なシーン
- リアルタイムプレビューが必要な開発環境
- デスクトップ向け高品質レンダリング

**主要な処理内容**：
1. シーンのボクセル化（Voxelizer）
2. オクトツリー構造によるデータ格納
3. 距離フィールド計算
4. 光伝播シミュレーション
5. 2バウンス照明のオプション対応
6. プローブデータのシリアライズ

**関連システム・外部連携**：RenderingServer、Voxelizer、MeshInstance3D

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 該当画面なし | - | VoxelGIはシーン全体で使用されるノード |

## 機能種別

レンダリング / ライティング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| subdiv | Subdiv | No | 分割レベル（64-512） | enum値チェック |
| size | Vector3 | Yes | VoxelGIの範囲サイズ | 各軸1.0以上 |
| dynamic_range | float | No | ダイナミックレンジ | 1-8 |
| energy | float | No | エネルギー強度 | 0-64 |
| bias | float | No | バイアス値 | 0-8 |
| normal_bias | float | No | 法線バイアス | 0-8 |
| propagation | float | No | 伝播強度 | 0-1 |
| use_two_bounces | bool | No | 2バウンス使用 | - |
| interior | bool | No | 内部モード | - |

### 入力データソース

- シーン内のMeshInstance3D（GI_MODE_STATIC）
- シーン内のMultiMeshInstance3D

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| octree_cells | Vector<uint8_t> | オクトツリーセルデータ |
| data_cells | Vector<uint8_t> | ライティングデータ |
| distance_field | Vector<uint8_t> | 距離フィールド |
| level_counts | Vector<int> | レベルごとのセル数 |
| bounds | AABB | ボクセル範囲 |
| to_cell_xform | Transform3D | セル座標変換 |

### 出力先

- VoxelGIDataリソース
- RenderingServerへのデータ転送

## 処理フロー

### 処理シーケンス

```
1. パラメータ準備
   └─ サイズ、分割レベルの設定
2. メッシュ収集
   └─ _find_meshes()でベイク対象を収集
3. Voxelizer初期化
   └─ begin_bake()でボクセル化準備
4. メッシュプロット
   └─ plot_mesh()でメッシュをボクセル化
5. 距離フィールド計算
   └─ SDFの生成
6. オクトツリー構築
   └─ ベイク結果の階層化
7. VoxelGIData生成
   └─ allocate()でデータ格納
```

### フローチャート

```mermaid
flowchart TD
    A[パラメータ設定] --> B[メッシュ収集]
    B --> C[Voxelizer初期化]
    C --> D[メッシュプロット]
    D --> E{キャンセル?}
    E -->|Yes| F[中断]
    E -->|No| G[距離フィールド計算]
    G --> H[オクトツリー構築]
    H --> I[VoxelGIData生成]
    I --> J[RenderingServer登録]
    J --> K[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-80-01 | サイズ最小値 | 各軸1.0以上必須 | set_size時 |
| BR-80-02 | GI_MODE判定 | GI_MODE_STATICのメッシュのみ対象 | メッシュ収集時 |
| BR-80-03 | 可視性チェック | is_visible_in_tree()がtrueのみ対象 | メッシュ収集時 |
| BR-80-04 | AABB交差判定 | VoxelGI範囲と交差するメッシュのみ | メッシュ収集時 |

### 分割レベル定数

```
SUBDIV_64  - 64分割（6ビット）
SUBDIV_128 - 128分割（7ビット）
SUBDIV_256 - 256分割（8ビット）
SUBDIV_512 - 512分割（9ビット）
```

## データベース操作仕様

本機能はデータベース操作を行わない（ファイル処理）。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR_FAIL_NULL | ノードエラー | 親ノードなし | 親ノードを設定 |
| ERR_FAIL_INDEX | パラメータエラー | 無効な分割レベル | 有効な値を指定 |

### リトライ仕様

ベイク処理にリトライ機構はないが、キャンセル後の再実行は可能。

## トランザクション仕様

ベイク処理は進捗コールバックによりキャンセル可能。

## パフォーマンス要件

- 分割レベルが高いほどメモリ使用量と計算時間が増加
- 2バウンスは追加の計算コストがかかる
- リアルタイム更新はGPU負荷が高い

## セキュリティ考慮事項

特になし

## 備考

- LightmapGIとは排他的に使用（同時使用非推奨）
- 動的オブジェクトへの影響はプローブ補間で近似
- 距離フィールドはPNG形式で保存（圧縮）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

VoxelGIとVoxelGIDataクラスの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | voxel_gi.h | `scene/3d/voxel_gi.h` | VoxelGI/VoxelGIData定義 |
| 1-2 | voxel_gi.cpp | `scene/3d/voxel_gi.cpp` | 実装詳細 |

**読解のコツ**: VoxelGIはノード、VoxelGIDataはベイク結果を格納するリソース。

#### Step 2: データ管理を理解する

ボクセルデータの管理方法を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | voxel_gi.cpp | `scene/3d/voxel_gi.cpp` | VoxelGIData実装 |

**主要処理フロー**:
1. **39-90行目**: _set_data/_get_dataでシリアライズ
2. **92-97行目**: allocate()でデータ割り当て
3. **127-188行目**: プロパティ設定（dynamic_range, energy等）

#### Step 3: ベイク処理を理解する

ボクセル化のベイク処理フローを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | voxel_gi.cpp | `scene/3d/voxel_gi.cpp` | _find_meshes, bake |
| 3-2 | voxelizer.cpp | `scene/3d/voxelizer.cpp` | Voxelizer実装 |

**主要処理フロー**:
1. **329-387行目**: _find_meshes()でメッシュ収集
2. **404-428行目**: get_estimated_cell_size()でセルサイズ計算
3. **430-500行目**: bake()でベイク実行

### プログラム呼び出し階層図

```
VoxelGI::bake()
    │
    ├─ _find_meshes()
    │      │
    │      ├─ [MeshInstance3D収集]
    │      └─ [MultiMeshInstance3D収集]
    │
    ├─ Voxelizer::begin_bake()
    │
    ├─ Voxelizer::plot_mesh() [繰り返し]
    │
    ├─ Voxelizer::end_bake()
    │
    └─ VoxelGIData::allocate()
           │
           └─ RS::voxel_gi_allocate_data()
```

### データフロー図

```
[入力]               [処理]                      [出力]

メッシュ ────────────▶ Voxelizer ─────────────▶ オクトツリー
     │                    │
サイズ/分割 ─────────▶ ボクセル化 ─────────────▶ 距離フィールド
     │                    │
マテリアル ──────────────────────────────────▶ ライティングデータ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| voxel_gi.cpp | `scene/3d/voxel_gi.cpp` | ソース | VoxelGI実装 |
| voxel_gi.h | `scene/3d/voxel_gi.h` | ヘッダー | VoxelGI定義 |
| voxelizer.cpp | `scene/3d/voxelizer.cpp` | ソース | ボクセル化処理 |
| voxelizer.h | `scene/3d/voxelizer.h` | ヘッダー | Voxelizer定義 |
