---
generated_at: 2026-01-23 11:45:00
metrics:
  claims_total: 36
  claims_with_evidence: 35
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート: パーティクルシステム

## 1. 概要

本レポートは「10-パーティクルシステム.md」機能設計書の記述内容について、ソースコードに基づく根拠を提示する。

## 2. 主張と根拠の対応

### 2.1 クラス構造に関する主張

| No | 主張 | 根拠 | ソース |
|----|------|------|--------|
| 1 | CPUParticles2DはNode2Dを継承 | `class CPUParticles2D : public Node2D` | cpu_particles_2d.h 38行目 |
| 2 | emitting, activeフラグがある | `bool emitting = false; bool active = false;` | cpu_particles_2d.h 83-84行目 |
| 3 | mesh, multimesh RIDがある | `RID mesh; RID multimesh;` | cpu_particles_2d.h 110-111行目 |
| 4 | particles, particle_data配列がある | `Vector<Particle> particles; Vector<float> particle_data;` | cpu_particles_2d.h 113-114行目 |
| 5 | parameters_min/max配列がある | `real_t parameters_min[PARAM_MAX]; real_t parameters_max[PARAM_MAX];` | cpu_particles_2d.h 157-158行目 |
| 6 | curve_parameters配列がある | `Ref<Curve> curve_parameters[PARAM_MAX];` | cpu_particles_2d.h 160行目 |

### 2.2 Particle構造体に関する主張

| No | 主張 | 根拠 | ソース |
|----|------|------|--------|
| 7 | transform, color, velocityがある | Particle構造体定義 | cpu_particles_2d.h 87-91行目 |
| 8 | active, time, lifetimeがある | Particle構造体定義 | cpu_particles_2d.h 92, 98-99行目 |
| 9 | ランダム化用のrand変数がある | `angle_rand, scale_rand, hue_rot_rand` | cpu_particles_2d.h 93-96行目 |

### 2.3 列挙型に関する主張

| No | 主張 | 根拠 | ソース |
|----|------|------|--------|
| 10 | DrawOrderにINDEX, LIFETIMEがある | enum定義 | cpu_particles_2d.h 43-46行目 |
| 11 | Parameterに12種類のパラメータがある | enum定義 | cpu_particles_2d.h 48-62行目 |
| 12 | EmissionShapeに7種類の形状がある | enum定義 | cpu_particles_2d.h 71-80行目 |

### 2.4 set_amount()に関する主張

| No | 主張 | 根拠 | ソース |
|----|------|------|--------|
| 13 | p_amount < 1でエラー | `ERR_FAIL_COND_MSG(p_amount < 1, ...)` | cpu_particles_2d.cpp 68行目 |
| 14 | particles.resizeを呼び出す | `particles.resize(p_amount)` | cpu_particles_2d.cpp 70行目 |
| 15 | 全パーティクルをactive = falseに初期化 | `w[i].active = false` | cpu_particles_2d.cpp 75行目 |
| 16 | particle_dataを16 * amountにリサイズ | `particle_data.resize((8 + 4 + 4) * p_amount)` | cpu_particles_2d.cpp 79行目 |
| 17 | multimesh_allocate_dataを呼び出す | `RS::multimesh_allocate_data(multimesh, p_amount, ...)` | cpu_particles_2d.cpp 80行目 |

### 2.5 set_emitting()に関する主張

| No | 主張 | 根拠 | ソース |
|----|------|------|--------|
| 18 | 同じ値なら早期リターン | `if (emitting == p_emitting) return` | cpu_particles_2d.cpp 44-46行目 |
| 19 | one_shot & !fixed_seedでシード設定 | `if (p_emitting && !use_fixed_seed && one_shot) set_seed(Math::rand())` | cpu_particles_2d.cpp 48-50行目 |
| 20 | _set_emitting()を呼び出す | `if (emitting) _set_emitting()` | cpu_particles_2d.cpp 53-55行目 |

### 2.6 _set_emitting()に関する主張

| No | 主張 | 根拠 | ソース |
|----|------|------|--------|
| 21 | active = trueに設定 | `active = true` | cpu_particles_2d.cpp 59行目 |
| 22 | set_process_internal(true)を呼び出す | `set_process_internal(true)` | cpu_particles_2d.cpp 60行目 |
| 23 | time == 0なら_update_internal()を呼び出す | `if (time == 0) _update_internal()` | cpu_particles_2d.cpp 62-64行目 |

### 2.7 set_param_min/max()に関する主張

| No | 主張 | 根拠 | ソース |
|----|------|------|--------|
| 24 | parameters_min配列に値を設定 | `parameters_min[p_param] = p_value` | cpu_particles_2d.cpp 355行目 |
| 25 | min > maxなら自動調整 | `if (parameters_min[p_param] > parameters_max[p_param]) set_param_max(...)` | cpu_particles_2d.cpp 356-358行目 |
| 26 | update_configuration_warningsを呼び出す | `update_configuration_warnings()` | cpu_particles_2d.cpp 375行目 |

### 2.8 set_param_curve()に関する主張

| No | 主張 | 根拠 | ソース |
|----|------|------|--------|
| 27 | curve_parameters配列に設定 | `curve_parameters[p_param] = p_curve` | cpu_particles_2d.cpp 396行目 |
| 28 | パラメータ種類に応じてカーブ範囲を調整 | switch文 | cpu_particles_2d.cpp 398-417行目 |

### 2.9 restart()に関する主張

| No | 主張 | 根拠 | ソース |
|----|------|------|--------|
| 29 | time, cycle, emittingをリセット | `time = 0; cycle = 0; emitting = false` | cpu_particles_2d.cpp 315-318行目 |
| 30 | 全パーティクルをactive = falseに設定 | `w[i].active = false` | cpu_particles_2d.cpp 325行目 |
| 31 | シード再設定（条件付き） | `if (!p_keep_seed && !use_fixed_seed) seed = Math::rand()` | cpu_particles_2d.cpp 328-330行目 |
| 32 | emitting = trueと_set_emitting()呼び出し | `emitting = true; _set_emitting()` | cpu_particles_2d.cpp 332-333行目 |

### 2.10 _update_mesh_texture()に関する主張

| No | 主張 | 根拠 | ソース |
|----|------|------|--------|
| 33 | テクスチャサイズからクワッド頂点を生成 | vertices計算 | cpu_particles_2d.cpp 189-194行目 |
| 34 | AtlasTextureに対応したUV計算 | AtlasTexture分岐 | cpu_particles_2d.cpp 197-210行目 |
| 35 | mesh_add_surface_from_arraysを呼び出す | `RS::mesh_add_surface_from_arrays(mesh, RS::PRIMITIVE_TRIANGLES, arr)` | cpu_particles_2d.cpp 229行目 |

## 3. 根拠なしの主張

| No | 主張 | 理由 |
|----|------|------|
| 1 | GDScriptでの使用例の構文 | GDScript実装はC++コードからは直接確認不可（ただし一般的な使用法として妥当） |

## 4. 信頼度評価

### 4.1 評価基準

- 全36主張中35主張にソースコード根拠あり
- 根拠なし1件はGDScript構文例（設計書として許容範囲）
- 全ての重要な技術的主張は行番号付きで検証済み

### 4.2 最終信頼度

**信頼度: 97%**

## 5. 検証に使用したソースファイル

| ファイル | 確認行数 | 検証項目数 |
|----------|----------|------------|
| scene/2d/cpu_particles_2d.cpp | 1-500 | 22 |
| scene/2d/cpu_particles_2d.h | 1-250 | 14 |

## 6. 特記事項

### 6.1 コード品質の観察

1. **プール方式**: パーティクルはVector配列で管理され、active/inactiveで再利用
2. **MultiMesh最適化**: フラットなfloat配列で効率的にGPUへ転送
3. **補間対応**: InterpolationDataで物理補間に対応

### 6.2 設計パターンの確認

- オブジェクトプールパターン: Particle配列の再利用
- データ指向設計: particle_dataフラット配列
- オブザーバーパターン: texture->connect_changed()
