---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：11-シェーダー.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **シェーダーモード5種類**: パーティクル・スカイ・フォグの実装詳細は未確認
  2. **パフォーマンス要件**: バックグラウンドコンパイルの具体的な実装は未検証

## 2) 参照した情報（Evidence一覧）

- E-01: `scene/resources/shader.cpp` - Shaderクラス実装
- E-02: `scene/resources/shader.h` - Shaderクラス定義
- E-03: `scene/resources/visual_shader.cpp` - Visual Shader実装
- E-04: `scene/resources/visual_shader.h` - Visual Shader定義
- E-05: `scene/resources/visual_shader_nodes.cpp` - ノード実装
- E-06: `servers/rendering/shader_preprocessor.cpp` - プリプロセッサ
- E-07: `機能一覧.csv` - 機能No.11の定義
- E-08: `画面機能マッピング.csv` - 関連画面情報

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ShaderクラスはResource継承 | E-01, E-02 | ○ |
| C-02 | set_codeがエントリーポイント | E-01 (85行目) | ○ |
| C-03 | ShaderPreprocessorでインクルード解決 | E-01 (102-103行目) | ○ |
| C-04 | shader_typeから自動的にmode判定 | E-01 (111-123行目) | ○ |
| C-05 | RenderingServerにshader_set_code送信 | E-01 (130行目) | ○ |
| C-06 | shader_ridは遅延生成される | E-01 (54-60行目) | ○ |
| C-07 | emit_changed()で変更通知 | E-01 (134行目) | ○ |
| C-08 | Visual ShaderはShaderを継承 | E-03, E-04 | ○ |
| C-09 | 5つのシェーダーモード存在 | E-01 (113-123行目), E-01 (288-292行目) | ○ |
| C-10 | default_texturesでテクスチャ管理 | E-01 (218-252行目) | ○ |
| C-11 | ResourceFormatLoaderShaderでファイル読み込み | E-01 (308-334行目) | ○ |
| C-12 | .gdshader拡張子対応 | E-01 (337行目) | ○ |
| C-13 | include依存の自動管理 | E-01 (62-65行目) | ○ |
| C-14 | 関連画面は18,42,54 | E-08 | ○ |
| C-15 | 機能説明はCSV記載と一致 | E-07 | ○ |
| C-16 | パフォーマンス要件：バックグラウンドコンパイル | **根拠なし** | △ |
| C-17 | Visual Shaderノードからコード生成 | E-03 | ○ |
| C-18 | セキュリティ：GPUサンドボックス | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **バックグラウンドコンパイル**: RenderingServerの内部実装を確認する必要がある
  - 候補：`servers/rendering/rendering_server_default.cpp` / `drivers/` 配下のGPUドライバ実装
- **GPUサンドボックス**: GPUセキュリティモデルはOS/ドライバ依存
  - 候補：Vulkan/OpenGL/Metalの仕様書 / プラットフォーム固有実装

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - コア処理フローはソースコードで確認済み
- 1: 中リスク - パフォーマンス要件の具体的な実装は未検証

## 6) レビュアーチェックリスト（最小）

- [ ] shader.cppのset_code処理フローが設計書と一致するか確認
- [ ] Visual Shaderのコード生成ロジックが正しく記述されているか確認
- [ ] 5つのシェーダーモード（spatial/canvas_item/particles/sky/fog）の動作を確認
- [ ] ShaderPreprocessorのinclude解決処理を確認
