---
generated_at: 2026-01-23 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：14-2D物理シミュレーション.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **PhysicsServer2D内部実装**: サーバーサイドの物理演算詳細は未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `scene/2d/physics/physics_body_2d.cpp` - PhysicsBody2D実装
- E-02: `scene/2d/physics/rigid_body_2d.cpp` - RigidBody2D実装
- E-03: `scene/2d/physics/static_body_2d.cpp` - StaticBody2D実装
- E-04: `scene/2d/physics/character_body_2d.cpp` - CharacterBody2D実装
- E-05: `scene/2d/physics/area_2d.cpp` - Area2D実装
- E-06: `scene/2d/physics/kinematic_collision_2d.cpp` - 衝突情報クラス
- E-07: `機能一覧.csv` - 機能No.14の定義
- E-08: `画面機能マッピング.csv` - 関連画面情報

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PhysicsBody2Dはmove_and_collideを提供 | E-01 (34行目) | ○ |
| C-02 | test_move関数の存在 | E-01 (35行目) | ○ |
| C-03 | PhysicsServer2D::body_test_motion呼び出し | E-01 (74行目) | ○ |
| C-04 | KinematicCollision2Dで衝突情報を返す | E-01 (57-64行目), E-06 | ○ |
| C-05 | cancel_slidingによるスライディング抑制 | E-01 (79-111行目) | ○ |
| C-06 | sync to physics警告 | E-01 (70-72行目) | ○ |
| C-07 | get_gravity関数 | E-01 (140-144行目) | ○ |
| C-08 | add_collision_exception_with | E-01 (159-164行目) | ○ |
| C-09 | safe_marginデフォルト値0.08 | E-01 (34行目) | ○ |
| C-10 | PhysicsBody2DはCollisionObject2D継承 | E-01 (43-44行目) | ○ |
| C-11 | 物理補間警告 | E-01 (173-181行目) | ○ |
| C-12 | 関連画面は3 | E-08 | ○ |
| C-13 | 機能説明はCSV記載と一致 | E-07 | ○ |
| C-14 | RigidBody2D/StaticBody2D/CharacterBody2D存在 | E-02, E-03, E-04 | ○ |
| C-15 | Area2D存在 | E-05 | ○ |
| C-16 | PhysicsServer2D内部の衝突検出詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **PhysicsServer2D内部実装**: `servers/physics_2d/`配下の実装詳細は未確認
  - 候補：`servers/physics_2d/godot_physics_server_2d.cpp`

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - PhysicsBody2Dの主要機能はソースコードで確認済み
- 0: 低リスク - 各種ボディタイプの存在と役割は確認済み

## 6) レビュアーチェックリスト（最小）

- [ ] move_and_collide処理フローが設計書と一致するか確認
- [ ] スライディング抑制ロジックが正しく記述されているか確認
- [ ] 各ボディタイプ（RigidBody2D、StaticBody2D、CharacterBody2D、Area2D）の違いを確認
- [ ] PhysicsServer2Dとの連携を確認
