---
generated_at: 2026-01-23 10:50:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：15-3D物理シミュレーション.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **PhysicsServer3D内部実装**: サーバーサイドの物理演算詳細は未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `scene/3d/physics/physics_body_3d.cpp` - PhysicsBody3D実装（300行読み込み）
- E-02: `scene/3d/physics/rigid_body_3d.cpp` - RigidBody3D実装
- E-03: `scene/3d/physics/static_body_3d.cpp` - StaticBody3D実装
- E-04: `scene/3d/physics/character_body_3d.cpp` - CharacterBody3D実装
- E-05: `機能一覧.csv` - 機能No.15の定義
- E-06: `画面機能マッピング.csv` - 関連画面情報

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PhysicsBody3Dはmove_and_collideを提供 | E-01 (34行目) | ○ |
| C-02 | test_move関数の存在 | E-01 (35行目) | ○ |
| C-03 | PhysicsServer3D::body_test_motion呼び出し | E-01 (110行目) | ○ |
| C-04 | max_collisionsパラメータ（3D固有） | E-01 (34行目, 89行目) | ○ |
| C-05 | 軸ロック機能（6軸） | E-01 (38-52行目, 189-200行目) | ○ |
| C-06 | BODY_AXIS_*定数 | E-01 (46-51行目) | ○ |
| C-07 | safe_marginデフォルト値0.001 | E-01 (34行目) | ○ |
| C-08 | KinematicCollision3Dで衝突情報を返す | E-01 (94-103行目) | ○ |
| C-09 | cancel_slidingによるスライディング抑制 | E-01 (115-147行目) | ○ |
| C-10 | 軸ロック処理（travel制限） | E-01 (150-154行目) | ○ |
| C-11 | get_gravity関数 | E-01 (183-187行目) | ○ |
| C-12 | add_collision_exception_with | E-01 (73-77行目) | ○ |
| C-13 | 関連画面は4 | E-06 | ○ |
| C-14 | 機能説明はCSV記載と一致 | E-05 | ○ |
| C-15 | 物理補間警告 | E-01 (214-222行目) | ○ |
| C-16 | PhysicsServer3D内部の衝突検出詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **PhysicsServer3D内部実装**: `servers/physics_3d/`配下の実装詳細は未確認
  - 候補：`servers/physics_3d/godot_physics_server_3d.cpp`

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - PhysicsBody3Dの主要機能はソースコードで確認済み
- 0: 低リスク - 2Dとの差分（軸ロック、max_collisions）は確認済み

## 6) レビュアーチェックリスト（最小）

- [ ] move_and_collide処理フローが設計書と一致するか確認
- [ ] 軸ロック機能が正しく記述されているか確認
- [ ] max_collisions（複数衝突対応）の動作を確認
- [ ] PhysicsServer3Dとの連携を確認
