---
generated_at: 2026-01-23 10:55:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-衝突検出.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `scene/2d/physics/collision_shape_2d.cpp` - CollisionShape2D実装（全306行）
- E-02: `scene/2d/physics/collision_shape_2d.h` - CollisionShape2D定義
- E-03: `機能一覧.csv` - 機能No.16の定義
- E-04: `画面機能マッピング.csv` - 関連画面情報

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NOTIFICATION_PARENTEDでシェイプオーナー作成 | E-01 (54-63行目) | ○ |
| C-02 | create_shape_owner呼び出し | E-01 (57行目) | ○ |
| C-03 | shape_owner_add_shape呼び出し | E-01 (59行目) | ○ |
| C-04 | NOTIFICATION_UNPARENTEDでシェイプオーナー削除 | E-01 (77-83行目) | ○ |
| C-05 | NOTIFICATION_DRAWでデバッグ描画 | E-01 (85-131行目) | ○ |
| C-06 | 無効時のグレースケール処理 | E-01 (99-105行目) | ○ |
| C-07 | 一方向コリジョンの矢印描画 | E-01 (111-130行目) | ○ |
| C-08 | set_shapeでシェイプ設定 | E-01 (135-157行目) | ○ |
| C-09 | changeシグナル接続/切断 | E-01 (140-141行目, 152-154行目) | ○ |
| C-10 | 親がCollisionObject必須（警告） | E-01 (174-177行目) | ○ |
| C-11 | シェイプ未設定警告 | E-01 (178-180行目) | ○ |
| C-12 | Area2Dで一方向コリジョン警告 | E-01 (181-183行目) | ○ |
| C-13 | ポリゴン形状の警告 | E-01 (185-189行目) | ○ |
| C-14 | 関連画面は3,4 | E-04 | ○ |
| C-15 | 機能説明はCSV記載と一致 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし - 全ての主要な主張に根拠が存在する

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - ソースコード全体を読み込み済みで、主要機能は確認済み

## 6) レビュアーチェックリスト（最小）

- [ ] _notification処理フローが設計書と一致するか確認
- [ ] set_shape処理が正しく記述されているか確認
- [ ] 警告条件が全て正しく列挙されているか確認
- [ ] デバッグ描画処理を確認
