---
generated_at: 2026-01-23 11:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-レイキャスト.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `scene/2d/physics/ray_cast_2d.cpp` - RayCast2D実装（全375行）
- E-02: `scene/3d/physics/ray_cast_3d.cpp` - RayCast3D実装（全562行）
- E-03: `機能一覧.csv` - 機能No.17の定義
- E-04: `画面機能マッピング.csv` - 関連画面情報

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NOTIFICATION_INTERNAL_PHYSICS_PROCESSで更新 | E-01 (172-177行目) | ○ |
| C-02 | _update_raycast_stateで実際の処理 | E-01 (181-224行目) | ○ |
| C-03 | World2Dからspace_get_direct_state取得 | E-01 (182-186行目) | ○ |
| C-04 | RayParameters構築 | E-01 (198-206行目) | ○ |
| C-05 | intersect_ray実行 | E-01 (207行目) | ○ |
| C-06 | ゼロベクトル対策 | E-01 (190-193行目) | ○ |
| C-07 | 衝突結果の保存（collided, collision_point等） | E-01 (207-219行目) | ○ |
| C-08 | 状態変化時にqueue_redraw | E-01 (221-223行目) | ○ |
| C-09 | exclude_parentの処理 | E-01 (127-134行目, 149-155行目) | ○ |
| C-10 | collision_mask_valueの設定 | E-01 (55-71行目) | ○ |
| C-11 | add_exception/remove_exception | E-01 (266-282行目) | ○ |
| C-12 | force_raycast_update | E-01 (262-264行目) | ○ |
| C-13 | collide_with_areas/collide_with_bodies | E-01 (295-309行目) | ○ |
| C-14 | hit_from_inside | E-01 (311-317行目) | ○ |
| C-15 | 関連画面は3,4 | E-04 | ○ |
| C-16 | 3D固有: hit_back_faces, collision_face_index | E-02 (107-109行目, 317-323行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし - 2Dと3Dの両方のソースコードを読み込み、全ての主要な主張を確認済み

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - ソースコード全体を読み込み済みで、主要機能は確認済み

## 6) レビュアーチェックリスト（最小）

- [ ] _update_raycast_state処理フローが設計書と一致するか確認
- [ ] RayParametersの構築が正しく記述されているか確認
- [ ] 例外リスト（exclude）の管理を確認
- [ ] 2Dと3Dの差異（hit_back_faces等）を確認
