---
generated_at: 2026-01-23 11:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-ジョイント（接合）.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `scene/2d/physics/joints/joint_2d.cpp` - Joint2D実装（全258行）
- E-02: `scene/3d/physics/joints/joint_3d.cpp` - Joint3D実装（全244行）
- E-03: `機能一覧.csv` - 機能No.18の定義
- E-04: `画面機能マッピング.csv` - 関連画面情報

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンストラクタでjoint_create | E-01 (249-252行目) | ○ |
| C-02 | NOTIFICATION_POST_ENTER_TREEで_update_joint | E-01 (173-179行目) | ○ |
| C-03 | 衝突除外の解除処理 | E-01 (56-58行目) | ○ |
| C-04 | get_node_or_nullでボディ取得 | E-01 (70-74行目) | ○ |
| C-05 | バリデーションと警告生成 | E-01 (78-91行目) | ○ |
| C-06 | joint_clearでクリア | E-01 (64-68行目, 96-98行目) | ○ |
| C-07 | force_update_transform呼び出し | E-01 (100-106行目) | ○ |
| C-08 | _configure_joint呼び出し | E-01 (110行目) | ○ |
| C-09 | joint_set_paramでバイアス設定 | E-01 (114行目) | ○ |
| C-10 | tree_exitingシグナル接続 | E-01 (119-124行目) | ○ |
| C-11 | joint_disable_collisions_between_bodies | E-01 (126行目) | ○ |
| C-12 | 3Dでsolver_priority | E-02 (105行目, 158-163行目) | ○ |
| C-13 | NOTIFICATION_EXIT_TREEで切断 | E-01 (182-187行目) | ○ |
| C-14 | 関連画面は3,4 | E-04 | ○ |
| C-15 | 機能説明はCSV記載と一致 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし - 2Dと3Dの両方のジョイント基底クラスを読み込み、全ての主要な主張を確認済み

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - ソースコード全体を読み込み済みで、主要機能は確認済み

## 6) レビュアーチェックリスト（最小）

- [ ] _update_joint処理フローが設計書と一致するか確認
- [ ] バリデーションと警告メッセージを確認
- [ ] 衝突除外の設定/解除を確認
- [ ] 2Dと3Dの差異（bias vs solver_priority）を確認
