---
generated_at: 2026-01-23 11:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-オーディオ再生.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `scene/audio/audio_stream_player.cpp` - AudioStreamPlayer実装（全307行）
- E-02: `scene/audio/audio_stream_player.h` - AudioStreamPlayer定義
- E-03: `機能一覧.csv` - 機能No.19の定義
- E-04: `画面機能マッピング.csv` - 関連画面情報

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | internalへの処理委譲 | E-01 (300-302行目) | ○ |
| C-02 | set_stream関数 | E-01 (49-51行目) | ○ |
| C-03 | set_volume_db関数 | E-01 (69-77行目) | ○ |
| C-04 | NaN拒否 | E-01 (70行目) | ○ |
| C-05 | play関数の実装 | E-01 (107-124行目) | ○ |
| C-06 | internal->play_basic()呼び出し | E-01 (108行目) | ○ |
| C-07 | AudioServer::start_playback_stream | E-01 (112行目) | ○ |
| C-08 | サンプル再生モード | E-01 (116-123行目) | ○ |
| C-09 | _get_volume_vector計算 | E-01 (181-216行目) | ○ |
| C-10 | dBからリニア変換 | E-01 (191行目) | ○ |
| C-11 | MIX_TARGET_*定数 | E-01 (295-297行目) | ○ |
| C-12 | サラウンドモード対応 | E-01 (198-213行目) | ○ |
| C-13 | max_polyphony設定 | E-01 (99-105行目, 272-273行目) | ○ |
| C-14 | autoplay設定 | E-01 (153-159行目, 286行目) | ○ |
| C-15 | bus設定 | E-01 (142-147行目, 290行目) | ○ |
| C-16 | 機能説明はCSV記載と一致 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし - ソースコード全体を読み込み、全ての主要な主張を確認済み

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - ソースコード全体を読み込み済みで、主要機能は確認済み

## 6) レビュアーチェックリスト（最小）

- [ ] play()処理フローが設計書と一致するか確認
- [ ] _get_volume_vector計算ロジックを確認
- [ ] ミックスターゲット（Stereo/Surround/Center）の動作を確認
- [ ] サンプル再生モードの処理を確認
