---
generated_at: 2026-01-23 11:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-空間オーディオ（2D/3D）.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `scene/2d/audio_stream_player_2d.cpp` - AudioStreamPlayer2D実装（全456行）
- E-02: `scene/3d/audio_stream_player_3d.cpp` - AudioStreamPlayer3D実装（全300行読み込み）
- E-03: `機能一覧.csv` - 機能No.20の定義
- E-04: `画面機能マッピング.csv` - 関連画面情報

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NOTIFICATION_INTERNAL_PHYSICS_PROCESSで更新 | E-01 (58-77行目) | ○ |
| C-02 | _update_panning関数 | E-01 (118-199行目) | ○ |
| C-03 | volume_vector初期化 | E-01 (130-134行目) | ○ |
| C-04 | max_distanceを超えると音量0 | E-01 (161-163行目) | ○ |
| C-05 | 減衰計算（pow） | E-01 (165行目) | ○ |
| C-06 | パンニング計算 | E-01 (168-179行目) | ○ |
| C-07 | panning_strength適用 | E-01 (173行目) | ○ |
| C-08 | _get_actual_bus関数 | E-01 (81-115行目) | ○ |
| C-09 | Areaオーバーライドチェック | E-01 (100-111行目) | ○ |
| C-10 | intersect_pointでエリア検出 | E-01 (99行目) | ○ |
| C-11 | set_playback_bus_exclusive | E-01 (187行目) | ○ |
| C-12 | AudioListener2Dまたはビューポート中央 | E-01 (148-157行目) | ○ |
| C-13 | 3D減衰モデル（INVERSE等） | E-02 (232-260行目) | ○ |
| C-14 | ドップラー追跡 | E-02 (275-278行目) | ○ |
| C-15 | Spcapによるサラウンドパンニング | E-02 (48-95行目) | ○ |
| C-16 | リバーブ計算（3D） | E-02 (162-229行目) | ○ |
| C-17 | 関連画面は3,4 | E-04 | ○ |
| C-18 | 機能説明はCSV記載と一致 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし - 2Dと3Dの両方のソースコードを読み込み、全ての主要な主張を確認済み

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - ソースコード全体を読み込み済みで、主要機能は確認済み

## 6) レビュアーチェックリスト（最小）

- [ ] _update_panning処理フローが設計書と一致するか確認
- [ ] 減衰計算とパンニング計算を確認
- [ ] エリアバスオーバーライドの動作を確認
- [ ] 2Dと3Dの差異（減衰モデル、ドップラー等）を確認
