---
generated_at: 2026-01-23 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：21-オーディオエフェクト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件のレイテンシ数値**：具体的な数値の根拠不足
  2. **エフェクトチェーンの直列処理順序**：コード上で順序の詳細確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `servers/audio/effects/audio_effect_reverb.h` - リバーブクラス定義
- E-02: `servers/audio/effects/audio_effect_reverb.cpp` - リバーブprocess実装（35-75行目）
- E-03: `servers/audio/effects/audio_effect_compressor.h` - コンプレッサー定義
- E-04: `servers/audio/effects/audio_effect_compressor.cpp` - コンプレッサーprocess実装（34-113行目）
- E-05: `servers/audio/effects/audio_effect_eq.h` - EQ定義、プリセット（6/10/21バンド）
- E-06: `servers/audio/effects/audio_effect_eq.cpp` - EQ処理実装（35-61行目）
- E-07: `servers/audio/audio_server.h` - Bus構造体、Effect構造体定義（238-271行目）
- E-08: `servers/audio/audio_server.cpp` - _driver_process関数（261行目〜）
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.21の定義
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.16との関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AudioEffectはリバーブ、コンプレッサー、EQなどの音響処理を提供 | E-01, E-03, E-05 | ○ |
| C-02 | AudioEffectInstanceのprocess関数で音声フレームを処理 | E-02, E-04, E-06 | ○ |
| C-03 | リバーブはプリディレイ、ルームサイズ、ダンピング、Dry/Wetパラメータを持つ | E-01 (60-67行目)、E-02 (155-189行目) | ○ |
| C-04 | コンプレッサーはthreshold、ratio、attack、release、mixパラメータを持つ | E-03 (54-60行目)、E-04 (202-231行目) | ○ |
| C-05 | EQは6/10/21バンドのプリセットをサポート | E-05 (76-98行目) | ○ |
| C-06 | AudioServerのBus構造体がエフェクトを管理 | E-07 (238-271行目) | ○ |
| C-07 | エフェクトはバスに追加されてミキシング時に処理される | E-07, E-08 | ○ |
| C-08 | リバーブは左右チャンネルを独立して処理 | E-02 (36-70行目) | ○ |
| C-09 | コンプレッサーはサイドチェーン入力をサポート | E-04 (52-57行目) | ○ |
| C-10 | EQはバンドごとにゲインをdBで設定可能 | E-06 (78-81行目) | ○ |
| C-11 | AudioServerのサンプルレートに同期して動作 | E-02 (78行目)、E-04 (36行目) | ○ |
| C-12 | コンプレッサーのゲインリダクション計算式 | E-04 (96行目) | ○ |
| C-13 | 画面No.16（オーディオバス）が主画面 | E-10 | ○ |
| C-14 | AudioEffectはinstantiate()でインスタンスを生成 | E-02 (84-89行目)、E-04 (115-127行目) | ○ |
| C-15 | predelay_feedbackは0〜0.98の範囲に制限 | E-02 (96行目) | ○ |
| C-16 | ステレオ処理で0.000521のスプレッドオフセットを使用 | E-02 (81行目) | ○ |
| C-17 | レイテンシは5-20ms | **根拠なし** | △ |
| C-18 | エフェクトチェーンは直列処理 | **コード確認必要** | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件の具体的数値**：ソースコードからは具体的なレイテンシ要件を確認できず
  - 候補：Godot公式ドキュメント / プロジェクト設定 / オーディオドライバー実装
- **エフェクトチェーンの処理順序詳細**：_mix_step内部のエフェクト適用ロジックの詳細確認が必要
  - 候補：audio_server.cppの完全な_mix_step実装

## 5) リスクフラグ（レビュー観点）
- 0: 基本的なエフェクト仕様（パラメータ、処理フロー）- 低リスク
- 1: パフォーマンス関連の数値 - 中リスク（実測値との乖離可能性）
- 0: コードリーディングガイドの行番号 - 低リスク（確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] リバーブのパラメータ範囲が実装と一致するか確認
- [ ] コンプレッサーのサイドチェーン機能の動作確認
- [ ] EQバンド数のプリセット値が正しいか確認
- [ ] パフォーマンス要件の数値を実測値と照合
- [ ] エフェクトチェーンの処理順序をデバッグで確認
