---
generated_at: 2026-01-23 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：22-オーディオバス

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **最大バス数128の根拠**：コード上の明示的な制限確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `servers/audio/audio_server.h` - AudioServer、Bus、Channel構造体定義（182-271行目）
- E-02: `servers/audio/audio_server.cpp` - バス管理API実装、_driver_process、_mix_step
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.22の定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.16との関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Bus構造体はname、solo、mute、bypass、channels、effects、volume_db、sendを持つ | E-01 (238-271行目) | ○ |
| C-02 | Channel構造体はbuffer、effect_instances、peak_volumeを持つ | E-01 (247-255行目) | ○ |
| C-03 | set_bus_count、add_bus、remove_bus等のAPI提供 | E-01 (381-387行目) | ○ |
| C-04 | set_bus_volume_db/get_bus_volume_dbでボリューム設定 | E-01 (395-396行目) | ○ |
| C-05 | set_bus_send/get_bus_sendで送信先設定 | E-01 (401-402行目) | ○ |
| C-06 | add_bus_effect/remove_bus_effectでエフェクト管理 | E-01 (413-414行目) | ○ |
| C-07 | _driver_processがオーディオ処理のエントリーポイント | E-02 (261行目〜) | ○ |
| C-08 | マスターバスはインデックス0 | E-02 (283行目: buses[0]) | ○ |
| C-09 | SpeakerModeによりチャンネル数が決定 | E-01 (186-192行目、356-368行目) | ○ |
| C-10 | soloフラグとsoledフラグで排他制御 | E-01 (240-244行目) | ○ |
| C-11 | lock/unlockでスレッドセーフティ確保 | E-01 (464-465行目) | ○ |
| C-12 | AudioBusLayoutリソースでバスレイアウト保存 | E-01 (530-563行目) | ○ |
| C-13 | 画面No.16（オーディオバス）が主画面 | E-04 | ○ |
| C-14 | バスへのエフェクト追加・有効化・無効化が可能 | E-01 (413-423行目) | ○ |
| C-15 | ピークボリュームの取得（左右チャンネル別） | E-01 (425-426行目) | ○ |
| C-16 | 最大バス数は128 | **根拠なし（推定値）** | △ |

## 4) 不足情報（Unknown / Missing）
- **最大バス数の明示的な制限**：ソースコード上に明示的な最大値定義が見つからず
  - 候補：AudioServer初期化処理 / プロジェクト設定 / ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: Bus構造体の定義内容 - 低リスク
- 0: API定義（メソッドシグネチャ） - 低リスク
- 1: 最大バス数 - 中リスク（実用上の制限確認必要）
- 0: スピーカーモードとチャンネル数の関係 - 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] Bus構造体のメンバ変数が正確に記載されているか確認
- [ ] _driver_processと_mix_stepの呼び出し関係を確認
- [ ] 最大バス数の制限について実装を確認
- [ ] ソロ/ミュートの排他制御ロジックを確認
