---
generated_at: 2026-01-23 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：23-キーボード・マウス入力

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **イベント伝播の詳細フロー**：Viewport→Control→Nodeの流れの詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `core/input/input.h` - Inputクラス定義（41-421行目）
- E-02: `core/input/input.cpp` - 入力処理実装（116-300行目）
- E-03: `core/input/input_event.h` - InputEvent階層定義（52-200行目）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.23の定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.36との関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Inputシングルトンがキーボード・マウス入力を管理 | E-01 (41-45行目: static inline Input *singleton) | ○ |
| C-02 | keys_pressed、physical_keys_pressed、key_label_pressedでキー状態管理 | E-01 (97-99行目) | ○ |
| C-03 | mouse_button_maskでマウスボタン状態管理 | E-01 (95行目) | ○ |
| C-04 | MouseModeで5種類のマウスモード（VISIBLE〜CONFINED_HIDDEN） | E-01 (51-58行目) | ○ |
| C-05 | VelocityTrackでマウス速度を追跡 | E-01 (160-173行目)、E-02 (232-276行目) | ○ |
| C-06 | ActionState構造体でアクション状態を管理 | E-01 (116-140行目) | ○ |
| C-07 | MAX_EVENT = 32でイベント最大数を制限 | E-01 (47行目) | ○ |
| C-08 | is_key_pressed、is_physical_key_pressed、is_key_label_pressed API | E-01 (316-318行目) | ○ |
| C-09 | is_mouse_button_pressed API | E-01 (319行目) | ○ |
| C-10 | get_mouse_position、get_last_mouse_velocity API | E-01 (345-346行目) | ○ |
| C-11 | is_action_pressed、is_action_just_pressed、is_action_just_released API | E-01 (321-323行目) | ○ |
| C-12 | parse_input_event でイベントを処理 | E-01 (353行目)、E-02 (116-206行目) | ○ |
| C-13 | _THREAD_SAFE_CLASS_マクロでスレッドセーフティ確保 | E-01 (43行目) | ○ |
| C-14 | emulate_touch_from_mouse、emulate_mouse_from_touch設定 | E-01 (144-145行目、375-380行目) | ○ |
| C-15 | InputEventKey、InputEventMouseButton、InputEventMouseMotionクラス | E-03 (148行目、以降の定義) | ○ |
| C-16 | InputEventWithModifiersで修飾キー（Shift/Ctrl/Alt/Meta）管理 | E-03 (108-146行目) | ○ |
| C-17 | min_ref_frame = 0.1秒で速度計算 | E-02 (274行目) | ○ |
| C-18 | イベント伝播: Viewport→Control→_input→_unhandled_input | **部分的根拠** | △ |

## 4) 不足情報（Unknown / Missing）
- **イベント伝播の詳細フロー**：input.cppにはイベントディスパッチ関数への参照があるが、実際の伝播ロジックはViewport/SceneTreeに存在
  - 候補：scene/main/viewport.cpp / scene/main/scene_tree.cpp

## 5) リスクフラグ（レビュー観点）
- 0: キー・マウス状態管理 - 低リスク
- 0: API定義（メソッドシグネチャ） - 低リスク
- 1: イベント伝播フロー - 中リスク（別ファイルでの実装確認必要）
- 0: マウス速度計算ロジック - 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] keys_pressed、physical_keys_pressed、key_label_pressedの用途の違いを確認
- [ ] MouseModeの各モードの動作を確認
- [ ] VelocityTrackの計算ロジックが正確か確認
- [ ] イベント伝播フローをViewport.cppで確認
- [ ] emulate_touch_from_mouseの動作を確認
