---
generated_at: 2026-01-23 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：24-ゲームパッド対応

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **デッドゾーン処理の詳細アルゴリズム**：正確な計算式の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `core/input/input.h` - Joypad構造体、JoyBinding構造体、JoyDeviceMapping構造体（175-255行目）
- E-02: `core/input/input.cpp` - ジョイパッド処理実装（43-65行目、338行目〜）
- E-03: `core/input/input_event.h` - InputEventJoypadButton、InputEventJoypadMotion
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.24の定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.36との関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JOYPADS_MAX = 16で最大16台のコントローラー | E-01 (90行目) | ○ |
| C-02 | Joypad構造体でコントローラー状態管理 | E-01 (175-188行目) | ○ |
| C-03 | JoyBinding構造体で入力マッピング定義 | E-01 (219-247行目) | ○ |
| C-04 | JoyDeviceMapping構造体でデバイスマッピング管理 | E-01 (249-253行目) | ○ |
| C-05 | joy_connection_changedシグナルで接続状態通知 | E-02 (206行目: ADD_SIGNAL) | ○ |
| C-06 | _joy_buttons、_joy_axes配列でSDL標準名定義 | E-02 (43-65行目) | ○ |
| C-07 | is_joy_button_pressed APIでボタン状態取得 | E-01 (320行目) | ○ |
| C-08 | get_joy_axis APIで軸値取得 | E-01 (332行目) | ○ |
| C-09 | get_joy_name APIでコントローラー名取得 | E-01 (333行目) | ○ |
| C-10 | get_connected_joypads APIで接続デバイス一覧取得 | E-01 (334行目) | ○ |
| C-11 | start_joy_vibration、stop_joy_vibration APIで振動制御 | E-01 (366-367行目) | ○ |
| C-12 | VibrationInfo構造体でweak_magnitude、strong_magnitude、duration管理 | E-01 (151-156行目) | ○ |
| C-13 | add_joy_mapping、remove_joy_mappingでカスタムマッピング管理 | E-01 (392-393行目) | ○ |
| C-14 | last_buttons、last_axis配列で前回入力状態保持 | E-01 (180-181行目) | ○ |
| C-15 | fallback_mappingでフォールバックマッピング指定 | E-01 (196行目) | ○ |
| C-16 | デッドゾーン処理の計算式 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **デッドゾーン処理の詳細アルゴリズム**：InputMapのDEFAULT_DEADZONE定義は確認したが、実際の適用ロジックの詳細確認が必要
  - 候補：input_event.cppのaction_match関数 / InputMap::_find_event関数

## 5) リスクフラグ（レビュー観点）
- 0: Joypad構造体の定義 - 低リスク
- 0: API定義（メソッドシグネチャ） - 低リスク
- 1: デッドゾーン処理 - 中リスク（計算式の確認必要）
- 0: 振動制御 - 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] JOYPADS_MAX = 16が正確か確認
- [ ] Joypad構造体のメンバ変数が正確に記載されているか確認
- [ ] VibrationInfoの各メンバの意味を確認
- [ ] デッドゾーン処理の計算式を実装で確認
- [ ] SDLマッピングデータベースとの互換性を確認
