---
generated_at: 2026-01-23 10:50:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：25-タッチ入力

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **マルチタッチ追跡の最大点数**：デバイス依存の具体的な数値確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `core/input/input.h` - VelocityTrack、touch_velocity_track、エミュレーション設定（144-191行目）
- E-02: `core/input/input.cpp` - タッチ処理実装
- E-03: `core/input/input_event.h` - InputEventScreenTouch、InputEventScreenDrag定義
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.25の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VelocityTrack構造体で速度追跡 | E-01 (160-173行目) | ○ |
| C-02 | touch_velocity_trackでタッチごとに速度管理 | E-01 (191行目) | ○ |
| C-03 | emulate_mouse_from_touch設定でマウスエミュレーション | E-01 (145行目) | ○ |
| C-04 | emulate_touch_from_mouse設定でタッチエミュレーション | E-01 (144行目) | ○ |
| C-05 | mouse_from_touch_indexでエミュレーション対象指定 | E-01 (149行目) | ○ |
| C-06 | InputEventScreenTouchでタッチ開始/終了を表現 | E-03 | ○ |
| C-07 | InputEventScreenDragでタッチ移動を表現 | E-03 | ○ |
| C-08 | min_ref_frame = 0.1秒で速度確定 | E-02 (274行目) | ○ |
| C-09 | VelocityTrack::updateで速度計算 | E-02 (232-262行目) | ○ |
| C-10 | VelocityTrack::resetで速度リセット | E-02 (264-271行目) | ○ |
| C-11 | max_ref_frame = 3.0秒で長期間経過判定 | E-02 (275行目) | ○ |
| C-12 | set_emulate_mouse_from_touch API | E-01 (379行目) | ○ |
| C-13 | is_emulating_mouse_from_touch API | E-01 (380行目) | ○ |
| C-14 | マルチタッチは5〜10点追跡 | **根拠なし（デバイス依存）** | △ |

## 4) 不足情報（Unknown / Missing）
- **マルチタッチの最大追跡点数**：Godotエンジン側での制限はなく、デバイスハードウェアに依存
  - 候補：プラットフォーム別実装 / デバイスドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: VelocityTrack構造体の定義 - 低リスク
- 0: エミュレーション設定 - 低リスク
- 1: マルチタッチ追跡点数 - 中リスク（デバイス依存のため確認困難）
- 0: 速度計算ロジック - 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] VelocityTrack構造体のメンバ変数が正確に記載されているか確認
- [ ] エミュレーション設定（emulate_mouse_from_touch、emulate_touch_from_mouse）の動作確認
- [ ] min_ref_frame、max_ref_frameの値を確認
- [ ] タッチイベントのイベント伝播フローを確認
